/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import java.util.Objects;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.menu.FruitBasketMenu;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.menu.SpiceRackMenu;
import net.blay09.mods.cookingforblockheads.tile.CookingTableBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.FruitBasketBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.SpiceRackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<CounterMenu>> counter;
    public static DeferredObject<MenuType<FridgeMenu>> fridge;
    public static DeferredObject<MenuType<FruitBasketMenu>> fruitBasket;
    public static DeferredObject<MenuType<OvenMenu>> oven;
    public static DeferredObject<MenuType<SpiceRackMenu>> spiceRack;
    public static DeferredObject<MenuType<RecipeBookMenu>> recipeBook;
    public static DeferredObject<MenuType<RecipeBookMenu>> cookingTable;
    public static DeferredObject<MenuType<RecipeBookMenu>> noFilterBook;
    public static DeferredObject<MenuType<RecipeBookMenu>> craftingBook;

    public static void initialize(BalmMenus menus) {
        counter = menus.registerMenu(ModMenus.id("counter"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = inv.f_35978_.f_19853_.m_7702_(pos);
            return new CounterMenu(windowId, inv, (CounterBlockEntity)Objects.requireNonNull(tileEntity));
        });
        fridge = menus.registerMenu(ModMenus.id("fridge"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = inv.f_35978_.f_19853_.m_7702_(pos);
            return new FridgeMenu(windowId, inv, (FridgeBlockEntity)Objects.requireNonNull(tileEntity));
        });
        fruitBasket = menus.registerMenu(ModMenus.id("fruit_basket"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = inv.f_35978_.f_19853_.m_7702_(pos);
            return new FruitBasketMenu(windowId, inv, (FruitBasketBlockEntity)Objects.requireNonNull(tileEntity));
        });
        oven = menus.registerMenu(ModMenus.id("oven"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = inv.f_35978_.f_19853_.m_7702_(pos);
            return new OvenMenu(windowId, inv, (OvenBlockEntity)Objects.requireNonNull(tileEntity));
        });
        spiceRack = menus.registerMenu(ModMenus.id("spice_rack"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = inv.f_35978_.f_19853_.m_7702_(pos);
            return new SpiceRackMenu(windowId, inv, (SpiceRackBlockEntity)Objects.requireNonNull(tileEntity));
        });
        cookingTable = menus.registerMenu(ModMenus.id("cooking_table"), (windowId, inv, data) -> {
            Level level = inv.f_35978_.f_19853_;
            BlockPos pos = data.m_130135_();
            BlockEntity tileEntity = level.m_7702_(pos);
            if (((CookingTableBlockEntity)Objects.requireNonNull(tileEntity)).hasNoFilterBook()) {
                return new RecipeBookMenu((MenuType<RecipeBookMenu>)((MenuType)cookingTable.get()), windowId, inv.f_35978_).setNoFilter().allowCrafting().setKitchenMultiBlock(KitchenMultiBlock.buildFromLocation(level, pos));
            }
            return new RecipeBookMenu((MenuType<RecipeBookMenu>)((MenuType)cookingTable.get()), windowId, inv.f_35978_).allowCrafting().setKitchenMultiBlock(KitchenMultiBlock.buildFromLocation(level, pos));
        });
        noFilterBook = menus.registerMenu(ModMenus.id("no_filter_book"), (windowId, inv, data) -> new RecipeBookMenu((MenuType<RecipeBookMenu>)((MenuType)noFilterBook.get()), windowId, inv.f_35978_).setNoFilter());
        recipeBook = menus.registerMenu(ModMenus.id("recipe_book"), (windowId, inv, data) -> new RecipeBookMenu((MenuType<RecipeBookMenu>)((MenuType)recipeBook.get()), windowId, inv.f_35978_));
        craftingBook = menus.registerMenu(ModMenus.id("crafting_book"), (windowId, inv, data) -> new RecipeBookMenu((MenuType<RecipeBookMenu>)((MenuType)craftingBook.get()), windowId, inv.f_35978_).allowCrafting());
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("cookingforblockheads", name);
    }
}

