/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2828;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.CommonDataHolder;
import org.vivecraft.api.CommonNetworkHelper;
import org.vivecraft.gameplay.VRPlayer;
import org.vivecraft.render.PlayerModelController;
import org.vivecraft.render.RenderPass;
import org.vivecraft.settings.AutoCalibration;
import org.vivecraft.settings.VRSettings;
import org.vivecraft.utils.lwjgl.Matrix4f;
import org.vivecraft.utils.math.Quaternion;

public class ClientNetworkHelper {
    public static final class_2960 channel = new class_2960("vivecraft:data");
    public static boolean displayedChatMessage = false;
    public static boolean serverWantsData = false;
    public static boolean serverAllowsClimbey = false;
    public static boolean serverSupportsDirectTeleport = false;
    public static boolean serverAllowsCrawling = false;
    private static float worldScallast = 0.0f;
    private static float heightlast = 0.0f;
    private static float capturedYaw;
    private static float capturedPitch;
    private static boolean overrideActive;
    public static boolean needsReset;

    public static class_2817 getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators command, byte[] payload) {
        class_2540 friendlybytebuf = new class_2540(Unpooled.buffer());
        friendlybytebuf.writeByte(command.ordinal());
        friendlybytebuf.writeBytes(payload);
        return new class_2817(channel, friendlybytebuf);
    }

    public static void resetServerSettings() {
        worldScallast = 0.0f;
        heightlast = 0.0f;
        serverAllowsClimbey = false;
        serverWantsData = false;
        serverSupportsDirectTeleport = false;
        serverAllowsCrawling = false;
    }

    public static void sendVersionInfo() {
        byte[] abyte = CommonDataHolder.getInstance().minecriftVerString.getBytes(Charsets.UTF_8);
        String s = channel.toString();
        class_2540 friendlybytebuf = new class_2540(Unpooled.buffer());
        friendlybytebuf.writeBytes(s.getBytes());
        class_310.method_1551().method_1562().method_2883((class_2596)new class_2817(new class_2960("minecraft:register"), friendlybytebuf));
        class_310.method_1551().method_1562().method_2883((class_2596)ClientNetworkHelper.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.VERSION, abyte));
    }

    public static void sendVRPlayerPositions(VRPlayer player) {
        if (serverWantsData && class_310.method_1551().method_1562() != null) {
            float f1;
            float f = ClientDataHolder.getInstance().vrPlayer.vrdata_world_post.worldScale;
            if (f != worldScallast) {
                ByteBuf bytebuf = Unpooled.buffer();
                bytebuf.writeFloat(f);
                byte[] abyte = new byte[bytebuf.readableBytes()];
                bytebuf.readBytes(abyte);
                class_2817 serverboundcustompayloadpacket = ClientNetworkHelper.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.WORLDSCALE, abyte);
                class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket);
                worldScallast = f;
            }
            if ((f1 = AutoCalibration.getPlayerHeight()) != heightlast) {
                ByteBuf bytebuf2 = Unpooled.buffer();
                bytebuf2.writeFloat(f1 / 1.52f);
                byte[] abyte3 = new byte[bytebuf2.readableBytes()];
                bytebuf2.readBytes(abyte3);
                class_2817 serverboundcustompayloadpacket1 = ClientNetworkHelper.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.HEIGHT, abyte3);
                class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket1);
                heightlast = f1;
            }
            Object abyte2 = null;
            byte[] abyte4 = null;
            byte[] abyte5 = null;
            FloatBuffer floatbuffer = player.vrdata_world_post.hmd.getMatrix().toFloatBuffer();
            ((Buffer)floatbuffer).rewind();
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.load(floatbuffer);
            class_243 vec3 = player.vrdata_world_post.getEye(RenderPass.CENTER).getPosition().method_1020(class_310.method_1551().field_1724.method_19538());
            Quaternion quaternion = new Quaternion(matrix4f);
            ByteBuf bytebuf1 = Unpooled.buffer();
            bytebuf1.writeBoolean(ClientDataHolder.getInstance().vrSettings.seated);
            bytebuf1.writeFloat((float)vec3.field_1352);
            bytebuf1.writeFloat((float)vec3.field_1351);
            bytebuf1.writeFloat((float)vec3.field_1350);
            bytebuf1.writeFloat(quaternion.w);
            bytebuf1.writeFloat(quaternion.x);
            bytebuf1.writeFloat(quaternion.y);
            bytebuf1.writeFloat(quaternion.z);
            byte[] abyte1 = new byte[bytebuf1.readableBytes()];
            bytebuf1.readBytes(abyte1);
            class_2817 serverboundcustompayloadpacket2 = ClientNetworkHelper.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.HEADDATA, abyte1);
            class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket2);
            for (int i = 0; i < 2; ++i) {
                class_243 vec31 = player.vrdata_world_post.getController(i).getPosition().method_1020(class_310.method_1551().field_1724.method_19538());
                FloatBuffer floatbuffer1 = player.vrdata_world_post.getController(i).getMatrix().toFloatBuffer();
                ((Buffer)floatbuffer1).rewind();
                Matrix4f matrix4f1 = new Matrix4f();
                matrix4f1.load(floatbuffer1);
                Quaternion quaternion1 = new Quaternion(matrix4f1);
                ByteBuf bytebuf3 = Unpooled.buffer();
                bytebuf3.writeBoolean(ClientDataHolder.getInstance().vrSettings.reverseHands);
                bytebuf3.writeFloat((float)vec31.field_1352);
                bytebuf3.writeFloat((float)vec31.field_1351);
                bytebuf3.writeFloat((float)vec31.field_1350);
                bytebuf3.writeFloat(quaternion1.w);
                bytebuf3.writeFloat(quaternion1.x);
                bytebuf3.writeFloat(quaternion1.y);
                bytebuf3.writeFloat(quaternion1.z);
                byte[] abyte6 = new byte[bytebuf3.readableBytes()];
                if (i == 0) {
                    abyte4 = abyte6;
                } else {
                    abyte5 = abyte6;
                }
                bytebuf3.readBytes(abyte6);
                class_2817 serverboundcustompayloadpacket3 = ClientNetworkHelper.getVivecraftClientPacket(i == 0 ? CommonNetworkHelper.PacketDiscriminators.CONTROLLER0DATA : CommonNetworkHelper.PacketDiscriminators.CONTROLLER1DATA, abyte6);
                class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket3);
            }
            PlayerModelController.getInstance().Update(class_310.method_1551().field_1724.method_7334().getId(), abyte1, abyte4, abyte5, f, f1 / 1.52f, true);
        }
    }

    public static boolean isLimitedSurvivalTeleport() {
        return ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.LIMIT_TELEPORT).getBoolean();
    }

    public static int getTeleportUpLimit() {
        return ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_UP_LIMIT).getInt();
    }

    public static int getTeleportDownLimit() {
        return ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_DOWN_LIMIT).getInt();
    }

    public static int getTeleportHorizLimit() {
        return ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_HORIZ_LIMIT).getInt();
    }

    public static void sendActiveHand(byte c) {
        if (serverWantsData) {
            class_2817 serverboundcustompayloadpacket = ClientNetworkHelper.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.ACTIVEHAND, new byte[]{c});
            if (class_310.method_1551().method_1562() != null) {
                class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket);
            }
        }
    }

    public static void overridePose(class_746 player) {
        if (ClientDataHolder.getInstance().crawlTracker.crawling) {
            player.method_18380(class_4050.field_18079);
        }
    }

    public static void overrideLook(class_1657 player, class_243 view) {
        if (!serverWantsData) {
            capturedPitch = player.method_36455();
            capturedYaw = player.method_36454();
            float f = (float)Math.toDegrees(Math.asin(-view.field_1351 / view.method_1033()));
            float f1 = (float)Math.toDegrees(Math.atan2(-view.field_1352, view.field_1350));
            ((class_746)player).field_3944.method_2883((class_2596)new class_2828.class_2831(f1, f, player.method_24828()));
            overrideActive = true;
        }
    }

    public static void restoreLook(class_1657 player) {
        if (!serverWantsData && overrideActive) {
            ((class_746)player).field_3944.method_2883((class_2596)new class_2828.class_2831(capturedYaw, capturedPitch, player.method_24828()));
            overrideActive = false;
        }
    }

    static {
        needsReset = true;
    }
}

