/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.gameplay.trackers;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2541;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.api.BlockTags;
import org.vivecraft.api.ClientNetworkHelper;
import org.vivecraft.extensions.GameRendererExtension;
import org.vivecraft.extensions.PlayerExtension;
import org.vivecraft.gameplay.VRMovementStyle;
import org.vivecraft.gameplay.trackers.Tracker;
import org.vivecraft.provider.openvr_jna.OpenVRUtil;
import org.vivecraft.utils.Utils;
import org.vivecraft.utils.math.Angle;
import org.vivecraft.utils.math.Matrix4f;
import org.vivecraft.utils.math.Quaternion;
import org.vivecraft.utils.math.Vector3;

public class TeleportTracker
extends Tracker {
    private float teleportEnergy;
    private class_243 movementTeleportDestination = new class_243(0.0, 0.0, 0.0);
    private class_2350 movementTeleportDestinationSideHit;
    public double movementTeleportProgress;
    public double movementTeleportDistance;
    private class_243[] movementTeleportArc = new class_243[50];
    public int movementTeleportArcSteps = 0;
    public double lastTeleportArcDisplayOffset = 0.0;
    public VRMovementStyle vrMovementStyle;

    public TeleportTracker(class_310 mc, ClientDataHolder dh) {
        super(mc, dh);
        this.vrMovementStyle = new VRMovementStyle(dh);
    }

    public float getTeleportEnergy() {
        return this.teleportEnergy;
    }

    public boolean isAiming() {
        return this.movementTeleportProgress > 0.0;
    }

    public class_243 getDestination() {
        return this.movementTeleportDestination;
    }

    @Override
    public boolean isActive(class_746 p) {
        if (p == null) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (!p.method_5805()) {
            return false;
        }
        return !p.method_6113();
    }

    @Override
    public void reset(class_746 player) {
        this.movementTeleportDestination = new class_243(0.0, 0.0, 0.0);
        this.movementTeleportArcSteps = 0;
        this.movementTeleportProgress = 0.0;
    }

    @Override
    public void doProcess(class_746 player) {
        boolean flag2;
        Random random = new Random();
        if (this.teleportEnergy < 100.0f) {
            this.teleportEnergy += 1.0f;
        }
        boolean flag = false;
        class_243 vec3 = null;
        boolean flag1 = this.dh.vr.keyTeleport.method_1434() && this.dh.vrPlayer.isTeleportEnabled();
        boolean bl = flag2 = this.dh.vrSettings.seated && !this.dh.vrPlayer.getFreeMove() && (player.field_3913.field_3905 != 0.0f || player.field_3913.field_3907 != 0.0f);
        if ((flag1 || flag2) && !player.method_5765()) {
            vec3 = this.movementTeleportDestination;
            if (this.vrMovementStyle.teleportOnRelease) {
                if (((PlayerExtension)player).getMovementTeleportTimer() == 0) {
                    String string = this.vrMovementStyle.startTeleportingSound;
                }
                ((PlayerExtension)player).setMovementTeleportTimer(((PlayerExtension)player).getMovementTeleportTimer() + 1);
                if (((PlayerExtension)player).getMovementTeleportTimer() > 0) {
                    this.movementTeleportProgress = (float)((PlayerExtension)player).getMovementTeleportTimer() / 1.0f;
                    if (this.movementTeleportProgress >= 1.0) {
                        this.movementTeleportProgress = 1.0;
                    }
                    if (vec3.field_1352 != 0.0 || vec3.field_1351 != 0.0 || vec3.field_1350 != 0.0) {
                        class_243 vec38 = this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition();
                        class_243 vec31 = vec3.method_1031(-vec38.field_1352, -vec38.field_1351, -vec38.field_1350).method_1029();
                        class_243 vec32 = player.method_5720();
                        class_243 vec33 = vec32.method_1036(new class_243(0.0, 1.0, 0.0));
                        class_243 vec34 = vec33.method_1036(vec32);
                        if (this.vrMovementStyle.airSparkles) {
                            for (int i = 0; i < 3; ++i) {
                                double d0 = random.nextDouble() * 1.0 + 3.5;
                                double d1 = random.nextDouble() * 2.5;
                                double d2 = random.nextDouble() * 4.0 - 2.0;
                                class_243 vec36 = new class_243(vec38.field_1352 + vec32.field_1352 * d0, vec38.field_1351 + vec32.field_1351 * d0, vec38.field_1350 + vec32.field_1350 * d0);
                                vec36 = vec36.method_1031(vec33.field_1352 * d2, vec33.field_1351 * d2, vec33.field_1350 * d2);
                                vec36.method_1031(vec34.field_1352 * d1, vec34.field_1351 * d1, vec34.field_1350 * d1);
                                double d = -0.6;
                            }
                        }
                    }
                }
            } else if (((PlayerExtension)player).getMovementTeleportTimer() >= 0 && (vec3.field_1352 != 0.0 || vec3.field_1351 != 0.0 || vec3.field_1350 != 0.0)) {
                if (((PlayerExtension)player).getMovementTeleportTimer() == 0) {
                    // empty if block
                }
                ((PlayerExtension)player).setMovementTeleportTimer(((PlayerExtension)player).getMovementTeleportTimer() + 1);
                class_243 vec39 = player.method_19538();
                double d6 = vec3.method_1022(vec39);
                double d7 = (double)((PlayerExtension)player).getMovementTeleportTimer() * 1.0 / (d6 + 3.0);
                if (((PlayerExtension)player).getMovementTeleportTimer() > 0) {
                    this.movementTeleportProgress = d7;
                    if (this.vrMovementStyle.destinationSparkles) {
                        // empty if block
                    }
                    class_243 vec310 = vec3.method_1031(-player.method_23317(), -player.method_23318(), -player.method_23321()).method_1029();
                    class_243 vec311 = player.method_5720();
                    class_243 vec35 = vec311.method_1036(new class_243(0.0, 1.0, 0.0));
                    class_243 vec312 = vec35.method_1036(vec311);
                    if (this.vrMovementStyle.airSparkles) {
                        for (int j = 0; j < 3; ++j) {
                            double d8 = random.nextDouble() * 1.0 + 3.5;
                            double d9 = random.nextDouble() * 2.5;
                            double d4 = random.nextDouble() * 4.0 - 2.0;
                            class_243 vec37 = new class_243(player.method_23317() + vec311.field_1352 * d8, player.method_23318() + vec311.field_1351 * d8, player.method_23321() + vec311.field_1350 * d8);
                            vec37 = vec37.method_1031(vec35.field_1352 * d4, vec35.field_1351 * d4, vec35.field_1350 * d4);
                            vec37.method_1031(vec312.field_1352 * d9, vec312.field_1351 * d9, vec312.field_1350 * d9);
                            double d = -0.6;
                        }
                    }
                } else {
                    this.movementTeleportProgress = 0.0;
                }
                if (d7 >= 1.0) {
                    flag = true;
                }
            }
        } else {
            if (this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                vec3 = this.movementTeleportDestination;
                flag = true;
            }
            ((PlayerExtension)player).setMovementTeleportTimer(0);
            this.movementTeleportProgress = 0.0;
        }
        if (flag && vec3 != null && (vec3.field_1352 != 0.0 || vec3.field_1351 != 0.0 || vec3.field_1350 != 0.0)) {
            this.movementTeleportDistance = vec3.method_1022(player.method_19538());
            if (this.movementTeleportDistance > 0.0 && this.vrMovementStyle.endTeleportingSound != null) {
                boolean vec39 = true;
            } else {
                boolean vec39 = false;
            }
            Object block = null;
            if (!this.dh.vrPlayer.isTeleportSupported()) {
                String s1 = "tp " + vec3.field_1352 + " " + vec3.field_1351 + " " + vec3.field_1350;
                this.mc.field_1724.method_44098(s1, (class_2561)class_2561.method_43473());
            } else {
                if (ClientNetworkHelper.serverSupportsDirectTeleport) {
                    ((PlayerExtension)player).setTeleported(true);
                }
                player.method_24203(vec3.field_1352, vec3.field_1351, vec3.field_1350);
            }
            this.doTeleportCallback();
            ((PlayerExtension)this.mc.field_1724).stepSound(new class_2338(vec3), vec3);
        }
    }

    public void updateTeleportDestinations(class_757 renderer, class_310 mc, class_746 player) {
        mc.method_16011().method_15396("updateTeleportDestinations");
        if (this.vrMovementStyle.arcAiming) {
            this.movementTeleportDestination = new class_243(0.0, 0.0, 0.0);
            if (this.movementTeleportProgress > 0.0) {
                this.updateTeleportArc(mc, player);
            }
        }
        mc.method_16011().method_15407();
    }

    private void updateTeleportArc(class_310 mc, class_746 player) {
        class_243 vec3 = this.dh.vrPlayer.vrdata_world_render.getController(1).getPosition();
        class_243 vec31 = this.dh.vrPlayer.vrdata_world_render.getController(1).getDirection();
        Matrix4f matrix4f = this.dh.vr.getAimRotation(1);
        if (this.dh.vrSettings.seated) {
            vec3 = ((GameRendererExtension)mc.field_1773).getControllerRenderPos(0);
            vec31 = this.dh.vrPlayer.vrdata_world_render.getController(0).getDirection();
            matrix4f = this.dh.vr.getAimRotation(0);
        }
        Matrix4f matrix4f1 = Matrix4f.rotationY(this.dh.vrPlayer.vrdata_world_render.rotation_radians);
        matrix4f = Matrix4f.multiply(matrix4f1, matrix4f);
        Quaternion quaternion = OpenVRUtil.convertMatrix4ftoRotationQuat(matrix4f);
        Angle angle = quaternion.toEuler();
        int i = 50;
        this.movementTeleportArc[0] = new class_243(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        this.movementTeleportArcSteps = 1;
        float f = 0.098f;
        Matrix4f matrix4f2 = Utils.rotationZMatrix((float)Math.toRadians(-angle.getRoll()));
        Matrix4f matrix4f3 = Utils.rotationXMatrix(-2.5132742f);
        Matrix4f matrix4f4 = Matrix4f.multiply(matrix4f, matrix4f2);
        Vector3 vector3 = new Vector3(0.0f, 1.0f, 0.0f);
        Vector3 vector31 = matrix4f4.transform(vector3);
        class_243 vec32 = vector31.negate().toVector3d();
        vec32 = vec32.method_1021((double)f);
        float f1 = 0.5f;
        class_243 vec33 = new class_243(vec31.field_1352 * (double)f1, vec31.field_1351 * (double)f1, vec31.field_1350 * (double)f1);
        class_243 vec34 = new class_243(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        for (int j = this.movementTeleportArcSteps; j < i && !((float)(j * 4) > this.teleportEnergy); ++j) {
            class_243 vec35 = new class_243(vec34.field_1352 + vec33.field_1352, vec34.field_1351 + vec33.field_1351, vec34.field_1350 + vec33.field_1350);
            boolean flag = false;
            flag = this.dh.vrSettings.seated ? ((GameRendererExtension)mc.field_1773).isInWater() : !mc.field_1687.method_8316(new class_2338(vec3)).method_15769();
            class_3965 blockhitresult = mc.field_1687.method_17742(new class_3959(vec34, vec35, class_3959.class_3960.field_17558, flag ? class_3959.class_242.field_1347 : class_3959.class_242.field_1347, (class_1297)mc.field_1724));
            if (blockhitresult != null && blockhitresult.method_17783() != class_239.class_240.field_1333) {
                this.movementTeleportArc[j] = blockhitresult.method_17784();
                this.movementTeleportArcSteps = j + 1;
                class_243 vec36 = vec34.method_1020(vec35).method_1029();
                class_243 vec37 = new class_243(-vec36.field_1352 * 0.02, -vec36.field_1351 * 0.02, -vec36.field_1350 * 0.02);
                this.checkAndSetTeleportDestination(mc, player, vec3, blockhitresult, vec37);
                class_243 vec38 = mc.field_1724.method_19538().method_1020(this.movementTeleportDestination);
                double d0 = vec38.field_1351;
                this.movementTeleportDistance = vec38.method_1033();
                double d1 = Math.sqrt(vec38.field_1352 * vec38.field_1352 + vec38.field_1350 * vec38.field_1350);
                boolean flag1 = true;
                if (mc.field_1724.method_5715() && d0 > 0.2) {
                    flag1 = false;
                }
                if (!mc.field_1724.method_31549().field_7478 && ClientNetworkHelper.isLimitedSurvivalTeleport()) {
                    if (ClientNetworkHelper.getTeleportDownLimit() > 0 && d0 > (double)ClientNetworkHelper.getTeleportDownLimit() + 0.2) {
                        flag1 = false;
                    } else if (ClientNetworkHelper.getTeleportUpLimit() > 0 && -d0 > (double)ClientNetworkHelper.getTeleportUpLimit() * (double)((PlayerExtension)player).getMuhJumpFactor() + 0.2) {
                        flag1 = false;
                    } else if (ClientNetworkHelper.getTeleportHorizLimit() > 0 && d1 > (double)ClientNetworkHelper.getTeleportHorizLimit() * (double)((PlayerExtension)player).getMuhSpeedFactor() + 0.2) {
                        flag1 = false;
                    }
                }
                if (flag1) break;
                this.movementTeleportDestination = new class_243(0.0, 0.0, 0.0);
                this.movementTeleportDistance = 0.0;
                break;
            }
            vec34 = new class_243(vec35.field_1352, vec35.field_1351, vec35.field_1350);
            this.movementTeleportArc[j] = new class_243(vec35.field_1352, vec35.field_1351, vec35.field_1350);
            this.movementTeleportArcSteps = j + 1;
            vec33 = vec33.method_1019(vec32);
        }
    }

    private void doTeleportCallback() {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        dataholder.swingTracker.disableSwing = 3;
        if (ClientNetworkHelper.isLimitedSurvivalTeleport()) {
            minecraft.field_1724.method_7322((float)(this.movementTeleportDistance / 16.0 * (double)1.2f));
            if (minecraft.field_1761.method_2924() && this.vrMovementStyle.arcAiming) {
                this.teleportEnergy = (float)((double)this.teleportEnergy - this.movementTeleportDistance * 4.0);
            }
        }
        minecraft.field_1724.field_6017 = 0.0f;
        ((PlayerExtension)minecraft.field_1724).setMovementTeleportTimer(-1);
    }

    private boolean checkAndSetTeleportDestination(class_310 mc, class_746 player, class_243 start, class_3965 collision, class_243 reverseEpsilon) {
        class_2338 blockpos = collision.method_17777();
        class_2680 blockstate = player.field_6002.method_8320(blockpos);
        if (!mc.field_1687.method_8316(blockpos).method_15769()) {
            class_243 vec3 = new class_243(collision.method_17784().field_1352, (double)blockpos.method_10264(), collision.method_17784().field_1350);
            class_243 vec31 = vec3.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
            class_238 aabb = player.method_5829().method_989(vec31.field_1352, vec31.field_1351, vec31.field_1350);
            boolean flag = mc.field_1687.method_8587((class_1297)player, aabb);
            if (!flag) {
                class_243 vec32 = class_243.method_24955((class_2382)blockpos);
                vec31 = vec32.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
                aabb = player.method_5829().method_989(vec31.field_1352, vec31.field_1351, vec31.field_1350);
                flag = mc.field_1687.method_8587((class_1297)player, aabb);
            }
            float f = 0.0f;
            if (this.dh.vrSettings.seated) {
                f = 0.5f;
            }
            if (flag) {
                this.movementTeleportDestination = new class_243(aabb.method_1005().field_1352, aabb.field_1322 + (double)f, aabb.method_1005().field_1350);
                this.movementTeleportDestinationSideHit = collision.method_17780();
                return true;
            }
        } else if (collision.method_17780() != class_2350.field_11036) {
            if (blockstate.method_26204() instanceof class_2399 || blockstate.method_26204() instanceof class_2541 || blockstate.method_26164(BlockTags.VIVECRAFT_CLIMBABLE)) {
                class_243 vec36 = new class_243((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264() + 0.5, (double)blockpos.method_10260() + 0.5);
                class_2248 block = mc.field_1687.method_8320(blockpos.method_10074()).method_26204();
                if (block == blockstate.method_26204()) {
                    vec36 = vec36.method_1031(0.0, -1.0, 0.0);
                }
                this.movementTeleportDestination = vec36.method_1021(1.0);
                this.movementTeleportDestinationSideHit = collision.method_17780();
                return true;
            }
            if (!mc.field_1724.method_31549().field_7478 && ClientNetworkHelper.isLimitedSurvivalTeleport()) {
                return false;
            }
        }
        double d1 = 0.0;
        class_2338 blockpos1 = collision.method_17777().method_10074();
        for (int i = 0; i < 2; ++i) {
            boolean flag1;
            blockstate = player.field_6002.method_8320(blockpos1);
            if (blockstate.method_26220((class_1922)mc.field_1687, blockpos1).method_1110()) {
                blockpos1 = blockpos1.method_10084();
                continue;
            }
            double d2 = blockstate.method_26220((class_1922)mc.field_1687, blockpos1).method_1105(class_2350.class_2351.field_11052);
            class_243 vec33 = new class_243(collision.method_17784().field_1352, (double)blockpos1.method_10264() + d2, collision.method_17784().field_1350);
            class_243 vec34 = vec33.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
            class_238 aabb1 = player.method_5829().method_989(vec34.field_1352, vec34.field_1351, vec34.field_1350);
            double d0 = 0.0;
            if (blockstate.method_26204() == class_2246.field_10114 || blockstate.method_26204() == class_2246.field_21211) {
                d0 = 0.05;
            }
            boolean bl = flag1 = mc.field_1687.method_8587((class_1297)player, aabb1) && !mc.field_1687.method_8587((class_1297)player, aabb1.method_1009(0.0, 0.125 + d0, 0.0));
            if (!flag1) {
                class_243 vec35 = class_243.method_26410((class_2382)blockpos1, (double)d2);
                vec34 = vec35.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
                aabb1 = player.method_5829().method_989(vec34.field_1352, vec34.field_1351, vec34.field_1350);
                boolean bl2 = flag1 = mc.field_1687.method_8587((class_1297)player, aabb1) && !mc.field_1687.method_8587((class_1297)player, aabb1.method_1009(0.0, 0.125 + d0, 0.0));
            }
            if (flag1) {
                class_243 vec37 = new class_243(aabb1.method_1005().field_1352, (double)blockpos1.method_10264() + d2, aabb1.method_1005().field_1350);
                this.movementTeleportDestination = vec37.method_1021(1.0);
                return true;
            }
            blockpos1 = blockpos1.method_10084();
        }
        return false;
    }

    public class_243 getInterpolatedArcPosition(float progress) {
        if (this.movementTeleportArcSteps != 1 && !(progress <= 0.0f)) {
            if (progress >= 1.0f) {
                return new class_243(this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1352, this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1351, this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1350);
            }
            float f = progress * (float)(this.movementTeleportArcSteps - 1);
            int i = (int)Math.floor(f);
            double d0 = this.movementTeleportArc[i + 1].field_1352 - this.movementTeleportArc[i].field_1352;
            double d1 = this.movementTeleportArc[i + 1].field_1351 - this.movementTeleportArc[i].field_1351;
            double d2 = this.movementTeleportArc[i + 1].field_1350 - this.movementTeleportArc[i].field_1350;
            float f1 = f - (float)i;
            return new class_243(this.movementTeleportArc[i].field_1352 + d0 * (double)f1, this.movementTeleportArc[i].field_1351 + d1 * (double)f1, this.movementTeleportArc[i].field_1350 + d2 * (double)f1);
        }
        return new class_243(this.movementTeleportArc[0].field_1352, this.movementTeleportArc[0].field_1351, this.movementTeleportArc[0].field_1350);
    }
}

