/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.provider.openvr_jna.control;

import org.vivecraft.provider.ControllerType;
import org.vivecraft.provider.openvr_jna.MCOpenVR;
import org.vivecraft.utils.lwjgl.Vector2f;
import org.vivecraft.utils.math.Vector2;

public class TrackpadSwipeSampler {
    private static final int UP = 0;
    private static final int RIGHT = 1;
    private static final int DOWN = 2;
    private static final int LEFT = 3;
    private Vector2f[] buffer = new Vector2f[5];
    private int index;
    private long count;
    private Vector2f accumulator = new Vector2f();
    private int[] swiped = new int[4];
    public float threshold = 0.5f;

    public TrackpadSwipeSampler() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = new Vector2f();
        }
    }

    public void update(ControllerType hand, Vector2 position) {
        MCOpenVR.get().getInputAction(MCOpenVR.get().keyTrackpadTouch).setCurrentHand(hand);
        if (MCOpenVR.get().getInputAction(MCOpenVR.get().keyTrackpadTouch).isButtonPressed()) {
            this.buffer[this.index].set(position.getX(), position.getY());
            if (++this.index >= this.buffer.length) {
                this.index = 0;
            }
            ++this.count;
        } else {
            for (Vector2f vector2f : this.buffer) {
                vector2f.set(0.0f, 0.0f);
            }
            this.count = 0L;
        }
        if (this.count >= (long)this.buffer.length) {
            int n;
            int i = (this.index + 1) % this.buffer.length;
            this.accumulator.x += this.buffer[i].x - this.buffer[this.index].x;
            this.accumulator.y += this.buffer[i].y - this.buffer[this.index].y;
            if (this.accumulator.x >= this.threshold) {
                this.accumulator.x -= this.threshold;
                int n2 = this.swiped[1];
                this.swiped[1] = n2 + 1;
                n = n2;
            }
            if (this.accumulator.x <= -this.threshold) {
                this.accumulator.x += this.threshold;
                int n3 = this.swiped[3];
                this.swiped[3] = n3 + 1;
                n = n3;
            }
            if (this.accumulator.y >= this.threshold) {
                this.accumulator.y -= this.threshold;
                int n4 = this.swiped[0];
                this.swiped[0] = n4 + 1;
                n = n4;
            }
            if (this.accumulator.y <= -this.threshold) {
                this.accumulator.y += this.threshold;
                int n5 = this.swiped[2];
                this.swiped[2] = n5 + 1;
                n = n5;
            }
        } else {
            this.accumulator.set(0.0f, 0.0f);
        }
    }

    public boolean isSwipedLeft() {
        return this.isSwiped(3);
    }

    public boolean isSwipedRight() {
        return this.isSwiped(1);
    }

    public boolean isSwipedUp() {
        return this.isSwiped(0);
    }

    public boolean isSwipedDown() {
        return this.isSwiped(2);
    }

    private boolean isSwiped(int direction) {
        if (this.swiped[direction] > 0) {
            int n = direction;
            int n2 = this.swiped[n];
            this.swiped[n] = n2 - 1;
            int i = n2;
            return true;
        }
        return false;
    }
}

