/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.startup.JeiEventHandlers;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class EventRegistration {
    @Nullable
    private ClientInputHandler clientInputHandler;
    @Nullable
    private GuiEventHandler guiEventHandler;
    private boolean registered;

    public void setEventHandlers(JeiEventHandlers eventHandlers) {
        this.clientInputHandler = eventHandlers.clientInputHandler();
        this.guiEventHandler = eventHandlers.guiEventHandler();
        if (!this.registered) {
            this.registerEvents();
            this.registered = true;
        }
    }

    private void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> this.registerScreenEvents(screen));
        JeiCharTypedEvents.BEFORE_CHAR_TYPED.register(this::beforeCharTyped);
        ScreenEvents.AFTER_INIT.register(this::afterInit);
        JeiScreenEvents.AFTER_RENDER_BACKGROUND.register(this::afterRenderBackground);
        JeiScreenEvents.DRAW_FOREGROUND.register(this::drawForeground);
        ClientTickEvents.START_CLIENT_TICK.register(this::onStartTick);
    }

    private void registerScreenEvents(class_437 screen) {
        if (this.guiEventHandler == null) {
            return;
        }
        this.guiEventHandler.onGuiInit(screen);
        ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(this::allowKeyPress);
        ScreenMouseEvents.allowMouseClick((class_437)screen).register(this::allowMouseClick);
        ScreenMouseEvents.beforeMouseRelease((class_437)screen).register(this::beforeMouseRelease);
        ScreenMouseEvents.allowMouseScroll((class_437)screen).register(this::allowMouseScroll);
        ScreenEvents.afterRender((class_437)screen).register(this::afterRender);
    }

    private boolean allowMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(mouseX, mouseY, button, InputType.SIMULATE).map(input -> !this.clientInputHandler.onGuiMouseClicked(screen, (UserInput)input)).orElse(true);
    }

    private boolean beforeMouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(mouseX, mouseY, button, InputType.EXECUTE).map(input -> !this.clientInputHandler.onGuiMouseReleased(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowKeyPress(class_437 screen, int key, int scancode, int modifiers) {
        if (this.clientInputHandler == null) {
            return true;
        }
        UserInput userInput = UserInput.fromVanilla(key, scancode, modifiers, InputType.IMMEDIATE);
        return !this.clientInputHandler.onKeyboardKeyPressedPre(screen, userInput);
    }

    private boolean allowMouseScroll(class_437 screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.clientInputHandler == null) {
            return false;
        }
        return !this.clientInputHandler.onGuiMouseScroll(mouseX, mouseY, verticalAmount);
    }

    private void afterRender(class_437 screen, class_4587 poseStack, int mouseX, int mouseY, float tickDelta) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawScreenPost(screen, poseStack, mouseX, mouseY);
        }
    }

    private boolean beforeCharTyped(class_364 guiEventListener, char codepoint, int modifiers) {
        if (this.clientInputHandler != null && guiEventListener instanceof class_437) {
            class_437 screen = (class_437)guiEventListener;
            return this.clientInputHandler.onKeyboardCharTypedPre(screen, codepoint, modifiers);
        }
        return false;
    }

    private void afterInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onGuiOpen(screen);
        }
    }

    private void afterRenderBackground(class_437 screen, class_4587 poseStack) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawBackgroundPost(screen, poseStack);
        }
    }

    private void drawForeground(class_465<?> screen, class_4587 poseStack, int mouseX, int mouseY) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawForeground(screen, poseStack, mouseX, mouseY);
        }
    }

    private void onStartTick(class_310 client) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onClientTick();
        }
    }

    public void clear() {
        this.clientInputHandler = null;
        this.guiEventHandler = null;
    }
}

