/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.Optional;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_437;

public class GlobalInputHandler
implements IUserInputHandler {
    private final IWorldConfig worldConfig;

    public GlobalInputHandler(IWorldConfig worldConfig) {
        this.worldConfig = worldConfig;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (input.is(keyBindings.getToggleOverlay())) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleOverlayEnabled();
            }
            return Optional.of(this);
        }
        if (input.is(keyBindings.getToggleBookmarkOverlay())) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return Optional.of(this);
        }
        if (input.is(keyBindings.getToggleCheatMode())) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleCheatItemsEnabled();
                if (this.worldConfig.isCheatItemsEnabled()) {
                    IConnectionToServer serverConnection = Internal.getServerConnection();
                    serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
                }
            }
            return Optional.of(this);
        }
        if (input.is(keyBindings.getToggleEditMode())) {
            if (!input.isSimulate()) {
                this.worldConfig.toggleEditModeEnabled();
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

