/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.implementation.peripherals.DisplayLinkPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SequencedGearshiftPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedControllerPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedGaugePeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StationPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StressGaugePeripheral;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.class_1922;
import net.minecraft.class_2378;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    public static final IPeripheralProvider PERIPHERAL_PROVIDER = (level, blockPos, direction) -> {
        AbstractComputerBehaviour behavior = BlockEntityBehaviour.get((class_1922)level, blockPos, AbstractComputerBehaviour.TYPE);
        if (behavior instanceof ComputerBehaviour) {
            ComputerBehaviour real = (ComputerBehaviour)behavior;
            return real.peripheral;
        }
        return null;
    };
    IPeripheral peripheral;

    public ComputerBehaviour(SmartBlockEntity te) {
        super(te);
        this.peripheral = ComputerBehaviour.getPeripheralFor(te);
    }

    public static IPeripheral getPeripheralFor(SmartBlockEntity te) {
        if (te instanceof SpeedControllerBlockEntity) {
            SpeedControllerBlockEntity scbe = (SpeedControllerBlockEntity)te;
            return new SpeedControllerPeripheral(scbe, scbe.targetSpeed);
        }
        if (te instanceof DisplayLinkBlockEntity) {
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)te;
            return new DisplayLinkPeripheral(dlbe);
        }
        if (te instanceof SequencedGearshiftBlockEntity) {
            SequencedGearshiftBlockEntity sgbe = (SequencedGearshiftBlockEntity)te;
            return new SequencedGearshiftPeripheral(sgbe);
        }
        if (te instanceof SpeedGaugeBlockEntity) {
            SpeedGaugeBlockEntity sgbe = (SpeedGaugeBlockEntity)te;
            return new SpeedGaugePeripheral(sgbe);
        }
        if (te instanceof StressGaugeBlockEntity) {
            StressGaugeBlockEntity sgbe = (StressGaugeBlockEntity)te;
            return new StressGaugePeripheral(sgbe);
        }
        if (te instanceof StationBlockEntity) {
            StationBlockEntity sbe = (StationBlockEntity)te;
            return new StationPeripheral(sbe);
        }
        throw new IllegalArgumentException("No peripheral available for " + class_2378.field_11137.method_10221((Object)te.method_11017()));
    }

    @Override
    public <T> T getPeripheral() {
        return (T)this.peripheral;
    }
}

