/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorFloorListPacket;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class ElevatorPulleyBlockEntity
extends PulleyBlockEntity {
    private float prevSpeed = 0.0f;
    private boolean arrived = true;
    private int clientOffsetTarget;
    private boolean initialOffsetReceived = false;

    public ElevatorPulleyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private int getTargetOffset() {
        Contraption contraption;
        if (this.field_11863.field_9236) {
            return this.clientOffsetTarget;
        }
        if (this.movedContraption == null || !((contraption = this.movedContraption.getContraption()) instanceof ElevatorContraption)) {
            return (int)this.offset;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        Integer target = ec.getCurrentTargetY(this.field_11863);
        if (target == null) {
            return (int)this.offset;
        }
        return this.field_11867.method_10264() - target + ec.contactYOffset - 1;
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        super.attach(contraption);
        if (this.offset >= 0.0f) {
            this.resetContraptionToOffset();
        }
        if (this.field_11863.field_9236) {
            AllPackets.getChannel().sendToServer((C2SPacket)new ElevatorFloorListPacket.RequestFloorList(contraption));
            return;
        }
        Contraption contraption2 = contraption.getContraption();
        if (contraption2 instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption2;
            ElevatorColumn.getOrCreate((class_1936)this.field_11863, ec.getGlobalColumn()).setActive(true);
        }
    }

    @Override
    public void tick() {
        double diff;
        boolean wasArrived = this.arrived;
        super.tick();
        if (this.movedContraption == null) {
            return;
        }
        Contraption contraption = this.movedContraption.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (this.field_11863.method_8608()) {
            ec.setClientYTarget(this.field_11867.method_10264() - this.clientOffsetTarget + ec.contactYOffset - 1);
        }
        this.waitingForSpeedChange = false;
        ec.arrived = wasArrived;
        if (!this.arrived) {
            return;
        }
        double y = this.movedContraption.method_23318();
        int targetLevel = class_3532.method_15357((double)(0.5 + y)) + ec.contactYOffset;
        Integer ecCurrentTargetY = ec.getCurrentTargetY(this.field_11863);
        if (ecCurrentTargetY != null) {
            targetLevel = ecCurrentTargetY;
        }
        if (this.field_11863.method_8608()) {
            targetLevel = ec.clientYTarget;
        }
        if (!wasArrived && !this.field_11863.method_8608()) {
            this.triggerContact(ec, targetLevel);
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.play(this.field_11863, null, (class_2382)this.field_11867.method_10087((int)this.offset), 0.75f, 0.8f);
        }
        if (Math.abs(diff = (double)targetLevel - y - (double)ec.contactYOffset) > 0.0078125) {
            diff *= 0.25;
        }
        this.movedContraption.method_33574(this.movedContraption.method_19538().method_1031(0.0, diff, 0.0));
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608() || !this.arrived) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.method_5805()) {
            return;
        }
        Contraption contraption = this.movedContraption.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (this.getTargetOffset() != (int)this.offset) {
            return;
        }
        double y = this.movedContraption.method_23318();
        int targetLevel = class_3532.method_15357((double)(0.5 + y));
        this.triggerContact(ec, targetLevel);
    }

    private void triggerContact(ElevatorContraption ec, int targetLevel) {
        ElevatorColumn.ColumnCoords coords = ec.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((class_1936)this.field_11863, coords);
        if (column == null) {
            return;
        }
        class_2338 contactPos = column.contactAt(targetLevel + ec.contactYOffset);
        if (!this.field_11863.method_8477(contactPos)) {
            return;
        }
        class_2680 contactState = this.field_11863.method_8320(contactPos);
        if (!AllBlocks.ELEVATOR_CONTACT.has(contactState)) {
            return;
        }
        if (((Boolean)contactState.method_11654((class_2769)ElevatorContactBlock.POWERING)).booleanValue()) {
            return;
        }
        ElevatorContactBlock ecb = (ElevatorContactBlock)AllBlocks.ELEVATOR_CONTACT.get();
        ecb.withBlockEntityDo((class_1922)this.field_11863, contactPos, be -> {
            be.activateBlock = true;
        });
        ecb.scheduleActivation((class_1936)this.field_11863, contactPos);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.method_10569("ClientTarget", this.clientOffsetTarget);
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.clientOffsetTarget = compound.method_10550("ClientTarget");
        if (this.initialOffsetReceived) {
            return;
        }
        this.offset = compound.method_10583("Offset");
        this.initialOffsetReceived = true;
        this.resetContraptionToOffset();
    }

    @Override
    public float getMovementSpeed() {
        int currentTarget = this.getTargetOffset();
        if (!this.field_11863.method_8608() && currentTarget != this.clientOffsetTarget) {
            this.clientOffsetTarget = currentTarget;
            this.sendData();
        }
        float diff = (float)currentTarget - this.offset;
        float movementSpeed = class_3532.method_15363((float)ElevatorPulleyBlockEntity.convertToLinear(this.getSpeed() * 2.0f), (float)-1.99f, (float)1.99f);
        float rpmLimit = Math.abs(movementSpeed);
        float configacc = class_3532.method_16439((float)Math.abs(movementSpeed), (float)0.0075f, (float)0.0175f);
        float decelleration = (float)Math.sqrt(2.0f * Math.abs(diff) * configacc);
        float speed = diff;
        speed = class_3532.method_15363((float)speed, (float)(-rpmLimit), (float)rpmLimit);
        speed = class_3532.method_15363((float)speed, (float)(this.prevSpeed - configacc), (float)(this.prevSpeed + configacc));
        speed = class_3532.method_15363((float)speed, (float)(-decelleration), (float)decelleration);
        boolean bl = this.arrived = Math.abs(diff) < 0.5f;
        if (speed > 9.765625E-4f && !this.field_11863.method_8608()) {
            this.method_5431();
        }
        this.prevSpeed = speed;
        return this.prevSpeed;
    }

    @Override
    protected boolean shouldCreateRopes() {
        return false;
    }

    @Override
    public void disassemble() {
        ElevatorContraption ec;
        ElevatorColumn column;
        Contraption contraption;
        if (this.movedContraption != null && (contraption = this.movedContraption.getContraption()) instanceof ElevatorContraption && (column = ElevatorColumn.get((class_1936)this.field_11863, (ec = (ElevatorContraption)contraption).getGlobalColumn())) != null) {
            column.setActive(false);
        }
        super.disassemble();
        this.offset = -1.0f;
        this.sendData();
    }

    public void clicked() {
        class_2586 class_25862;
        if (this.isPassive() && (class_25862 = this.field_11863.method_8321(this.mirrorParent)) instanceof ElevatorPulleyBlockEntity) {
            ElevatorPulleyBlockEntity parent = (ElevatorPulleyBlockEntity)class_25862;
            parent.clicked();
            return;
        }
        if (this.running) {
            this.disassemble();
        } else {
            this.assembleNextTick = true;
        }
    }

    @Override
    protected boolean moveAndCollideContraption() {
        if (this.arrived) {
            return false;
        }
        super.moveAndCollideContraption();
        return false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    protected void assemble() throws AssemblyException {
        class_2338 ropePos;
        class_2680 ropeState;
        int i;
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof ElevatorPulleyBlock)) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        int maxLength = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && ((ropeState = this.field_11863.method_8320(ropePos = this.field_11867.method_10087(i))).method_26220((class_1922)this.field_11863, ropePos).method_1110() || ropeState.method_26207().method_15800()); ++i) {
        }
        this.offset = i - 1;
        this.forceMove = true;
        if (!this.field_11863.field_9236 && this.mirrorParent == null) {
            this.needsContraption = false;
            class_2338 anchor = this.field_11867.method_10087(class_3532.method_15375((float)(this.offset + 1.0f)));
            this.offset = class_3532.method_15375((float)this.offset);
            ElevatorContraption contraption = new ElevatorContraption((int)this.offset);
            float offsetOnSucess = this.offset;
            this.offset = 0.0f;
            boolean canAssembleStructure = contraption.assemble(this.field_11863, anchor);
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            if (!contraption.getBlocks().isEmpty()) {
                this.offset = offsetOnSucess;
                contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
                this.movedContraption = ControlledContraptionEntity.create(this.field_11863, this, contraption);
                this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
                contraption.maxContactY = this.field_11867.method_10264() + contraption.contactYOffset - 1;
                contraption.minContactY = contraption.maxContactY - maxLength;
                this.field_11863.method_8649((class_1297)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
                for (class_2338 pos : contraption.createColliders(this.field_11863, class_2350.field_11036)) {
                    class_2586 class_25862;
                    if (pos.method_10264() != 0 || !((class_25862 = this.field_11863.method_8321(new class_2338((pos = pos.method_10081((class_2382)anchor)).method_10263(), this.field_11867.method_10264(), pos.method_10260()))) instanceof ElevatorPulleyBlockEntity)) continue;
                    ElevatorPulleyBlockEntity pbe = (ElevatorPulleyBlockEntity)class_25862;
                    pbe.startMirroringOther(this.field_11867);
                }
                ElevatorColumn column = ElevatorColumn.getOrCreate((class_1936)this.field_11863, contraption.getGlobalColumn());
                int target = (int)((float)(this.field_11867.method_10264() + contraption.contactYOffset - 1) - this.offset);
                column.target(target);
                column.gatherAll();
                column.setActive(true);
                column.markDirty();
                contraption.broadcastFloorData(this.field_11863, column.contactAt(target));
                this.clientOffsetTarget = column.getTargetedYLevel();
                this.arrived = true;
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.method_5431();
    }

    @Override
    protected IControlContraption.MovementMode getMovementMode() {
        return IControlContraption.MovementMode.MOVE_NEVER_PLACE;
    }
}

