/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BoilerHeaters {
    private static final AttachedRegistry<class_2248, Heater> BLOCK_HEATERS = new AttachedRegistry(class_2378.field_11146);
    private static final List<HeaterProvider> GLOBAL_HEATERS = new ArrayList<HeaterProvider>();

    public static void registerHeater(class_2960 block, Heater heater) {
        BLOCK_HEATERS.register((class_2248)block, heater);
    }

    public static void registerHeater(class_2248 block, Heater heater) {
        BLOCK_HEATERS.register(block, heater);
    }

    public static void registerHeaterProvider(HeaterProvider provider) {
        GLOBAL_HEATERS.add(provider);
    }

    public static float getActiveHeat(class_1937 level, class_2338 pos, class_2680 state) {
        Heater heater = BLOCK_HEATERS.get(state.method_26204());
        if (heater != null) {
            return heater.getActiveHeat(level, pos, state);
        }
        for (HeaterProvider provider : GLOBAL_HEATERS) {
            heater = provider.getHeater(level, pos, state);
            if (heater == null) continue;
            return heater.getActiveHeat(level, pos, state);
        }
        return -1.0f;
    }

    public static void registerDefaults() {
        BoilerHeaters.registerHeater((class_2248)AllBlocks.BLAZE_BURNER.get(), (class_1937 level, class_2338 pos, class_2680 state) -> {
            BlazeBurnerBlock.HeatLevel value = (BlazeBurnerBlock.HeatLevel)((Object)((Object)state.method_11654(BlazeBurnerBlock.HEAT_LEVEL)));
            if (value == BlazeBurnerBlock.HeatLevel.NONE) {
                return -1.0f;
            }
            if (value == BlazeBurnerBlock.HeatLevel.SEETHING) {
                return 2.0f;
            }
            if (value.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return 1.0f;
            }
            return 0.0f;
        });
        BoilerHeaters.registerHeaterProvider((level, pos, state) -> {
            if (AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state)) {
                return (level1, pos1, state1) -> 0.0f;
            }
            return null;
        });
    }

    public static interface Heater {
        public float getActiveHeat(class_1937 var1, class_2338 var2, class_2680 var3);
    }

    public static interface HeaterProvider {
        @Nullable
        public Heater getHeater(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

