/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.AirCurrentSound;
import com.simibubi.create.content.kinetics.fan.AirFlowParticleData;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.FanProcessing;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.ServerGamePacketListenerImplAccessor;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.apache.commons.lang3.tuple.Pair;

public class AirCurrent {
    public final IAirCurrentSource source;
    public class_238 bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public class_2350 direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessing.Type>> affectedItemHandlers = new ArrayList<Pair<TransportedItemStackHandlerBehaviour, FanProcessing.Type>>();
    protected List<class_1297> caughtEntities = new ArrayList<class_1297>();
    static boolean isClientPlayerInAirCurrent;
    @Environment(value=EnvType.CLIENT)
    static AirCurrentSound flyingSound;

    public AirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        if (this.direction == null) {
            this.rebuild();
        }
        class_1937 world = this.source.getAirCurrentWorld();
        class_2350 facing = this.direction;
        if (world != null && world.field_9236) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            class_243 pos = VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos()).method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021((double)offset));
            if ((double)world.field_9229.method_43057() < (Double)AllConfigs.client().fanParticleDensity.get()) {
                world.method_8406((class_2394)new AirFlowParticleData((class_2382)this.source.getAirCurrentPos()), pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world, facing);
        this.tickAffectedHandlers();
    }

    protected void tickAffectedEntities(class_1937 world, class_2350 facing) {
        Iterator<class_1297> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            FanProcessing.Type processingType;
            class_1297 entity = iterator.next();
            if (!entity.method_5805() || !entity.method_5829().method_994(this.bounds) || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            class_243 center = VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos());
            class_2382 flow = (this.pushing ? facing : facing.method_10153()).method_10163();
            float sneakModifier = entity.method_5715() ? 4096.0f : 512.0f;
            float speed = Math.abs(this.source.getSpeed());
            double entityDistance = entity.method_19538().method_1022(center);
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistance / (double)this.maxDistance));
            class_243 previousMotion = entity.method_18798();
            float maxAcceleration = 5.0f;
            double xIn = class_3532.method_15350((double)((double)((float)flow.method_10263() * acceleration) - previousMotion.field_1352), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = class_3532.method_15350((double)((double)((float)flow.method_10264() * acceleration) - previousMotion.field_1351), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = class_3532.method_15350((double)((double)((float)flow.method_10260() * acceleration) - previousMotion.field_1350), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.method_18799(previousMotion.method_1019(new class_243(xIn, yIn, zIn).method_1021(0.125)));
            entity.field_6017 = 0.0f;
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> AirCurrent.enableClientPlayerSound(entity, class_3532.method_15363((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof class_3222) {
                ((ServerGamePacketListenerImplAccessor)((class_3222)entity).field_13987).port_lib$setAboveGroundTickCount(0);
            }
            if ((processingType = this.getSegmentAt((float)(entityDistance -= 0.5))) == null || processingType == FanProcessing.Type.NONE) continue;
            if (entity instanceof class_1542) {
                IAirCurrentSource iAirCurrentSource;
                class_1542 itemEntity = (class_1542)entity;
                if (world.field_9236) {
                    processingType.spawnParticlesForProcessing(world, entity.method_19538());
                    continue;
                }
                if (!FanProcessing.canProcess(itemEntity, processingType) || !FanProcessing.applyProcessing(itemEntity, processingType) || !((iAirCurrentSource = this.source) instanceof EncasedFanBlockEntity)) continue;
                EncasedFanBlockEntity fan = (EncasedFanBlockEntity)iAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            processingType.affectEntity(entity, world);
        }
    }

    public void rebuild() {
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.direction = this.source.getAirflowOriginSide();
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        this.maxDistance = this.source.getMaxDistance();
        class_1937 world = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        float max = this.maxDistance;
        class_2350 facing = this.direction;
        class_243 directionVec = class_243.method_24954((class_2382)facing.method_10163());
        this.maxDistance = AirCurrent.getFlowLimit(world, start, max, facing);
        AirCurrentSegment currentSegment = new AirCurrentSegment();
        this.segments.clear();
        currentSegment.startOffset = 0;
        FanProcessing.Type type = FanProcessing.Type.NONE;
        int limit = (int)(this.maxDistance + 0.5f);
        int searchStart = this.pushing ? 0 : limit;
        int searchEnd = this.pushing ? limit : 0;
        int searchStep = this.pushing ? 1 : -1;
        int i = searchStart;
        while (i * searchStep <= searchEnd * searchStep) {
            class_2338 currentPos = start.method_10079(this.direction, i);
            FanProcessing.Type newType = FanProcessing.Type.byBlock((class_1922)world, currentPos);
            if (newType != FanProcessing.Type.NONE) {
                type = newType;
            }
            if (currentSegment.type != type || currentSegment.startOffset == 0) {
                currentSegment.endOffset = i;
                if (currentSegment.startOffset != 0) {
                    this.segments.add(currentSegment);
                }
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i;
                currentSegment.type = type;
            }
            i += searchStep;
        }
        currentSegment.endOffset = searchEnd + searchStep;
        this.segments.add(currentSegment);
        if (this.maxDistance < 0.25f) {
            this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            class_243 scale = directionVec.method_1021((double)factor);
            this.bounds = factor > 0.0f ? new class_238(start.method_10093(this.direction)).method_18804(scale) : new class_238(start.method_10093(this.direction)).method_1002(scale.field_1352, scale.field_1351, scale.field_1350).method_997(scale);
        }
        this.findAffectedHandlers();
    }

    public static float getFlowLimit(class_1937 world, class_2338 start, float max, class_2350 facing) {
        class_2338 currentPos;
        class_243 directionVec = class_243.method_24954((class_2382)facing.method_10163());
        class_243 planeVec = VecHelper.axisAlingedPlaneOf(directionVec);
        float offsetDistance = 0.25f;
        class_243[] offsets = new class_243[]{planeVec.method_18805((double)offsetDistance, (double)offsetDistance, (double)offsetDistance), planeVec.method_18805((double)(-offsetDistance), (double)(-offsetDistance), (double)offsetDistance), planeVec.method_18805((double)offsetDistance, (double)(-offsetDistance), (double)(-offsetDistance)), planeVec.method_18805((double)(-offsetDistance), (double)offsetDistance, (double)(-offsetDistance))};
        float limitedDistance = 0.0f;
        int i = 1;
        while ((float)i <= max && world.method_8477(currentPos = start.method_10079(facing, i))) {
            block5: {
                class_265 voxelshape;
                class_2680 state = world.method_8320(currentPos);
                class_2680 copycatState = CopycatBlock.getMaterial((class_1922)world, currentPos);
                if (!AirCurrent.shouldAlwaysPass(copycatState.method_26215() ? state : copycatState) && !(voxelshape = state.method_26194((class_1922)world, currentPos, class_3726.method_16194())).method_1110()) {
                    if (voxelshape == class_259.method_1077()) {
                        max = i - 1;
                        break;
                    }
                    for (class_243 offset : offsets) {
                        class_243 rayEnd;
                        class_243 rayStart = VecHelper.getCenterOf((class_2382)currentPos).method_1020(directionVec.method_1021(0.53125)).method_1019(offset);
                        class_3965 blockraytraceresult = world.method_17745(rayStart, rayEnd = rayStart.method_1019(directionVec.method_1021(1.03125)), currentPos, voxelshape, state);
                        if (blockraytraceresult != null) {
                            double distance = (double)(i - 1) + blockraytraceresult.method_17784().method_1022(rayStart);
                            if (!((double)limitedDistance < distance)) continue;
                            limitedDistance = (float)distance;
                            continue;
                        }
                        break block5;
                    }
                    max = limitedDistance;
                    break;
                }
            }
            ++i;
        }
        return max;
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.getAirCurrentWorld().method_8335(null, this.bounds);
    }

    public void findAffectedHandlers() {
        class_1937 world = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        this.affectedItemHandlers.clear();
        int i = 0;
        while ((float)i < this.maxDistance + 1.0f) {
            FanProcessing.Type type = this.getSegmentAt(i);
            if (type != null) {
                for (int offset : Iterate.zeroAndOne) {
                    class_2338 pos = start.method_10079(this.direction, i).method_10087(offset);
                    TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get((class_1922)world, pos, TransportedItemStackHandlerBehaviour.TYPE);
                    FanProcessing.Type typeAtHandler = type;
                    if (world.method_8316(pos).method_39360((class_3611)class_3612.field_15910)) {
                        typeAtHandler = FanProcessing.Type.SPLASHING;
                    }
                    if (behaviour != null) {
                        this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessing.Type>)Pair.of((Object)behaviour, (Object)((Object)typeAtHandler)));
                    }
                    if (this.direction.method_10166().method_10178()) break;
                }
            }
            ++i;
        }
    }

    public void tickAffectedHandlers() {
        for (Pair<TransportedItemStackHandlerBehaviour, FanProcessing.Type> pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            class_1937 world = handler.getWorld();
            FanProcessing.Type processingType = (FanProcessing.Type)((Object)pair.getRight());
            handler.handleProcessingOnAllItems(transported -> {
                IAirCurrentSource patt11013$temp;
                if (world.field_9236) {
                    if (world != null) {
                        processingType.spawnParticlesForProcessing(world, handler.getWorldPositionOf((TransportedItemStack)transported));
                    }
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = FanProcessing.applyProcessing(transported, world, processingType);
                if (!applyProcessing.doesNothing() && (patt11013$temp = this.source) instanceof EncasedFanBlockEntity) {
                    EncasedFanBlockEntity fan = (EncasedFanBlockEntity)patt11013$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    private static boolean shouldAlwaysPass(class_2680 state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    public FanProcessing.Type getSegmentAt(float offset) {
        for (AirCurrentSegment airCurrentSegment : this.segments) {
            if (offset > (float)airCurrentSegment.endOffset && this.pushing || offset < (float)airCurrentSegment.endOffset && !this.pushing) continue;
            return airCurrentSegment.type;
        }
        return FanProcessing.Type.NONE;
    }

    @Environment(value=EnvType.CLIENT)
    private static void enableClientPlayerSound(class_1297 e, float maxVolume) {
        if (e != class_310.method_1551().method_1560()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)class_3532.method_15350((double)(e.method_18798().method_1033() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.method_4793()) {
            flyingSound = new AirCurrentSound(class_3417.field_14572, pitch);
            class_310.method_1551().method_1483().method_4873((class_1113)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @Environment(value=EnvType.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    public static boolean isPlayerCreativeFlying(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player.method_7337() && player.method_31549().field_7479;
        }
        return false;
    }

    public static class AirCurrentSegment {
        FanProcessing.Type type;
        int startOffset;
        int endOffset;
    }
}

