/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_4597;

public class SawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10153());
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10163()).method_1021((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        super.visitNewPosition(context, pos);
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        if (closestToFacing.method_10166().method_10178() && context.data.method_10545("BreakingPos")) {
            context.data.method_10551("BreakingPos");
            context.stall = false;
        }
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        return super.canBreak(world, breakingPos, state) && SawBlockEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        if (brokenState.method_26164(class_3481.field_15503)) {
            return;
        }
        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(brokenState.method_26204(), pos);
        if (dynamicTree.isPresent()) {
            dynamicTree.get().destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (class_2338)stack, (class_1799)dropPos));
            return;
        }
        TreeCutter.findTree((class_1922)context.world, pos).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (class_2338)stack, (class_1799)dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, class_2338 pos, class_1799 stack) {
        long inserted = TransferUtil.insertItem((Storage)context.contraption.getSharedInventory(), (class_1799)stack);
        if (inserted == (long)stack.method_7947()) {
            return;
        }
        long remaining = (long)stack.method_7947() - inserted;
        class_1799 remainder = stack.method_7972();
        remainder.method_7939((int)remaining);
        class_1937 world = context.world;
        class_243 dropPos = VecHelper.getCenterOf((class_2382)pos);
        float distance = context.position == null ? 1.0f : (float)dropPos.method_1022(context.position);
        class_1542 entity = new class_1542(world, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, remainder);
        entity.method_18799(context.relativeMotion.method_1021((double)(distance / 20.0f)));
        world.method_8649((class_1297)entity);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        SawRenderer.renderInContraption(context, renderWorld, matrices, buffer);
    }

    @Override
    protected boolean shouldDestroyStartBlock(class_2680 stateToBreak) {
        return !TreeCutter.canDynamicTreeCutFrom(stateToBreak.method_26204());
    }

    @Override
    protected class_1282 getDamageSource() {
        return SawBlock.damageSourceSaw;
    }
}

