/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.vault;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ItemVaultBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory,
SidedStorageBlockEntity {
    protected Storage<ItemVariant> itemCapability;
    protected ItemStackHandler inventory;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected class_2350.class_2351 axis;
    protected boolean recalculateComparatorsNextTick = false;

    public ItemVaultBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemVaultBlockEntity.this.recalculateComparatorsNextTick = true;
            }
        };
        this.itemCapability = null;
        this.radius = 1;
        this.length = 1;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    protected void updateComparators() {
        this.recalculateComparatorsNextTick = false;
        ItemVaultBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.field_11863.method_8524(controllerBE.field_11867);
        class_2338 pos = controllerBE.method_11016();
        for (int y = 0; y < controllerBE.radius; ++y) {
            for (int z = 0; z < (controllerBE.axis == class_2350.class_2351.field_11048 ? controllerBE.radius : controllerBE.length); ++z) {
                for (int x = 0; x < (controllerBE.axis == class_2350.class_2351.field_11051 ? controllerBE.radius : controllerBE.length); ++x) {
                    this.field_11863.method_8455(pos.method_10069(x, y, z), this.method_11010().method_26204());
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.recalculateComparatorsNextTick) {
            this.updateComparators();
        }
    }

    @Override
    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    public ItemVaultBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof ItemVaultBlockEntity) {
            return (ItemVaultBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        class_2680 state = this.method_11010();
        if (ItemVaultBlock.isVault(state)) {
            state = (class_2680)state.method_11657((class_2769)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.method_10997().method_8652(this.field_11867, state, 22);
        }
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    @Override
    public void setController(class_2338 controller) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    @Override
    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.method_10550("Size");
            this.length = compound.method_10550("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.method_10562("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.method_11002() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.field_11863.method_16109(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010());
        }
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10569("Size", this.radius);
            compound.method_10569("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.method_10582("StorageType", "CombinedInv");
            compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : class_1799.field_8037);
        }
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        this.initCapability();
        return this.itemCapability;
    }

    private void initCapability() {
        CombinedStorage combinedInvWrapper;
        if (this.itemCapability != null) {
            return;
        }
        if (!this.isController()) {
            ItemVaultBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(this.method_11010()) == class_2350.class_2351.field_11051;
        ItemStackHandler[] invs = new ItemStackHandler[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    class_2338 vaultPos = alongZ ? this.field_11867.method_10069(xOffset, zOffset, yOffset) : this.field_11867.method_10069(yOffset, xOffset, zOffset);
                    ItemVaultBlockEntity vaultAt = (ItemVaultBlockEntity)ConnectivityHandler.partAt((class_2591)AllBlockEntityTypes.ITEM_VAULT.get(), (class_1922)this.field_11863, vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        this.itemCapability = combinedInvWrapper = new CombinedStorage(List.of(invs));
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (ItemVaultBlock.isVault(state)) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.method_5431();
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return this.getMainAxisOf(this);
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return this.getMaxWidth();
        }
        return ItemVaultBlockEntity.getMaxLength(width);
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.length;
    }

    @Override
    public int getWidth() {
        return this.radius;
    }

    @Override
    public void setHeight(int height) {
        this.length = height;
    }

    @Override
    public void setWidth(int width) {
        this.radius = width;
    }

    @Override
    public boolean hasInventory() {
        return true;
    }
}

