/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link;

import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;

public class LinkBehaviour
extends BlockEntityBehaviour
implements IRedstoneLinkable,
ClipboardCloneable {
    public static final BehaviourType<LinkBehaviour> TYPE = new BehaviourType();
    RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    ValueBoxTransform firstSlot;
    ValueBoxTransform secondSlot;
    class_243 textShift;
    public boolean newPosition;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;
    private Predicate<class_1657> canInteract;

    protected LinkBehaviour(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots) {
        super(be);
        this.firstSlot = (ValueBoxTransform)slots.getLeft();
        this.secondSlot = (ValueBoxTransform)slots.getRight();
        this.textShift = class_243.field_1353;
        this.newPosition = true;
        this.canInteract = FilteringBehaviour::playerCanInteract;
    }

    public static LinkBehaviour receiver(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntConsumer signalCallback) {
        LinkBehaviour behaviour = new LinkBehaviour(be, slots);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static LinkBehaviour transmitter(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntSupplier transmission) {
        LinkBehaviour behaviour = new LinkBehaviour(be, slots);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public LinkBehaviour moveText(class_243 shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(LinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    @Override
    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    @Override
    public int getTransmittedStrength() {
        return this.mode == Mode.TRANSMIT ? this.transmission.getAsInt() : 0;
    }

    @Override
    public void setReceivedStrength(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        this.signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((class_1936)this.getWorld(), this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().field_9236) {
            return;
        }
        this.getHandler().addToNetwork((class_1936)this.getWorld(), this);
        this.newPosition = true;
    }

    @Override
    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return Couple.create(this.frequencyFirst, this.frequencyLast);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.getWorld().field_9236) {
            return;
        }
        this.getHandler().removeFromNetwork((class_1936)this.getWorld(), this);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10566("FrequencyFirst", (class_2520)this.frequencyFirst.getStack().method_7953(new class_2487()));
        nbt.method_10566("FrequencyLast", (class_2520)this.frequencyLast.getStack().method_7953(new class_2487()));
        nbt.method_10544("LastKnownPosition", this.blockEntity.method_11016().method_10063());
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        long positionKey;
        long positionInTag = this.blockEntity.method_11016().method_10063();
        this.newPosition = positionInTag != (positionKey = nbt.method_10537("LastKnownPosition"));
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(class_1799.method_7915((class_2487)nbt.method_10562("FrequencyFirst")));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(class_1799.method_7915((class_2487)nbt.method_10562("FrequencyLast")));
    }

    public void setFrequency(boolean first, class_1799 stack) {
        boolean changed;
        stack = stack.method_7972();
        stack.method_7939(1);
        class_1799 toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !class_1799.method_7984((class_1799)stack, (class_1799)toCompare) || !class_1799.method_7975((class_1799)stack, (class_1799)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((class_1936)this.getWorld(), this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.getHandler().addToNetwork((class_1936)this.getWorld(), this);
    }

    public LinkBehaviour interactiveWhen(Predicate<class_1657> condition) {
        this.canInteract = condition;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    public boolean testHit(Boolean first, class_243 hit) {
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return (first != false ? this.firstSlot : this.secondSlot).testHit(state, localHit);
    }

    @Override
    public boolean isAlive() {
        class_1937 level = this.getWorld();
        class_2338 pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.method_11015()) {
            return false;
        }
        if (!level.method_8477(pos)) {
            return false;
        }
        return level.method_8321(pos) == this.blockEntity;
    }

    public boolean canInteract(class_1657 player) {
        return this.canInteract.test(player);
    }

    @Override
    public class_2338 getLocation() {
        return this.getPos();
    }

    @Override
    public String getClipboardKey() {
        return "Frequencies";
    }

    @Override
    public boolean writeToClipboard(class_2487 tag, class_2350 side) {
        tag.method_10566("First", (class_2520)this.frequencyFirst.getStack().method_7953(new class_2487()));
        tag.method_10566("Last", (class_2520)this.frequencyLast.getStack().method_7953(new class_2487()));
        return true;
    }

    @Override
    public boolean readFromClipboard(class_2487 tag, class_1657 player, class_2350 side, boolean simulate) {
        if (!tag.method_10545("First") || !tag.method_10545("Last")) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setFrequency(true, class_1799.method_7915((class_2487)tag.method_10562("First")));
        this.setFrequency(false, class_1799.method_7915((class_2487)tag.method_10562("Last")));
        return true;
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }

    public static class SlotPositioning {
        Function<class_2680, Pair<class_243, class_243>> offsets;
        Function<class_2680, class_243> rotation;
        float scale;

        public SlotPositioning(Function<class_2680, Pair<class_243, class_243>> offsetsForState, Function<class_2680, class_243> rotationForState) {
            this.offsets = offsetsForState;
            this.rotation = rotationForState;
            this.scale = 1.0f;
        }

        public SlotPositioning scale(float scale) {
            this.scale = scale;
            return this;
        }
    }
}

