/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Locale;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.parsing.BiomeCategories;
import net.coderbot.iris.parsing.ExtendedBiome;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5458;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;

public class BiomeParameters {
    private static final class_310 client = class_310.method_1551();

    public static void addBiomeUniforms(UniformHolder uniformHolder) {
        uniformHolder.uniform1i(UniformUpdateFrequency.PER_TICK, "biome", BiomeParameters.playerI(class_7462 -> class_5458.field_25933.method_10206((Object)((class_1959)class_7462.field_6002.method_23753(class_7462.method_24515()).comp_349())))).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_category", BiomeParameters.playerI(class_7462 -> {
            class_6880 class_68802 = class_7462.field_6002.method_23753(class_7462.method_24515());
            ExtendedBiome extendedBiome = (ExtendedBiome)class_68802.comp_349();
            if (extendedBiome.getBiomeCategory() == -1) {
                extendedBiome.setBiomeCategory(BiomeParameters.getBiomeCategory((class_6880<class_1959>)class_68802).ordinal());
                return extendedBiome.getBiomeCategory();
            }
            return extendedBiome.getBiomeCategory();
        })).uniform1i(UniformUpdateFrequency.PER_TICK, "biome_precipitation", BiomeParameters.playerI(class_7462 -> {
            class_1959.class_1963 class_19632 = ((class_1959)class_7462.field_6002.method_23753(class_7462.method_24515()).comp_349()).method_8694();
            switch (class_19632) {
                case field_9384: {
                    return 0;
                }
                case field_9382: {
                    return 1;
                }
                case field_9383: {
                    return 2;
                }
            }
            throw new IllegalStateException("Unknown precipitation type:" + class_19632);
        })).uniform1f(UniformUpdateFrequency.PER_TICK, "rainfall", BiomeParameters.playerF(class_7462 -> ((class_1959)class_7462.field_6002.method_23753(class_7462.method_24515()).comp_349()).method_8715())).uniform1f(UniformUpdateFrequency.PER_TICK, "temperature", BiomeParameters.playerF(class_7462 -> ((class_1959)class_7462.field_6002.method_23753(class_7462.method_24515()).comp_349()).method_8712())).uniform1i(UniformUpdateFrequency.ONCE, "PPT_NONE", () -> 0).uniform1i(UniformUpdateFrequency.ONCE, "PPT_RAIN", () -> 1).uniform1i(UniformUpdateFrequency.ONCE, "PPT_SNOW", () -> 2);
        BiomeParameters.addBiomes(uniformHolder);
        BiomeParameters.addCategories(uniformHolder);
    }

    private static BiomeCategories getBiomeCategory(class_6880<class_1959> class_68802) {
        if (class_68802.method_40220(class_6908.field_37383)) {
            return BiomeCategories.NONE;
        }
        if (class_68802.method_40220(class_6908.field_36499)) {
            return BiomeCategories.ICY;
        }
        if (class_68802.method_40220(class_6908.field_36514)) {
            return BiomeCategories.EXTREME_HILLS;
        }
        if (class_68802.method_40220(class_6908.field_36515)) {
            return BiomeCategories.TAIGA;
        }
        if (class_68802.method_40220(class_6908.field_36509)) {
            return BiomeCategories.OCEAN;
        }
        if (class_68802.method_40220(class_6908.field_36516)) {
            return BiomeCategories.JUNGLE;
        }
        if (class_68802.method_40220(class_6908.field_36517)) {
            return BiomeCategories.FOREST;
        }
        if (class_68802.method_40220(class_6908.field_36513)) {
            return BiomeCategories.MESA;
        }
        if (class_68802.method_40220(class_6908.field_36518)) {
            return BiomeCategories.NETHER;
        }
        if (class_68802.method_40220(class_6908.field_37394)) {
            return BiomeCategories.THE_END;
        }
        if (class_68802.method_40220(class_6908.field_36510)) {
            return BiomeCategories.BEACH;
        }
        if (class_68802.method_40220(class_6908.field_36520)) {
            return BiomeCategories.DESERT;
        }
        if (class_68802.method_40220(class_6908.field_36511)) {
            return BiomeCategories.RIVER;
        }
        if (class_68802.method_40220(class_6908.field_37378)) {
            return BiomeCategories.SWAMP;
        }
        if (class_68802.method_40220(class_6908.field_37377)) {
            return BiomeCategories.UNDERGROUND;
        }
        if (class_68802.method_40220(class_6908.field_37381)) {
            return BiomeCategories.MUSHROOM;
        }
        if (class_68802.method_40220(class_6908.field_36512)) {
            return BiomeCategories.MOUNTAIN;
        }
        return BiomeCategories.PLAINS;
    }

    public static void addBiomes(UniformHolder uniformHolder) {
        for (class_1959 class_19592 : class_5458.field_25933) {
            class_2960 class_29602 = class_5458.field_25933.method_10221((Object)class_19592);
            if (class_29602 == null || !class_29602.method_12836().equals("minecraft")) continue;
            int n = class_5458.field_25933.method_10206((Object)class_19592);
            uniformHolder.uniform1i(UniformUpdateFrequency.ONCE, "BIOME_" + class_29602.method_12832().toUpperCase(Locale.ROOT), () -> n);
        }
    }

    public static void addCategories(UniformHolder uniformHolder) {
        BiomeCategories[] biomeCategoriesArray = BiomeCategories.values();
        for (int i = 0; i < biomeCategoriesArray.length; ++i) {
            int n = i;
            uniformHolder.uniform1i(UniformUpdateFrequency.ONCE, "CAT_" + biomeCategoriesArray[i].name().toUpperCase(Locale.ROOT), () -> n);
        }
    }

    static IntSupplier playerI(ToIntFunction<class_746> toIntFunction) {
        return () -> {
            class_746 class_7462 = BiomeParameters.client.field_1724;
            if (class_7462 == null) {
                return 0;
            }
            return toIntFunction.applyAsInt(class_7462);
        };
    }

    static FloatSupplier playerF(ToFloatFunction<class_746> toFloatFunction) {
        return () -> {
            class_746 class_7462 = BiomeParameters.client.field_1724;
            if (class_7462 == null) {
                return 0.0f;
            }
            return toFloatFunction.applyAsFloat(class_7462);
        };
    }

    @FunctionalInterface
    public static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }
}

