/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import com.communi.suggestu.scena.core.IScenaPlatform;
import com.communi.suggestu.scena.core.blockstate.ILevelBasedPropertyAccessor;
import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import com.communi.suggestu.scena.core.client.models.data.IModelDataBuilder;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.communi.suggestu.scena.core.entity.block.IBlockEntityWithModelData;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.entity.INetworkUpdateableEntity;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataManager;
import mod.chiselsandbits.network.packets.TileEntityUpdatedPacket;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.storage.IMultiThreadedStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.StorageEngineBuilder;
import mod.chiselsandbits.utils.BlockPosUtils;
import mod.chiselsandbits.utils.LZ4DataCompressionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.voxelshape.MultiStateBlockEntityDiscreteVoxelShape;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_249;
import net.minecraft.class_2499;
import net.minecraft.class_251;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3558;
import net.minecraft.class_3738;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockEntity
extends class_2586
implements IMultiStateBlockEntity,
INetworkUpdateableEntity,
IBlockEntityWithModelData {
    public static final float ONE_THOUSANDS = 0.001f;
    private MutableStatistics mutableStatistics;
    private final Map<UUID, IBatchMutation> batchMutations = Maps.newConcurrentMap();
    private final Object tagSyncHandle = new Object();
    private IStateEntryStorage storage;
    private IMultiThreadedStorageEngine storageEngine;
    private boolean isInitialized = false;
    private IBlockModelData modelData = IModelDataBuilder.create().build();
    private class_2487 lastTag = null;
    private CompletableFuture<Void> storageFuture = null;
    private final List<class_2487> deserializationQueue = Collections.synchronizedList(Lists.newArrayList());

    public ChiseledBlockEntity(class_2338 position, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.CHISELED.get(), position, state);
        this.storage = new SimpleStateEntryStorage();
        this.mutableStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)this).method_10997(), () -> ((ChiseledBlockEntity)this).method_11016());
        this.createStorageEngine();
    }

    @NotNull
    private static Executor createDefaultExecutor() {
        return (Executor)DistExecutor.unsafeRunForDist(() -> class_310::method_1551, () -> () -> new ServerSchedulingExecutor(IScenaPlatform.getInstance().getCurrentServer()));
    }

    private void createStorageEngine() {
        this.storageEngine = StorageEngineBuilder.create().with(new LZ4StorageBasedStorageHandler()).buildMultiThreaded(this.getExecutor());
    }

    private Executor getExecutor() {
        if (this.method_10997() != null && this.method_10997().method_8503() != null) {
            return new ServerSchedulingExecutor(this.method_10997().method_8503());
        }
        return ChiseledBlockEntity.createDefaultExecutor();
    }

    public void updateModelData() {
        ChiseledBlockModelDataManager.getInstance().updateModelData(this);
    }

    private void updateModelDataIfInLoadedChunk() {
        if (this.field_11863 != null && this.field_11863.method_8608() && this.field_11863.method_8477(this.method_11016())) {
            this.updateModelData();
            this.field_11863.method_22336().method_15513(this.method_11016());
        }
    }

    public void method_31662(@Nullable class_1937 level) {
        super.method_31662(level);
        this.createStorageEngine();
        if (this.deserializationQueue.isEmpty()) {
            return;
        }
        this.deserializationQueue.forEach(this::deserializeNBT);
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.storage);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_1936)this.method_10997(), this.method_11016(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        return !(inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation blockInformation = this.storage.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        return Optional.of(new StateEntry(blockInformation, (class_1936)this.method_10997(), this.method_11016(), (class_2382)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromStorage(this.storage);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        if (this.method_10997() != null) {
            this.deserializeNBT(nbt);
        }
        this.queueDeserializeNbt(nbt);
    }

    private void queueDeserializeNbt(class_2487 nbt) {
        this.deserializationQueue.add(nbt);
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.deserializeNBT(nbt, this::updateModelDataIfInLoadedChunk);
    }

    public void deserializeNBT(class_2487 nbt, Runnable onLoaded) {
        ((CompletableFuture)this.storageEngine.deserializeOffThread(nbt).thenRun(onLoaded)).thenRunAsync(() -> {
            if (this.mutableStatistics.isRequiresRecalculation()) {
                this.mutableStatistics.recalculate(this.storage, this.shouldUpdateWorld());
            }
            this.mutableStatistics.updatePrimaryState(this.shouldUpdateWorld());
        }, this.getExecutor());
        this.lastTag = nbt;
    }

    @Override
    public class_2487 serializeNBT() {
        return this.method_38242();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11007(@NotNull class_2487 compound) {
        super.method_11007(compound);
        Object object = this.tagSyncHandle;
        synchronized (object) {
            if (this.lastTag != null) {
                class_2487 nbt = this.lastTag.method_10553();
                nbt.method_10541().forEach(key -> compound.method_10566(key, nbt.method_10580(key)));
                return;
            }
        }
        if (this.storageFuture != null) {
            this.storageFuture.join();
            Validate.notNull((Object)this.lastTag, (String)"The storage future did not complete.", (Object[])new Object[0]);
            class_2487 nbt = this.lastTag.method_10553();
            nbt.method_10541().forEach(key -> compound.method_10566(key, nbt.method_10580(key)));
            return;
        }
        this.storageEngine.serializeNBTInto(compound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5431() {
        if (this.method_10997() != null && this.batchMutations.isEmpty() && !this.method_10997().method_8608()) {
            this.mutableStatistics.updatePrimaryState(true);
            if (!this.method_10997().method_8608()) {
                Object object = this.tagSyncHandle;
                synchronized (object) {
                    if (this.storageFuture != null) {
                        this.storageFuture.cancel(false);
                    }
                    this.lastTag = null;
                    this.storageFuture = this.storageEngine.serializeOffThread(tag -> CompletableFuture.runAsync(() -> this.setOffThreadSaveResult((class_2487)tag), this.storageEngine));
                    ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new TileEntityUpdatedPacket(this), this.method_10997().method_8500(this.method_11016()));
                }
            }
        }
        if (this.method_10997() != null && this.batchMutations.isEmpty()) {
            super.method_5431();
            this.method_10997().method_22336().method_15513(this.method_11016());
            this.method_10997().method_8413(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010(), 3);
            this.method_10997().method_8452(this.method_11016(), this.method_10997().method_8320(this.method_11016()).method_26204());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOffThreadSaveResult(class_2487 tag) {
        Object object = this.tagSyncHandle;
        synchronized (object) {
            this.lastTag = tag;
        }
    }

    private boolean shouldUpdateWorld() {
        return this.method_10997() != null && this.batchMutations.size() == 0 && this.method_10997() instanceof class_3218;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        if (this.isInitialized || this.lastTag == null) {
            return (class_2487)this.storageEngine.serializeNBT();
        }
        return this.lastTag;
    }

    @Override
    public void handleUpdateTag(class_2487 tag) {
        this.method_11014(tag);
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        this.storage.serializeInto(packetBuffer);
        this.mutableStatistics.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.storage.deserializeFrom(packetBuffer);
        this.mutableStatistics.deserializeFrom(packetBuffer);
        this.updateModelDataIfInLoadedChunk();
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_1936)this.method_10997(), this.method_11016(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(IBlockInformation newInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation information = this.storage.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        if (!information.isAir()) {
            throw new SpaceOccupiedException();
        }
        if (this.method_10997() == null) {
            return;
        }
        this.storage.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), newInformation);
        if (newInformation.isAir() && !information.isAir()) {
            this.mutableStatistics.onBlockStateRemoved(information, inAreaPos, this.shouldUpdateWorld());
        } else if (!newInformation.isAir() && information.isAir()) {
            this.mutableStatistics.onBlockStateAdded(newInformation, inAreaPos, this.shouldUpdateWorld());
        } else if (!newInformation.isAir() && !information.isAir()) {
            this.mutableStatistics.onBlockStateReplaced(information, newInformation, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.method_10997() != null) {
            this.method_5431();
        }
    }

    @Override
    public class_1936 getWorld() {
        return this.method_10997();
    }

    @Override
    public class_243 getInWorldStartPoint() {
        return class_243.method_24954((class_2382)this.method_11016());
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public class_243 getInWorldEndPoint() {
        return this.getInWorldStartPoint().method_1031(1.0, 1.0, 1.0).method_1023((double)0.001f, (double)0.001f, (double)0.001f);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        if (this.method_10997() == null) {
            return;
        }
        IBlockInformation currentInformation = this.storage.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        if (currentInformation.isAir()) {
            return;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(currentInformation)) {
            return;
        }
        IBlockInformation blockState = BlockInformation.AIR;
        this.storage.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), blockState);
        if (blockState.isAir() && !currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateRemoved(currentInformation, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.isAir() && currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateAdded(blockState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.isAir() && !currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateReplaced(currentInformation, blockState, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.method_10997() != null) {
            this.method_5431();
        }
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateObjectStatistics getStatistics() {
        return this.mutableStatistics;
    }

    @Override
    public void rotate(class_2350.class_2351 axis, int rotationCount) {
        if (this.method_10997() == null) {
            return;
        }
        try (IBatchMutation ignored = this.batch();){
            this.storage.rotate(axis, rotationCount);
            this.mutableStatistics.recalculate(this.storage);
        }
    }

    @Override
    public void mirror(class_2350.class_2351 axis) {
        if (this.method_10997() == null) {
            return;
        }
        try (IBatchMutation ignored = this.batch();){
            this.storage.mirror(axis);
            this.mutableStatistics.recalculate(this.storage);
        }
    }

    @Override
    public void initializeWith(IBlockInformation newInitialInformation) {
        if (this.method_10997() == null) {
            return;
        }
        try (IBatchMutation batchMutation = this.batch();){
            this.storage.initializeWith(newInitialInformation);
            this.mutableStatistics.initializeWith(newInitialInformation);
        }
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_1936)this.method_10997(), this.method_11016(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> {
            class_2382 pos = positionMutator.mutate((class_2382)blockPos);
            return new StateEntry(this.storage.getBlockInformation(pos.method_10263(), pos.method_10264(), pos.method_10260()), (class_1936)this.method_10997(), this.method_11016(), pos, this::setInAreaTarget, this::clearInAreaTarget);
        });
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            class_2382 pos = positionMutator.mutate((class_2382)blockPos);
            consumer.accept(new StateEntry(this.storage.getBlockInformation(pos.method_10263(), pos.method_10264(), pos.method_10260()), (class_1936)this.method_10997(), this.method_11016(), pos, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    @Override
    public IBatchMutation batch() {
        UUID id = UUID.randomUUID();
        IBatchMutation storageBatch = this.storage.batch();
        this.batchMutations.put(id, new BatchMutationLock(() -> {
            this.batchMutations.remove(id);
            storageBatch.close();
            if (this.batchMutations.isEmpty()) {
                this.method_5431();
            }
        }));
        return this.batchMutations.get(id);
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        IBatchMutation innerMutation = this.batch();
        IMultiStateSnapshot before = this.createSnapshot();
        return () -> {
            IMultiStateSnapshot after = this.createSnapshot();
            innerMutation.close();
            changeTracker.onBlockUpdated(this.method_11016(), before, after);
        };
    }

    public void setModelData(IBlockModelData modelData) {
        this.modelData = modelData;
    }

    @NotNull
    public IBlockModelData getBlockModelData() {
        return this.modelData;
    }

    @Override
    public class_265 provideShape(CollisionType type, class_2338 offset, boolean simplify) {
        class_249 shape = new class_249((class_251)new MultiStateBlockEntityDiscreteVoxelShape(this.getStatistics().getCollideableEntries(type)));
        if (offset != class_2338.field_10980) {
            shape = shape.method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
        }
        if (simplify) {
            shape = shape.method_1097();
        }
        return shape;
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), (double)(this.method_11016().method_10263() + 1), (double)(this.method_11016().method_10264() + 1), (double)(this.method_11016().method_10260() + 1));
    }

    private final class MutableStatistics
    implements IMultiStateObjectStatistics,
    INBTSerializable<class_2487>,
    IPacketBufferSerializable {
        private final Supplier<class_1936> worldReaderSupplier;
        private final Supplier<class_2338> positionSupplier;
        private final Map<IBlockInformation, Integer> countMap = Maps.newConcurrentMap();
        private final Table<Integer, Integer, ColumnStatistics> columnStatisticsTable = HashBasedTable.create();
        private final Map<CollisionType, BitSet> collisionData = Maps.newConcurrentMap();
        private IBlockInformation primaryState = BlockInformation.AIR;
        private int totalUsedBlockCount = 0;
        private int totalUsedChecksWeakPowerCount = 0;
        private int totalLightLevel = 0;
        private int totalLightBlockLevel = 0;
        private boolean requiresRecalculation = false;

        private MutableStatistics(Supplier<class_1936> worldReaderSupplier, Supplier<class_2338> positionSupplier) {
            this.worldReaderSupplier = worldReaderSupplier;
            this.positionSupplier = positionSupplier;
        }

        @Override
        public IBlockInformation getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.size() == 1 && this.countMap.getOrDefault(BlockInformation.AIR, 0) == 4096;
        }

        @Override
        public Map<IBlockInformation, Integer> getStateCounts() {
            return Collections.unmodifiableMap(this.countMap);
        }

        @Override
        public boolean shouldCheckWeakPower() {
            return this.totalUsedChecksWeakPowerCount == this.totalUsedBlockCount;
        }

        @Override
        public float getFullnessFactor() {
            return (float)this.totalUsedBlockCount / (float)StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getSlipperiness() {
            return (float)this.columnStatisticsTable.values().stream().filter(columnStatistics -> columnStatistics.getHighestBit() >= 0).mapToDouble(ColumnStatistics::getHighestBitFriction).average().orElse(0.0);
        }

        @Override
        public float getLightEmissionFactor() {
            return (float)this.totalLightLevel / (float)this.totalUsedBlockCount;
        }

        @Override
        public float getLightBlockingFactor() {
            return (float)this.totalLightBlockLevel / (float)StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getRelativeBlockHardness(class_1657 player) {
            double totalRelativeHardness = this.countMap.entrySet().stream().mapToDouble(entry -> (double)((IBlockInformation)entry.getKey()).getBlockState().method_26165(player, (class_1922)new SingleBlockWorldReader((IBlockInformation)entry.getKey(), this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()) * (double)((Integer)entry.getValue()).intValue()).filter(Double::isFinite).sum();
            if (totalRelativeHardness == 0.0 || Double.isNaN(totalRelativeHardness) || Double.isInfinite(totalRelativeHardness)) {
                return 0.0f;
            }
            return (float)(totalRelativeHardness / (double)this.totalUsedBlockCount);
        }

        @Override
        public boolean canPropagateSkylight() {
            return this.columnStatisticsTable.values().stream().allMatch(ColumnStatistics::canPropagateSkylightDown);
        }

        @Override
        public boolean canSustainGrassBelow() {
            return this.columnStatisticsTable.values().stream().anyMatch(ColumnStatistics::canLowestBitSustainGrass);
        }

        @Override
        public BitSet getCollideableEntries(CollisionType collisionType) {
            BitSet collisionDataSet = this.collisionData.computeIfAbsent(collisionType, type -> {
                if (!ChiseledBlockEntity.this.shouldUpdateWorld()) {
                    return null;
                }
                BitSet bitSet = new BitSet(StateEntrySize.current().getBitsPerBlock());
                BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> bitSet.set(BlockPosUtils.getCollisionIndex(blockPos), type.isValidFor(ChiseledBlockEntity.this.storage.getBlockInformation((class_2382)blockPos).getBlockState())));
                return bitSet;
            });
            if (collisionDataSet == null) {
                return new BitSet(0);
            }
            return collisionDataSet;
        }

        private void onBlockStateAdded(IBlockInformation blockInformation, class_2338 pos, boolean updateWorld) {
            this.countMap.putIfAbsent(blockInformation, 0);
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            ++this.totalUsedBlockCount;
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.method_10263(), (Object)pos.method_10260())) {
                this.columnStatisticsTable.put((Object)pos.method_10263(), (Object)pos.method_10260(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.method_10263(), (Object)pos.method_10260())).onBlockStateAdded(blockInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(blockInformation.getBlockState())));
        }

        private void updatePrimaryState(boolean updateWorld) {
            IBlockInformation currentPrimary = this.primaryState;
            this.primaryState = this.countMap.entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
            boolean primaryIsAir = this.primaryState.isAir();
            if ((this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock() || primaryIsAir || currentPrimary != this.primaryState) && updateWorld) {
                Optional<class_2248> optionalWithConvertedBlock;
                if (primaryIsAir) {
                    this.worldReaderSupplier.get().method_8652(this.positionSupplier.get(), class_2246.field_10124.method_9564(), 3);
                } else if (this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock()) {
                    this.worldReaderSupplier.get().method_8652(this.positionSupplier.get(), this.primaryState.getBlockState(), 3);
                } else if (currentPrimary != this.primaryState && (optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(this.primaryState.getBlockState())).isPresent()) {
                    class_2248 convertedBlock = optionalWithConvertedBlock.get();
                    this.worldReaderSupplier.get().method_8652(this.positionSupplier.get(), convertedBlock.method_9564(), 3);
                }
            }
        }

        private void onBlockStateRemoved(IBlockInformation blockInformation, class_2338 pos, boolean updateWorld) {
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockInformation, 0);
            this.updatePrimaryState(updateWorld);
            --this.totalUsedBlockCount;
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel -= ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel -= ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.method_10263(), (Object)pos.method_10260())) {
                this.columnStatisticsTable.put((Object)pos.method_10263(), (Object)pos.method_10260(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.method_10263(), (Object)pos.method_10260())).onBlockStateRemoved(blockInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(class_2246.field_10124.method_9564())));
        }

        private void onBlockStateReplaced(IBlockInformation currentInformation, IBlockInformation newInformation, class_2338 pos, boolean updateWorld) {
            this.countMap.computeIfPresent(currentInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentInformation, 0);
            this.countMap.putIfAbsent(newInformation, 0);
            this.countMap.computeIfPresent(newInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel -= ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel -= ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.method_10263(), (Object)pos.method_10260())) {
                this.columnStatisticsTable.put((Object)pos.method_10263(), (Object)pos.method_10260(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.method_10263(), (Object)pos.method_10260())).onBlockStateReplaced(currentInformation, newInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(newInformation.getBlockState())));
        }

        @Override
        public void serializeInto(@NotNull class_2540 packetBuffer) {
            this.primaryState.serializeInto(packetBuffer);
            packetBuffer.method_10804(this.countMap.size());
            for (Map.Entry<IBlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                blockStateIntegerEntry.getKey().serializeInto(packetBuffer);
                packetBuffer.method_10804(blockStateIntegerEntry.getValue().intValue());
            }
            packetBuffer.method_10804(this.columnStatisticsTable.size());
            this.columnStatisticsTable.cellSet().forEach(cell -> {
                packetBuffer.method_10804(((Integer)cell.getRowKey()).intValue());
                packetBuffer.method_10804(((Integer)cell.getColumnKey()).intValue());
                ((ColumnStatistics)cell.getValue()).serializeInto(packetBuffer);
            });
            packetBuffer.method_10804(this.totalUsedBlockCount);
            packetBuffer.method_10804(this.totalUsedChecksWeakPowerCount);
            packetBuffer.method_10804(this.totalLightLevel);
            packetBuffer.method_10804(this.totalLightBlockLevel);
            packetBuffer.method_10804(this.collisionData.size());
            this.collisionData.forEach((collisionType, bitSet) -> {
                packetBuffer.method_10804(collisionType.ordinal());
                packetBuffer.method_10789(bitSet.toLongArray());
            });
        }

        @Override
        public void deserializeFrom(@NotNull class_2540 packetBuffer) {
            this.countMap.clear();
            this.columnStatisticsTable.clear();
            this.collisionData.clear();
            this.primaryState = new BlockInformation(packetBuffer);
            int stateCount = packetBuffer.method_10816();
            for (int i = 0; i < stateCount; ++i) {
                this.countMap.put(new BlockInformation(packetBuffer), packetBuffer.method_10816());
            }
            int columnBlockCount = packetBuffer.method_10816();
            for (int i = 0; i < columnBlockCount; ++i) {
                ColumnStatistics statistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                this.columnStatisticsTable.put((Object)packetBuffer.method_10816(), (Object)packetBuffer.method_10816(), (Object)statistics);
                statistics.deserializeFrom(packetBuffer);
            }
            this.totalUsedBlockCount = packetBuffer.method_10816();
            this.totalUsedChecksWeakPowerCount = packetBuffer.method_10816();
            this.totalLightLevel = packetBuffer.method_10816();
            this.totalLightBlockLevel = packetBuffer.method_10816();
            int axisSizeHandlerCount = packetBuffer.method_10816();
            for (int i = 0; i < axisSizeHandlerCount; ++i) {
                CollisionType collisionType = CollisionType.values()[packetBuffer.method_10816()];
                BitSet set = BitSet.valueOf(packetBuffer.method_33134());
                this.collisionData.put(collisionType, set);
            }
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("primary_block_information", this.primaryState.serializeNBT());
            class_2499 blockStateList = new class_2499();
            for (Map.Entry<IBlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                class_2487 stateNbt = new class_2487();
                stateNbt.method_10566("block_information", blockStateIntegerEntry.getKey().serializeNBT());
                stateNbt.method_10569("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            class_2487 columnStatisticsTableNbt = new class_2487();
            this.columnStatisticsTable.rowMap().forEach((rowKey, columnStatisticsMap) -> {
                class_2487 rowNbt = new class_2487();
                columnStatisticsMap.forEach((columnKey, columnStatistics) -> rowNbt.method_10566(String.valueOf(columnKey), (class_2520)columnStatistics.serializeNBT()));
                columnStatisticsTableNbt.method_10566(String.valueOf(rowKey), (class_2520)rowNbt);
            });
            nbt.method_10566("blockStates", (class_2520)blockStateList);
            nbt.method_10566("column_statistics", (class_2520)columnStatisticsTableNbt);
            nbt.method_10569("blockCount", this.totalUsedBlockCount);
            nbt.method_10569("blockShouldCheckWeakPowerCount", this.totalUsedChecksWeakPowerCount);
            nbt.method_10569("totalLightLevel", this.totalLightLevel);
            nbt.method_10569("totalLightBlockLevel", this.totalLightBlockLevel);
            class_2487 collisionDataNbt = new class_2487();
            for (CollisionType collisionType : CollisionType.values()) {
                collisionDataNbt.method_10564(collisionType.name(), this.getCollideableEntries(collisionType).toLongArray());
            }
            nbt.method_10566("collision_data", (class_2520)collisionDataNbt);
            return nbt;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            this.countMap.clear();
            this.primaryState = new BlockInformation(nbt.method_10562("primary_block_information"));
            if (nbt.method_10573("blockStates", 9)) {
                class_2499 blockStateList = nbt.method_10554("blockStates", 10);
                for (int i = 0; i < blockStateList.size(); ++i) {
                    class_2487 stateNbt = blockStateList.method_10602(i);
                    BlockInformation blockInformation = new BlockInformation(stateNbt.method_10562("block_information"));
                    this.countMap.put(blockInformation, stateNbt.method_10550("count"));
                }
            }
            this.columnStatisticsTable.clear();
            if (nbt.method_10573("column_statistics", 10)) {
                class_2487 columnStatisticsTableNbt = nbt.method_10562("column_statistics");
                columnStatisticsTableNbt.method_10541().forEach(rowKeyValue -> {
                    Integer rowKey = Integer.valueOf(rowKeyValue);
                    class_2487 rowNbt = columnStatisticsTableNbt.method_10562(rowKeyValue);
                    rowNbt.method_10541().forEach(columnKeyValue -> {
                        Integer columnKey = Integer.valueOf(columnKeyValue);
                        class_2487 columnStatisticsNbt = rowNbt.method_10562(columnKeyValue);
                        ColumnStatistics columnStatistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                        columnStatistics.deserializeNBT(columnStatisticsNbt);
                        this.columnStatisticsTable.put((Object)rowKey, (Object)columnKey, (Object)columnStatistics);
                    });
                });
            } else {
                this.requiresRecalculation = true;
            }
            this.totalUsedBlockCount = nbt.method_10550("blockCount");
            this.totalUsedChecksWeakPowerCount = nbt.method_10550("blockShouldCheckWeakPowerCount");
            this.totalLightLevel = nbt.method_10550("totalLightLevel");
            if (nbt.method_10545("totalLightBlockLevel")) {
                this.totalLightBlockLevel = nbt.method_10550("totalLightBlockLevel");
            } else {
                this.totalLightBlockLevel = 0;
                this.requiresRecalculation = true;
            }
            this.collisionData.clear();
            if (nbt.method_10545("collision_data")) {
                class_2487 collisionDataNbt = nbt.method_10562("collision_data");
                collisionDataNbt.method_10541().forEach(collisionTypeName -> {
                    CollisionType collisionType = CollisionType.valueOf(collisionTypeName);
                    BitSet set = BitSet.valueOf(collisionDataNbt.method_10565(collisionTypeName));
                    this.collisionData.put(collisionType, set);
                });
            } else {
                this.requiresRecalculation = true;
            }
        }

        public void initializeWith(IBlockInformation blockInformation) {
            this.clear();
            boolean isAir = blockInformation.isAir();
            this.primaryState = blockInformation;
            if (!isAir) {
                this.countMap.put(blockInformation, StateEntrySize.current().getBitsPerBlock());
            }
            int n = this.totalUsedBlockCount = isAir ? 0 : StateEntrySize.current().getBitsPerBlock();
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                this.totalUsedChecksWeakPowerCount = StateEntrySize.current().getBitsPerBlock();
            }
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()) * StateEntrySize.current().getBitsPerBlock();
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()) * StateEntrySize.current().getBitsPerBlock();
            this.columnStatisticsTable.clear();
            IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).forEach(x -> IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).forEach(z -> {
                ColumnStatistics columnStatistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                columnStatistics.initializeWith(blockInformation);
                this.columnStatisticsTable.put((Object)x, (Object)z, (Object)columnStatistics);
            }));
            this.collisionData.clear();
            for (CollisionType collisionType : CollisionType.values()) {
                boolean matches = collisionType.isValidFor(blockInformation.getBlockState());
                BitSet set = new BitSet(StateEntrySize.current().getBitsPerBlock());
                set.set(0, StateEntrySize.current().getBitsPerBlock(), matches);
                this.collisionData.put(collisionType, set);
            }
        }

        private void clear() {
            this.primaryState = BlockInformation.AIR;
            this.countMap.clear();
            this.columnStatisticsTable.clear();
            this.collisionData.clear();
            this.totalUsedBlockCount = 0;
            this.totalUsedChecksWeakPowerCount = 0;
            this.totalLightLevel = 0;
            this.totalLightBlockLevel = 0;
        }

        public boolean isRequiresRecalculation() {
            return this.requiresRecalculation;
        }

        private void recalculate(IStateEntryStorage source) {
            this.recalculate(source, true);
        }

        private void recalculate(IStateEntryStorage source, boolean mayUpdateWorld) {
            if (!mayUpdateWorld) {
                this.requiresRecalculation = true;
                return;
            }
            this.requiresRecalculation = false;
            this.clear();
            source.count(this.countMap::put);
            this.countMap.remove(BlockInformation.AIR);
            this.updatePrimaryState(mayUpdateWorld);
            this.totalUsedBlockCount = this.countMap.values().stream().mapToInt(i -> i).sum();
            this.countMap.forEach((blockState, count) -> {
                if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((class_4538)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), class_2350.field_11043)) {
                    this.totalUsedChecksWeakPowerCount += count.intValue();
                }
                this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((class_4538)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()) * count;
                this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((class_1922)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()) * count;
            });
            BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(pos -> {
                IBlockInformation blockState = source.getBlockInformation(pos.method_10263(), pos.method_10264(), pos.method_10260());
                if (!this.columnStatisticsTable.contains((Object)pos.method_10263(), (Object)pos.method_10260())) {
                    this.columnStatisticsTable.put((Object)pos.method_10263(), (Object)pos.method_10260(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
                }
                ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.method_10263(), (Object)pos.method_10260())).onBlockStateAdded(blockState, (class_2338)pos);
            });
            this.collisionData.clear();
            for (CollisionType collisionType : CollisionType.values()) {
                this.getCollideableEntries(collisionType);
            }
        }
    }

    private final class LZ4StorageBasedStorageHandler
    implements IStorageHandler<Payload> {
        private LZ4StorageBasedStorageHandler() {
        }

        @Override
        public Payload readPayloadOffThread(class_2487 nbt) {
            return LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                SimpleStateEntryStorage storage = new SimpleStateEntryStorage();
                MutableStatistics mutableStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)ChiseledBlockEntity.this).method_10997(), () -> ((ChiseledBlockEntity)ChiseledBlockEntity.this).method_11016());
                storage.deserializeNBT(compoundTag.method_10562("chiseledData"));
                mutableStatistics.deserializeNBT(compoundTag.method_10562("statistics"));
                return new Payload(storage, mutableStatistics);
            });
        }

        @Override
        public void syncPayloadOnGameThread(Payload payload) {
            ChiseledBlockEntity.this.storage = payload.storage;
            ChiseledBlockEntity.this.mutableStatistics = payload.mutableStatistics;
            if (!ChiseledBlockEntity.this.isInitialized) {
                ChiseledBlockEntity.this.method_5431();
            }
            ChiseledBlockEntity.this.isInitialized = true;
        }

        @Override
        public class_2487 serializeNBT() {
            return LZ4DataCompressionUtils.compress(compoundTag -> {
                compoundTag.method_10566("chiseledData", ChiseledBlockEntity.this.storage.serializeNBT());
                compoundTag.method_10566("statistics", (class_2520)ChiseledBlockEntity.this.mutableStatistics.serializeNBT());
            });
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                ChiseledBlockEntity.this.storage.deserializeNBT(compoundTag.method_10562("chiseledData"));
                ChiseledBlockEntity.this.mutableStatistics.deserializeNBT(compoundTag.method_10562("statistics"));
            });
        }

        private record Payload(IStateEntryStorage storage, MutableStatistics mutableStatistics) {
        }
    }

    private static final class ServerSchedulingExecutor
    implements Executor {
        private final MinecraftServer server;

        private ServerSchedulingExecutor(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.server.method_18858((Runnable)new class_3738(this.server.method_3780(), command));
        }
    }

    private static final class Identifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private Identifier(IStateEntryStorage section) {
            this.snapshot = section.createSnapshot();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && this.getPalette().equals(that.getPalette());
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        public String toString() {
            return "Identifier{snapshot=" + this.snapshot + "}";
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<IBlockInformation> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static final class StateEntry
    implements IInWorldMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final class_1936 reader;
        private final class_2338 blockPos;
        private final class_243 startPoint;
        private final class_243 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(IBlockInformation blockInformation, class_1936 reader, class_2338 blockPos, class_2382 startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(blockInformation, reader, blockPos, class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).method_1031((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(IBlockInformation blockInformation, class_1936 reader, class_2338 blockPos, class_243 startPoint, class_243 endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockInformation = blockInformation;
            this.reader = reader;
            this.blockPos = blockPos;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockState) throws SpaceOccupiedException {
            this.stateSetter.set(blockState, this.getStartPoint());
        }

        @Override
        @NotNull
        public class_243 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public class_243 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }

        @Override
        public class_1936 getWorld() {
            return this.reader;
        }

        @Override
        public class_2338 getBlockPos() {
            return this.blockPos;
        }
    }

    private record BatchMutationLock(Runnable closeCallback) implements IBatchMutation
    {
        @Override
        public void close() {
            this.closeCallback.run();
        }
    }

    private final class ColumnStatistics
    implements INBTSerializable<class_2487>,
    IPacketBufferSerializable {
        private final BitSet skylightBlockingBits = new BitSet(StateEntrySize.current().getBitsPerBlockSide());
        private final BitSet noneAirBits = new BitSet(StateEntrySize.current().getBitsPerBlockSide());
        private final Supplier<class_1936> worldReaderSupplier;
        private final Supplier<class_2338> positionSupplier;
        private short highestBit = (short)-1;
        private float highestBitFriction = 0.0f;
        private boolean canPropagateSkylightDown = true;
        private boolean canLowestBitSustainGrass = true;

        private ColumnStatistics(Supplier<class_1936> worldReaderSupplier, Supplier<class_2338> positionSupplier) {
            this.worldReaderSupplier = worldReaderSupplier;
            this.positionSupplier = positionSupplier;
        }

        public BitSet getSkylightBlockingBits() {
            return this.skylightBlockingBits;
        }

        public BitSet getNoneAirBits() {
            return this.noneAirBits;
        }

        public short getHighestBit() {
            return this.highestBit;
        }

        public float getHighestBitFriction() {
            return this.highestBitFriction;
        }

        public boolean canPropagateSkylightDown() {
            return this.canPropagateSkylightDown;
        }

        public boolean canLowestBitSustainGrass() {
            return this.canLowestBitSustainGrass;
        }

        private void onBlockStateAdded(IBlockInformation blockState, class_2338 pos) {
            this.skylightBlockingBits.set(pos.method_10264(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((class_1922)new SingleBlockBlockReader(blockState, this.positionSupplier.get(), (class_1922)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            if (this.skylightBlockingBits.get(pos.method_10264())) {
                this.canPropagateSkylightDown = false;
            }
            if (!blockState.isAir() && pos.method_10264() >= this.highestBit) {
                this.highestBit = (short)pos.method_10264();
                this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((class_4538)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            if (pos.method_10264() == 0) {
                this.canLowestBitSustainGrass = ILevelBasedPropertyAccessor.getInstance().canBeGrass((class_4538)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), class_2246.field_10219.method_9564(), this.positionSupplier.get().method_10074(), blockState.getBlockState(), this.positionSupplier.get()).orElseGet(() -> {
                    if (blockState.getBlockState().method_27852(class_2246.field_10477) && (Integer)blockState.getBlockState().method_11654((class_2769)class_2488.field_11518) == 1) {
                        return true;
                    }
                    if (blockState.getBlockState().method_26227().method_15761() == 8) {
                        return false;
                    }
                    int i = class_3558.method_20049((class_1922)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), (class_2680)class_2246.field_10219.method_9564(), (class_2338)this.positionSupplier.get().method_10074(), (class_2680)blockState.getBlockState(), (class_2338)this.positionSupplier.get(), (class_2350)class_2350.field_11036, (int)blockState.getBlockState().method_26193((class_1922)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()));
                    return i < this.worldReaderSupplier.get().method_8315();
                });
            }
        }

        private void onBlockStateRemoved(IBlockInformation blockInformation, class_2338 pos) {
            this.skylightBlockingBits.set(pos.method_10264(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((class_1922)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (class_1922)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            if (!this.skylightBlockingBits.get(pos.method_10264())) {
                this.canPropagateSkylightDown = IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).noneMatch(this.skylightBlockingBits::get);
            }
            if (pos.method_10264() >= this.highestBit) {
                this.highestBit = (short)-1;
                this.highestBitFriction = 0.0f;
                for (int i = StateEntrySize.current().getBitsPerBlockSide() - 1; i >= 0; --i) {
                    if (!this.noneAirBits.get(i)) continue;
                    this.highestBit = (short)i;
                    this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((class_4538)new SingleBlockWorldReader(ChiseledBlockEntity.this.storage.getBlockInformation(pos.method_10263(), i, pos.method_10260()), this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
                    break;
                }
            }
            if (pos.method_10264() == 0) {
                this.canLowestBitSustainGrass = true;
            }
        }

        private void onBlockStateReplaced(IBlockInformation currentInformation, IBlockInformation newInformation, class_2338 pos) {
            this.onBlockStateRemoved(currentInformation, pos);
            this.onBlockStateAdded(newInformation, pos);
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10570("skylight_blocking_bits", this.skylightBlockingBits.toByteArray());
            compoundTag.method_10570("none_air_bits", this.noneAirBits.toByteArray());
            compoundTag.method_10575("highestBit", this.highestBit);
            compoundTag.method_10548("highestBitFriction", this.highestBitFriction);
            compoundTag.method_10556("can_propagate_skylight_down", this.canPropagateSkylightDown);
            compoundTag.method_10556("lowest_bit_can_sustain_grass", this.canLowestBitSustainGrass);
            return compoundTag;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            this.skylightBlockingBits.clear();
            this.skylightBlockingBits.or(BitSet.valueOf(nbt.method_10547("skylight_blocking_bits")));
            this.noneAirBits.clear();
            this.noneAirBits.or(BitSet.valueOf(nbt.method_10547("none_air_bits")));
            this.highestBit = nbt.method_10568("highestBit");
            this.highestBitFriction = nbt.method_10583("highestBitFriction");
            this.canPropagateSkylightDown = nbt.method_10577("can_propagate_skylight_down");
            this.canLowestBitSustainGrass = nbt.method_10577("lowest_bit_can_sustain_grass");
        }

        @Override
        public void serializeInto(@NotNull class_2540 packetBuffer) {
            packetBuffer.method_33557(this.skylightBlockingBits);
            packetBuffer.method_33557(this.noneAirBits);
            packetBuffer.writeShort((int)this.highestBit);
            packetBuffer.writeFloat(this.highestBitFriction);
            packetBuffer.writeBoolean(this.canPropagateSkylightDown);
            packetBuffer.writeBoolean(this.canLowestBitSustainGrass);
        }

        @Override
        public void deserializeFrom(@NotNull class_2540 packetBuffer) {
            this.skylightBlockingBits.clear();
            this.skylightBlockingBits.or(packetBuffer.method_33558());
            this.noneAirBits.clear();
            this.noneAirBits.or(packetBuffer.method_33558());
            this.highestBit = packetBuffer.readShort();
            this.highestBitFriction = packetBuffer.readFloat();
            this.canPropagateSkylightDown = packetBuffer.readBoolean();
            this.canLowestBitSustainGrass = packetBuffer.readBoolean();
        }

        public void initializeWith(IBlockInformation blockInformation) {
            this.skylightBlockingBits.clear();
            this.noneAirBits.clear();
            this.skylightBlockingBits.set(0, StateEntrySize.current().getBitsPerBlockSide(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((class_1922)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (class_1922)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            this.noneAirBits.set(0, !blockInformation.isAir());
            if (blockInformation.isAir()) {
                this.highestBit = (short)-1;
                this.highestBitFriction = 0.0f;
            } else {
                this.highestBit = (short)(StateEntrySize.current().getBitsPerBlockSide() - 1);
                this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            this.canPropagateSkylightDown = ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((class_1922)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (class_1922)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.canLowestBitSustainGrass = blockInformation.isAir() || ILevelBasedPropertyAccessor.getInstance().canBeGrass((class_4538)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), class_2246.field_10219.method_9564(), this.positionSupplier.get().method_10074(), blockInformation.getBlockState(), this.positionSupplier.get()).orElseGet(() -> {
                if (blockInformation.getBlockState().method_27852(class_2246.field_10477) && (Integer)blockInformation.getBlockState().method_11654((class_2769)class_2488.field_11518) == 1) {
                    return true;
                }
                if (blockInformation.getBlockState().method_26227().method_15761() == 8) {
                    return false;
                }
                int i = class_3558.method_20049((class_1922)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), (class_2680)class_2246.field_10219.method_9564(), (class_2338)this.positionSupplier.get().method_10074(), (class_2680)blockInformation.getBlockState(), (class_2338)this.positionSupplier.get(), (class_2350)class_2350.field_11036, (int)blockInformation.getBlockState().method_26193((class_1922)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (class_4538)this.worldReaderSupplier.get()), this.positionSupplier.get()));
                return i < this.worldReaderSupplier.get().method_8315();
            }) != false;
        }
    }
}

