/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.connected.plane;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.IQuadFunction;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ConnectedPlaneChiselingMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int depth;
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    public ConnectedPlaneChiselingMode(int depth, class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.depth = depth;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, class_2350::method_10153, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), IQuadFunction.fourthIdentity(), position -> IMutatorFactory.getInstance().in(context.getWorld(), new class_2338(position)), direction -> class_2382.field_11176);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int totalDamage = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalDamage == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, UnaryOperator.identity(), face -> class_243.method_24954((class_2382)face.method_10163()), (hitPos, inBlockTargetedPosition, hitFace, candidatePosition) -> {
            if (inBlockTargetedPosition.equals(candidatePosition)) {
                return class_243.method_24954((class_2382)hitPos).method_1019(inBlockTargetedPosition).method_1019(class_243.method_24954((class_2382)hitFace.method_10153().method_10163()).method_18806(StateEntrySize.current().getSizePerBitScalingVector()));
            }
            class_243 relevantAxisCandidate = candidatePosition.method_18805((double)Math.abs(hitFace.method_10163().method_10263()), (double)Math.abs(hitFace.method_10163().method_10264()), (double)Math.abs(hitFace.method_10163().method_10260()));
            class_243 noneRelevantAxisCandidates = candidatePosition.method_1020(relevantAxisCandidate);
            class_243 relevantAxisTarget = inBlockTargetedPosition.method_18805((double)Math.abs(hitFace.method_10163().method_10263()), (double)Math.abs(hitFace.method_10163().method_10264()), (double)Math.abs(hitFace.method_10163().method_10260()));
            class_243 offset = candidatePosition.method_1020(inBlockTargetedPosition);
            class_243 relevantAxisOffset = offset.method_18805((double)Math.abs(hitFace.method_10163().method_10263()), (double)Math.abs(hitFace.method_10163().method_10264()), (double)Math.abs(hitFace.method_10163().method_10260()));
            return noneRelevantAxisCandidates.method_1019(relevantAxisTarget).method_1020(relevantAxisOffset).method_1031((double)hitPos.method_10263(), (double)hitPos.method_10264(), (double)hitPos.method_10260()).method_1019(class_243.method_24954((class_2382)hitFace.method_10153().method_10163()).method_18806(StateEntrySize.current().getSizePerBitScalingVector()));
        }, position -> IMutatorFactory.getInstance().covering(context.getWorld(), new class_2338(position.method_1023(1.0, 1.0, 1.0)), new class_2338(position.method_1031(1.0, 1.0, 1.0))), direction -> new class_2382(direction.method_10163().method_10263() * this.depth, direction.method_10163().method_10264() * this.depth, direction.method_10163().method_10260() * this.depth));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                context.setError(LocalStrings.ChiselAttemptFailedNoPlaceableBitHeld.getText());
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0) {
                class_2338 heightPos = new class_2338(mutator.getInWorldEndPoint());
                if (heightPos.method_10264() >= context.getWorld().method_31600()) {
                    context.setError(LocalStrings.ChiselAttemptFailedAttemptTooHigh.getText());
                } else if (heightPos.method_10264() <= context.getWorld().method_31607()) {
                    context.setError(LocalStrings.ChiselAttemptFailedAttemptTooLow.getText());
                }
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public boolean isStillValid(class_1657 playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Set<class_2382>> validPositions = context.getMetadata(ModMetadataKeys.VALID_POSITIONS.get());
        Optional<class_2350> targetedSide = context.getMetadata(ModMetadataKeys.TARGETED_SIDE.get());
        Optional<class_2338> targetedBlockPos = context.getMetadata(ModMetadataKeys.TARGETED_BLOCK.get());
        if (validPositions.isEmpty() || targetedSide.isEmpty() || targetedBlockPos.isEmpty()) {
            return false;
        }
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            return false;
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        if (blockRayTraceResult.method_17780() != targetedSide.get()) {
            return false;
        }
        Function<class_2350, class_243> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> class_243.method_24954((class_2382)face.method_10153().method_10163()) : face -> class_243.method_24954((class_2382)face.method_10163());
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_2338 hitPos = new class_2338(hitVector);
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)hitPos);
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        class_2382 selectedPosition = new class_2382(inBlockHitVector.method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return validPositions.get().contains(selectedPosition) && hitPos.equals((Object)targetedBlockPos.get());
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, UnaryOperator<class_2350> searchDirectionAdapter, Function<class_2350, class_243> placementFacingAdapter, IQuadFunction<class_2338, class_243, class_2350, class_243, class_243> stateExtractionAdapter, Function<class_243, IAreaAccessor> areaAccessorBuilder, Function<class_2350, class_2382> filterOffsetProducer) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_2338 hitPos = new class_2338(hitVector);
        class_243 hitBlockPosVector = class_243.method_24954((class_2382)hitPos);
        class_243 inBlockHitVector = hitVector.method_1020(hitBlockPosVector);
        LinkedList<class_2382> toProcess = new LinkedList<class_2382>();
        IAreaAccessor worldAccessor = areaAccessorBuilder.apply(hitVector);
        HashSet<class_2382> processed = new HashSet<class_2382>();
        HashSet<class_2382> validPositions = new HashSet<class_2382>();
        HashSet<class_2382> offsets = new HashSet<class_2382>();
        offsets.add(((class_2350)searchDirectionAdapter.apply(blockRayTraceResult.method_17780())).method_10163());
        Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166() != blockRayTraceResult.method_17780().method_10166()).map(class_2350::method_10163).forEach(offsets::add);
        class_2382 selectedPosition = new class_2382(inBlockHitVector.method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        class_2382 relevantSelectedAxisVector = new class_2382(selectedPosition.method_10263() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10263()), selectedPosition.method_10264() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10264()), selectedPosition.method_10260() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10260()));
        class_243 selectedInBlockPosition = class_243.method_24954((class_2382)selectedPosition).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.method_17780(), selectedInBlockPosition));
        if (targetedInfo.isEmpty()) {
            context.setError(LocalStrings.ChiselAttemptFailedTargetedBlockNotChiselable.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        while (!toProcess.isEmpty()) {
            IStateEntryInfo target;
            class_2382 targetedPosition = (class_2382)toProcess.removeFirst();
            class_243 targetedInBlockPosition = class_243.method_24954((class_2382)targetedPosition).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
            Optional<IStateEntryInfo> targetCandidate = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.method_17780(), targetedInBlockPosition));
            processed.add(targetedPosition);
            if (targetCandidate.isEmpty() || !(target = targetCandidate.get()).getBlockInformation().equals(targetedInfo.get().getBlockInformation())) continue;
            validPositions.add(targetedPosition);
            offsets.forEach(offset -> {
                class_2382 newTarget = new class_2382(targetedPosition.method_10263() + offset.method_10263(), targetedPosition.method_10264() + offset.method_10264(), targetedPosition.method_10260() + offset.method_10260());
                if (newTarget.method_10263() >= 0 && newTarget.method_10263() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.method_10264() >= 0 && newTarget.method_10264() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.method_10260() >= 0 && newTarget.method_10260() < StateEntrySize.current().getBitsPerBlockSide()) {
                    class_2382 relevantNewTargetAxisVector = new class_2382(newTarget.method_10263() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10263()), newTarget.method_10264() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10264()), newTarget.method_10260() * Math.abs(blockRayTraceResult.method_17780().method_10163().method_10260()));
                    int targetedDepth = Math.abs(relevantSelectedAxisVector.method_30558(blockRayTraceResult.method_17780().method_10166()) - relevantNewTargetAxisVector.method_30558(blockRayTraceResult.method_17780().method_10166()));
                    if (targetedDepth <= this.depth - 1 && !processed.contains(newTarget) && !toProcess.contains(newTarget)) {
                        toProcess.addLast(newTarget);
                    }
                } else {
                    processed.add(newTarget);
                }
            });
        }
        context.include(hitPos, class_243.field_1353);
        context.include(hitPos, new class_243(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter((class_2382)filterOffsetProducer.apply(blockRayTraceResult.method_17780()), validPositions));
        context.setMetadata(ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata(ModMetadataKeys.TARGETED_SIDE.get(), blockRayTraceResult.method_17780());
        context.setMetadata(ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.CONNECTED_PLANE);
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final class_2382 offset;
        private final Set<class_2382> validPositions;

        public SelectedBitStateFilter(class_2382 offset, Set<class_2382> validPositions) {
            this.offset = offset;
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            class_2382 position = new class_2382(iStateEntryInfo.getStartPoint().method_10216() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().method_10214() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().method_10215() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public int hashCode() {
            int result = this.offset.hashCode();
            result = 31 * result + this.validPositions.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            if (!this.offset.equals((Object)that.offset)) {
                return false;
            }
            return this.validPositions.equals(that.validPositions);
        }

        public String toString() {
            return "SelectedBitStateFilter{offset=" + this.offset + ", validPositions=" + this.validPositions + "}";
        }
    }
}

