/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.draw;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.VoxelShapeUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DrawnWallChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;
    private final int extensionWidth;

    DrawnWallChiselMode(class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName, int extensionWidth) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
        this.extensionWidth = extensionWidth;
    }

    private static class_2350.class_2351 getExtensionAxis(class_2350 hitDirection) {
        return switch (hitDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11043, class_2350.field_11035 -> class_2350.class_2351.field_11048;
            case class_2350.field_11036, class_2350.field_11039, class_2350.field_11034 -> class_2350.class_2351.field_11051;
        };
    }

    private static class_2382 getOffsetPosition(class_2382 source, int offset, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new class_2382(source.method_10263() + offset, source.method_10264(), source.method_10260());
            case class_2350.class_2351.field_11052 -> new class_2382(source.method_10263(), source.method_10264() + offset, source.method_10260());
            case class_2350.class_2351.field_11051 -> new class_2382(source.method_10263(), source.method_10264(), source.method_10260() + offset);
        };
    }

    @Override
    public boolean isSingleClickUse() {
        return false;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> class_243.method_24954((class_2382)direction.method_10153().method_10163()).method_18806(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
        this.onLeftClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
        });
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> class_243.method_24954((class_2382)direction.method_10163()).method_18806(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
        this.onRightClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            class_2338 heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = new class_2338(mutator.getInWorldEndPoint())).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = class_2561.method_43469((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_43496((class_2561)component);
            }
        });
    }

    private ClickProcessingState processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> offsetGenerator) {
        Optional<class_2350.class_2351> targetedAxis;
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return ClickProcessingState.DEFAULT;
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 currentTarget = blockRayTraceResult.method_17784().method_1019(offsetGenerator.apply(blockRayTraceResult.method_17780()));
        Optional<class_243> anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (anchor.isEmpty()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), currentTarget);
            anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        }
        if ((targetedAxis = context.getMetadata(ModMetadataKeys.TARGETED_AXIS.get())).isEmpty()) {
            targetedAxis = Optional.of(DrawnWallChiselMode.getExtensionAxis(blockRayTraceResult.method_17780()));
            context.setMetadata(ModMetadataKeys.TARGETED_AXIS.get(), targetedAxis.get());
        }
        context.resetMutator();
        context.include(anchor.orElseThrow());
        context.include(currentTarget);
        Optional<class_243> finalAnchor = anchor;
        Optional<class_2350.class_2351> finalTargetedAxis = targetedAxis;
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                IWorldAreaAccessor worldAreaAccessor = (IWorldAreaAccessor)areaAccessor;
                return new WallAreaFilter((class_243)finalAnchor.get(), currentTarget, (class_2350.class_2351)finalTargetedAxis.get(), this.extensionWidth);
            }
            return s -> false;
        });
        return ClickProcessingState.ALLOW;
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(IAreaAccessor.class::cast);
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        IWorldAreaMutator mutator = context.getMutator().get();
        Optional<Predicate> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator));
        if (filter.isEmpty()) {
            return class_259.method_1073();
        }
        Predicate stateFilter = filter.get();
        if (!(stateFilter instanceof WallAreaFilter)) {
            return class_259.method_1073();
        }
        WallAreaFilter lineAreaFilter = (WallAreaFilter)stateFilter;
        class_2338 offset = VectorUtils.invert(new class_2338(mutator.getInWorldStartPoint()));
        List<class_2382> startPoints = lineAreaFilter.anchors;
        return VoxelShapeUtils.batchCombine(class_259.method_1073(), class_247.field_1366, true, startPoints.stream().map(p -> {
            class_2382 startPointScalar = DrawnWallChiselMode.getOffsetPosition(p, -lineAreaFilter.extensionWidth, lineAreaFilter.axis);
            class_2382 endPointScalar = DrawnWallChiselMode.getOffsetPosition(p, lineAreaFilter.extensionWidth, lineAreaFilter.axis);
            class_243 startPoint = new class_243((double)startPointScalar.method_10263(), (double)startPointScalar.method_10264(), (double)startPointScalar.method_10260()).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
            class_243 endPoint = new class_243((double)endPointScalar.method_10263(), (double)endPointScalar.method_10264(), (double)endPointScalar.method_10260()).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
            class_243 finalEndpoint = new class_243(endPoint.method_10216(), endPoint.method_10214() + lineAreaFilter.height * (double)StateEntrySize.current().getSizePerBit(), endPoint.method_10215());
            class_243 end = finalEndpoint.method_1019(StateEntrySize.current().getSizePerBitScalingVector());
            class_243 min = new class_243(Math.min(startPoint.method_10216(), end.method_10216()), Math.min(startPoint.method_10214(), end.method_10214()), Math.min(startPoint.method_10215(), end.method_10215()));
            class_243 max = new class_243(Math.max(startPoint.method_10216(), end.method_10216()), Math.max(startPoint.method_10214(), end.method_10214()), Math.max(startPoint.method_10215(), end.method_10215()));
            return class_259.method_1081((double)min.method_10216(), (double)min.method_10214(), (double)min.method_10215(), (double)max.method_10216(), (double)max.method_10214(), (double)max.method_10215());
        }).collect(Collectors.toList())).method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.DRAW);
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class WallAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final class_2382 origin;
        private final class_243 magnitude;
        private final double height;
        private final List<class_2382> included;
        private final List<class_2382> anchors;
        private final class_2350.class_2351 axis;
        private final int extensionWidth;

        private WallAreaFilter(class_243 startPoint, class_243 endPoint, class_2350.class_2351 axis, int extensionWidth) {
            class_243 origin = startPoint.method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            this.origin = new class_2382(origin.method_10216(), origin.method_10214(), origin.method_10215());
            class_243 magnitude = endPoint.method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector()).method_1020(origin);
            class_2382 normalizedMagnitude = new class_2382(magnitude.method_10216(), magnitude.method_10214(), magnitude.method_10215());
            this.height = normalizedMagnitude.method_10264();
            this.magnitude = new class_243((double)normalizedMagnitude.method_10263(), 0.0, (double)normalizedMagnitude.method_10260());
            this.axis = axis;
            this.extensionWidth = extensionWidth;
            this.anchors = this.calculateAnchorPositions();
            this.included = this.calculateIncludedPositions();
        }

        private List<class_2382> calculateIncludedPositions() {
            return this.anchors.stream().flatMap(i -> {
                Stream.Builder<class_2382> builder = Stream.builder();
                for (int j = -this.extensionWidth; j <= this.extensionWidth; ++j) {
                    builder.add(DrawnWallChiselMode.getOffsetPosition(i, j, this.axis));
                }
                return builder.build();
            }).collect(Collectors.toList());
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            class_243 pos = inWorldStateEntryInfo.getInWorldStartPoint().method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            class_2382 candidatePos = new class_2382(pos.method_10216(), (double)this.origin.method_10264(), pos.method_10215());
            boolean included = this.included.contains(candidatePos);
            if (this.height < 0.0) {
                return included && candidatePos.method_10264() <= this.origin.method_10264() && (double)candidatePos.method_10264() > (double)this.origin.method_10264() + this.height;
            }
            return included && candidatePos.method_10264() >= this.origin.method_10264() && (double)candidatePos.method_10264() < (double)this.origin.method_10264() + this.height;
        }

        private List<class_2382> calculateAnchorPositions() {
            double zDist;
            ArrayList<class_2382> positions = new ArrayList<class_2382>();
            class_243 direction = this.magnitude.method_1029();
            double xLen = direction.method_1021(1.0 / direction.method_10216()).method_1033();
            double yLen = direction.method_1021(1.0 / direction.method_10214()).method_1033();
            double zLen = direction.method_1021(1.0 / direction.method_10215()).method_1033();
            double reach = this.magnitude.method_1033();
            double distanceFromStart = 0.0;
            class_2382 pos = new class_2382((int)(direction.method_10216() > 0.0 ? Math.ceil(this.origin.method_10263()) - 1.0 : Math.floor(this.origin.method_10263())), (int)(direction.method_10214() > 0.0 ? Math.ceil(this.origin.method_10264()) - 1.0 : Math.floor(this.origin.method_10264())), (int)(direction.method_10215() > 0.0 ? Math.ceil(this.origin.method_10260()) - 1.0 : Math.floor(this.origin.method_10260())));
            double xOff = direction.method_10216() > 0.0 ? (double)(1 + pos.method_10263() - this.origin.method_10263()) : (double)(this.origin.method_10263() - pos.method_10263());
            double yOff = direction.method_10214() > 0.0 ? (double)(1 + pos.method_10264() - this.origin.method_10264()) : (double)(this.origin.method_10264() - pos.method_10264());
            double zOff = direction.method_10215() > 0.0 ? (double)(1 + pos.method_10260() - this.origin.method_10260()) : (double)(this.origin.method_10260() - pos.method_10260());
            double xDist = Double.isNaN(xLen) ? Double.POSITIVE_INFINITY : Math.abs(xOff * xLen);
            double yDist = Double.isNaN(yLen) ? Double.POSITIVE_INFINITY : Math.abs(yOff * yLen);
            double d = zDist = Double.isNaN(zLen) ? Double.POSITIVE_INFINITY : Math.abs(zOff * zLen);
            while (distanceFromStart <= reach) {
                positions.add(pos);
                if (xDist < yDist) {
                    if (xDist < zDist) {
                        distanceFromStart = xDist;
                        xDist += xLen;
                        pos = pos.method_34592(direction.method_10216() > 0.0 ? 1 : -1, 0, 0);
                        continue;
                    }
                    distanceFromStart = zDist;
                    zDist += zLen;
                    pos = pos.method_34592(0, 0, direction.method_10215() > 0.0 ? 1 : -1);
                    continue;
                }
                if (yDist < zDist) {
                    distanceFromStart = yDist;
                    yDist += yLen;
                    pos = pos.method_34592(0, direction.method_10214() > 0.0 ? 1 : -1, 0);
                    continue;
                }
                distanceFromStart = zDist;
                zDist += zLen;
                pos = pos.method_34592(0, 0, direction.method_10215() > 0.0 ? 1 : -1);
            }
            return positions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WallAreaFilter)) {
                return false;
            }
            WallAreaFilter that = (WallAreaFilter)o;
            if (!this.origin.equals((Object)that.origin)) {
                return false;
            }
            if (!this.magnitude.equals((Object)that.magnitude)) {
                return false;
            }
            return this.included.equals(that.included);
        }

        public int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + this.magnitude.hashCode();
            result = 31 * result + this.included.hashCode();
            return result;
        }
    }
}

