/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import mod.chiselsandbits.api.client.render.preview.placement.PlacementPreviewRenderMode;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.client.render.ModRenderTypes;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.lwjgl.system.MemoryStack;

public class ChiseledBlockGhostRenderer {
    private static final ChiseledBlockGhostRenderer INSTANCE = new ChiseledBlockGhostRenderer();
    private static final BufferBuilderTransparent BUFFER = new BufferBuilderTransparent();
    private static final float[] DIRECTIONAL_BRIGHTNESS = new float[]{0.5f, 1.0f, 0.7f, 0.7f, 0.6f, 0.6f};

    public static ChiseledBlockGhostRenderer getInstance() {
        return INSTANCE;
    }

    private ChiseledBlockGhostRenderer() {
    }

    public void renderGhost(class_4587 poseStack, class_1799 renderStack, class_243 targetedRenderPos, PlacementResult placementResult, PlacementPreviewRenderMode success, PlacementPreviewRenderMode failure, boolean ignoreDepth) {
        poseStack.method_22903();
        class_243 camera = class_310.method_1551().field_1773.method_19418().method_19326();
        poseStack.method_22904(targetedRenderPos.field_1352 - camera.field_1352 - 1.25E-4, targetedRenderPos.field_1351 - camera.field_1351 + 1.25E-4, targetedRenderPos.field_1350 - camera.field_1350 - 1.25E-4);
        poseStack.method_22905(1.001f, 1.001f, 1.001f);
        class_1162 color = placementResult.getColor();
        boolean renderColoredGhost = placementResult.isSuccess() && success.isColoredGhost() || !placementResult.isSuccess() && failure.isColoredGhost();
        BUFFER.setAlphaPercentage(color.method_23853());
        class_1087 model = class_310.method_1551().method_1480().method_4019(renderStack, null, null, 0);
        if (!renderColoredGhost || !ignoreDepth) {
            this.renderGhost(poseStack, renderStack, model, renderColoredGhost, color, false);
        }
        if (ignoreDepth) {
            this.renderGhost(poseStack, renderStack, model, renderColoredGhost, color, true);
        }
        poseStack.method_22909();
    }

    private void renderGhost(class_4587 poseStack, class_1799 renderStack, class_1087 model, boolean renderColoredGhost, class_1162 color, boolean ignoreDepth) {
        class_1921 renderType = renderColoredGhost ? (ignoreDepth ? ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW_ALWAYS.get() : ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW.get()) : (ignoreDepth ? ModRenderTypes.GHOST_BLOCK_PREVIEW_GREATER.get() : ModRenderTypes.GHOST_BLOCK_PREVIEW.get());
        BUFFER.method_1328(renderType.method_23033(), renderType.method_23031());
        if (renderColoredGhost) {
            ChiseledBlockGhostRenderer.renderModelLists(model, poseStack, (class_4588)BUFFER, color);
        } else {
            class_310.method_1551().method_1480().method_23182(model, renderStack, 0xF000F0, class_4608.field_21444, poseStack, (class_4588)BUFFER);
        }
        renderType.method_23012((class_287)BUFFER, 0, 0, 0);
    }

    private static class_1160[] getShadedColors(class_1162 color) {
        return (class_1160[])Arrays.stream(class_2350.values()).map(direction -> {
            float brightness = DIRECTIONAL_BRIGHTNESS[direction.method_10146()];
            return new class_1160(color.method_4953() * brightness, color.method_4956() * brightness, color.method_4957() * brightness);
        }).toArray(class_1160[]::new);
    }

    private static class_1160[] getNormals(class_4587.class_4665 pose) {
        return (class_1160[])Arrays.stream(class_2350.values()).map(direction -> {
            class_2382 faceNormal = direction.method_10163();
            class_1160 normal = new class_1160((float)faceNormal.method_10263(), (float)faceNormal.method_10264(), (float)faceNormal.method_10260());
            normal.method_23215(pose.method_23762());
            return normal;
        }).toArray(class_1160[]::new);
    }

    private static void renderModelLists(class_1087 model, class_4587 poseStack, class_4588 buffer, class_1162 color) {
        class_5819 random = class_5819.method_43049((long)42L);
        class_1160[] normals = ChiseledBlockGhostRenderer.getNormals(poseStack.method_23760());
        class_1160[] shadedColors = ChiseledBlockGhostRenderer.getShadedColors(color);
        class_1162 pos = new class_1162();
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(42L);
            ChiseledBlockGhostRenderer.renderQuadList(poseStack.method_23760().method_23761(), buffer, model.method_4707(null, direction, random), normals, shadedColors, pos);
        }
        random.method_43052(42L);
        ChiseledBlockGhostRenderer.renderQuadList(poseStack.method_23760().method_23761(), buffer, model.method_4707(null, null, random), normals, shadedColors, pos);
    }

    private static void renderQuadList(class_1159 pose, class_4588 buffer, List<class_777> quads, class_1160[] normals, class_1160[] shadedColors, class_1162 pos) {
        for (class_777 quad : quads) {
            ChiseledBlockGhostRenderer.putBulkData(buffer, pose, quad, shadedColors[quad.method_3358().ordinal()], normals[quad.method_3358().ordinal()], pos);
        }
    }

    private static void putBulkData(class_4588 buffer, class_1159 pose, class_777 bakedQuad, class_1160 color, class_1160 normal, class_1162 pos) {
        int[] vertices = bakedQuad.method_3357();
        int vertexCount = vertices.length / class_290.field_1590.method_1359();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(class_290.field_1590.method_1362());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertices, v * 8, 8);
                pos.method_23851(bytebuffer.getFloat(0), bytebuffer.getFloat(4), bytebuffer.getFloat(8), 1.0f);
                pos.method_22674(pose);
                buffer.method_22912((double)pos.method_4953(), (double)pos.method_4956(), (double)pos.method_4957()).method_22915(color.method_4943(), color.method_4945(), color.method_4947(), 1.0f).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_1344();
            }
        }
    }

    private static class BufferBuilderTransparent
    extends class_287 {
        private float alphaPercentage;

        public BufferBuilderTransparent() {
            super(0x200000);
        }

        public void setAlphaPercentage(float alphaPercentage) {
            this.alphaPercentage = class_3532.method_15363((float)alphaPercentage, (float)0.0f, (float)1.0f);
        }

        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            return super.method_1336(red, green, blue, (int)((float)alpha * this.alphaPercentage));
        }

        public void method_23919(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            super.method_23919(x, y, z, red, green, blue, alpha * this.alphaPercentage, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }
}

