/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.materials;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.class_3614;

public class MaterialManager {
    private static final MaterialManager INSTANCE = new MaterialManager();
    private final Map<class_3614, String> materialNames = Maps.newHashMap();
    private final Multimap<String, class_3614> knownMaterials = HashMultimap.create();
    private final Map<class_3614, class_3614> materialRemapping = Maps.newHashMap();

    private MaterialManager() {
        this.registerMapping("wood", class_3614.field_15932);
        this.registerMapping("rock", class_3614.field_15914);
        this.registerMapping("iron", class_3614.field_15953);
        this.registerMapping("cloth", class_3614.field_15957);
        this.registerMapping("ice", class_3614.field_15958);
        this.registerMapping("packed_ice", class_3614.field_15928);
        this.registerMapping("clay", class_3614.field_15936);
        this.registerMapping("glass", class_3614.field_15942);
        this.registerMapping("sand", class_3614.field_15916);
        this.registerMapping("ground", class_3614.field_15941);
        this.registerMapping("grass", class_3614.field_15945);
        this.registerMapping("snow", class_3614.field_15934);
        this.registerMapping("fluid", class_3614.field_15920);
        this.registerMapping("leaves", class_3614.field_15923);
        this.registerMapping("plant", class_3614.field_15935);
        this.registerMapping("wool", class_3614.field_15931);
        this.registerMapping("nether_wood", class_3614.field_22223);
        this.registerMapping("froglight", class_3614.field_38977);
        this.registerMapping("amethyst", class_3614.field_27340);
        this.registerRemapping(class_3614.field_15917, class_3614.field_15936);
        this.registerRemapping(class_3614.field_15949, class_3614.field_15953);
        this.registerRemapping(class_3614.field_15954, class_3614.field_15935);
        this.registerRemapping(class_3614.field_15925, class_3614.field_15935);
        this.registerRemapping(class_3614.field_15913, class_3614.field_15935);
        this.registerRemapping(class_3614.field_15955, class_3614.field_15914);
        this.registerRemapping(class_3614.field_15922, class_3614.field_15920);
        this.registerRemapping(class_3614.field_15921, class_3614.field_15935);
    }

    public void registerMapping(String name, class_3614 material) {
        if (this.knownMaterials.containsKey((Object)name)) {
            throw new IllegalArgumentException(String.format("The material name: %s is already registered!", name));
        }
        this.knownMaterials.put((Object)name, (Object)material);
        this.materialNames.put(material, name);
    }

    public void registerRemapping(class_3614 material, class_3614 target) {
        if (this.materialRemapping.containsKey(material)) {
            throw new IllegalArgumentException("Can not remap a material twice!");
        }
        if (this.knownMaterials.containsValue((Object)material)) {
            throw new IllegalArgumentException("Can not remap a material which is registered as a working material.");
        }
        if (!this.knownMaterials.containsValue((Object)target)) {
            throw new IllegalArgumentException("Can not remap a material to a material which is not registered as a working material.");
        }
        this.materialRemapping.put(material, target);
    }

    public static MaterialManager getInstance() {
        return INSTANCE;
    }

    public Multimap<String, class_3614> getKnownMaterials() {
        return this.knownMaterials;
    }

    public Map<class_3614, String> getMaterialNames() {
        return this.materialNames;
    }

    public class_3614 remapMaterialIfNeeded(class_3614 material) {
        return this.materialRemapping.getOrDefault(material, material);
    }

    public class_3614 getDefaultMaterial() {
        return class_3614.field_15914;
    }
}

