/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.handlers;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.entity.INetworkUpdateableEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.client.screen.AbstractChiselsAndBitsScreen;
import mod.chiselsandbits.api.client.sharing.IPatternSharingManager;
import mod.chiselsandbits.api.client.sharing.PatternIOException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.screens.widgets.ChangeTrackerOperationsWidget;
import mod.chiselsandbits.clipboard.CreativeClipboardUtils;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.network.packets.GivePlayerPatternCommandPacket;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public final class ClientPacketHandlers {
    private ClientPacketHandlers() {
        throw new IllegalStateException("Can not instantiate an instance of: ClientPacketHandlers. This is a utility class");
    }

    public static void handleTileEntityUpdatedPacket(class_2338 blockPos, class_2487 updateTag) {
        block25: {
            if (class_310.method_1551().field_1687 != null) {
                class_2586 tileEntity = class_310.method_1551().field_1687.method_8321(blockPos);
                if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                    Optional<class_2248> convertedState;
                    class_2680 currentState;
                    class_2680 initializationState = currentState = class_310.method_1551().field_1687.method_8320(blockPos);
                    if (currentState.method_26215()) {
                        currentState = class_2246.field_10340.method_9564();
                    }
                    if ((convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isEmpty()) {
                        return;
                    }
                    class_310.method_1551().field_1687.method_8652(blockPos, convertedState.get().method_9564(), 4);
                    tileEntity = class_310.method_1551().field_1687.method_8321(blockPos);
                    if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                        return;
                    }
                }
                if (tileEntity != null && tileEntity.method_10997() != null) {
                    try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Handling tile entity update packet");
                         IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Updating tile entity");){
                        if (tileEntity instanceof INetworkUpdateableEntity) {
                            INetworkUpdateableEntity networkUpdateableEntity = (INetworkUpdateableEntity)tileEntity;
                            networkUpdateableEntity.handleUpdateTag(updateTag);
                            break block25;
                        }
                        tileEntity.method_11014(updateTag);
                        try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Scheduling refresh");){
                            tileEntity.method_10997().method_8413(tileEntity.method_11016(), class_2246.field_10124.method_9564(), tileEntity.method_11010(), 3);
                        }
                    }
                }
            }
        }
    }

    public static void handleChangeTrackerUpdated(class_2487 tag) {
        IChangeTrackerManager.getInstance().getChangeTracker((class_1657)class_310.method_1551().field_1724).deserializeNBT(tag);
        if (class_310.method_1551().field_1755 instanceof AbstractChiselsAndBitsScreen) {
            ((AbstractChiselsAndBitsScreen)class_310.method_1551().field_1755).getWidgets().stream().filter(ChangeTrackerOperationsWidget.class::isInstance).map(ChangeTrackerOperationsWidget.class::cast).forEach(ChangeTrackerOperationsWidget::updateState);
        }
    }

    public static void handleNeighborUpdated(class_2338 toUpdate, class_2338 from) {
        class_310.method_1551().field_1687.method_8320(toUpdate).method_26181((class_1937)class_310.method_1551().field_1687, toUpdate, class_310.method_1551().field_1687.method_8320(from).method_26204(), from, false);
    }

    public static void handleAddMultiStateToClipboard(class_1799 stack) {
        SingleBlockMultiStateItemStack itemStack = new SingleBlockMultiStateItemStack(stack);
        CreativeClipboardUtils.addBrokenBlock(itemStack);
    }

    public static void handleExportPatternCommandMessage(class_2338 target, String name) {
        class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(target);
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to export pattern: " + name + " - Not a multistate block.")));
            return;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        IMultiStateItemStack multiStateItemStack = multiStateBlockEntity.createSnapshot().toItemStack();
        IPatternSharingManager.getInstance().exportPattern(multiStateItemStack, name);
    }

    public static void handleImportPatternCommandMessage(String name) {
        Either<IMultiStateItemStack, PatternIOException> importResult = IPatternSharingManager.getInstance().importPattern(name);
        importResult.ifLeft(stack -> ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new GivePlayerPatternCommandPacket(stack.toPatternStack())));
        importResult.ifRight(e -> class_310.method_1551().field_1724.method_43496(e.getErrorMessage()));
    }
}

