/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.core;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerSafetyLevel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_639;
import net.minecraft.class_642;

@Environment(value=EnvType.CLIENT)
public final class ServerSafetyState {
    private static ServerSafetyLevel current = ServerSafetyLevel.UNDEFINED;
    private static class_639 lastServerAddress = null;
    private static class_642 lastServerData = null;
    private static AtomicBoolean allowUnsafeServer = new AtomicBoolean(false);
    private static AtomicBoolean sessionRequestedKey = new AtomicBoolean(false);
    private static AtomicBoolean isOnServer = new AtomicBoolean(false);
    private static AtomicInteger reconnectCount = new AtomicInteger(0);
    private static AtomicLong disconnectMillis = new AtomicLong(0L);

    public static void updateCurrent(ServerSafetyLevel level) {
        current = level;
    }

    public static ServerSafetyLevel getCurrent() {
        return current;
    }

    public static boolean allowsUnsafeServer() {
        return current != ServerSafetyLevel.SECURE ? allowUnsafeServer.get() : false;
    }

    public static void setAllowsUnsafeServer(boolean allows) {
        if (NCRConfig.getCommon().enableDebugLog()) {
            NoChatReports.LOGGER.info("Set allowUnsafeServer to: " + allows + ", value set in stacktrace:");
            NoChatReports.LOGGER.catching(new RuntimeException().fillInStackTrace());
        }
        allowUnsafeServer.set(allows);
    }

    public static void setSessionRequestedKey(boolean requested) {
        sessionRequestedKey.set(requested);
    }

    public static boolean sessionRequestedKey() {
        return current != ServerSafetyLevel.SECURE ? sessionRequestedKey.get() : false;
    }

    public static boolean forceSignedMessages() {
        return ServerSafetyState.allowsUnsafeServer() && ServerSafetyState.sessionRequestedKey();
    }

    @Nullable
    public static class_639 getLastServerAddress() {
        return lastServerAddress;
    }

    @Nullable
    public static class_642 getLastServerData() {
        return lastServerData;
    }

    public static void setLastConnectedServer(@Nullable class_639 address, @Nullable class_642 data) {
        lastServerAddress = address;
        lastServerData = data;
    }

    public static int getReconnectCount() {
        return reconnectCount.get();
    }

    public static void setReconnectCount(int count) {
        reconnectCount.set(count);
    }

    public static long getDisconnectMillis() {
        return disconnectMillis.get();
    }

    public static void setDisconnectMillis(long millis) {
        disconnectMillis.set(millis);
    }

    public static boolean isOnServer() {
        return isOnServer.get();
    }

    public static void setOnServer(boolean on) {
        isOnServer.set(on);
    }

    public static void reset() {
        current = ServerSafetyLevel.UNDEFINED;
        allowUnsafeServer.set(false);
        sessionRequestedKey.set(false);
        isOnServer.set(false);
        if (NCRConfig.getCommon().enableDebugLog()) {
            NoChatReports.LOGGER.info("allowUnsafeServer: {}", (Object)allowUnsafeServer.get());
        }
    }
}

