/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.google.common.reflect.Reflection;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.VersionUtils;

public class BackwardsCompatibility {
    private static boolean APPLIED = false;
    private static final List<String> TYPES = Arrays.asList("INVALID", "BASE", "WIDTH", "HEIGHT", "EYE_HEIGHT", "HITBOX_WIDTH", "HITBOX_HEIGHT", "MODEL_WIDTH", "MODEL_HEIGHT", "THIRD_PERSON", "MOTION", "FALLING", "STEP_HEIGHT", "VIEW_BOBBING", "FLIGHT", "REACH", "BLOCK_REACH", "ENTITY_REACH", "KNOCKBACK", "ATTACK", "DEFENSE", "HEALTH", "DROPS", "HELD_ITEM", "PROJECTILES", "EXPLOSIONS");

    public static void addFieldsIfNeeded(ClassNode targetClass) {
        if (VersionUtils.MINOR < 18 || VersionUtils.MINOR == 18 && VersionUtils.PATCH == 0) {
            for (String type : TYPES) {
                targetClass.visitField(9, type, "L" + targetClass.name + ";", null, null);
            }
            APPLIED = true;
            Pehkui.LOGGER.debug("[Pehkui] Applied backwards compatibility patch.", new Object[0]);
        }
    }

    public static void populateFieldsIfNeeded() {
        if (APPLIED) {
            Reflection.initialize((Class[])new Class[]{ScaleTypes.class});
            for (String type : TYPES) {
                try {
                    ScaleType.class.getField(type).set(null, ScaleTypes.class.getField(type).get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    Pehkui.LOGGER.catching((Throwable)e);
                    Pehkui.LOGGER.warn("[Pehkui] Backwards compatibility patch failed. Older mods you have that use Pehkui might not work.", new Object[0]);
                    break;
                }
            }
            Pehkui.LOGGER.debug("[Pehkui] Populated backwards compatibility fields.", new Object[0]);
        }
    }
}

