/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.mixin;

import java.util.concurrent.atomic.AtomicLongArray;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3233;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.WorldGenState;

@Mixin(value={class_2794.class})
public class MixinChunkGenerator {
    @Inject(at={@At(value="RETURN")}, method={"generateFeatures"})
    private void generateFeatures(class_3233 region, class_5138 structureAccessor, CallbackInfo ci) {
        long startTime = System.nanoTime();
        int centerChunkX = region.method_14336();
        int centerChunkZ = region.method_14339();
        int centerBlockX = centerChunkX * 16;
        int centerBlockZ = centerChunkZ * 16;
        RERUtils.LOGGER.debug("generateFeatures for block %d,%d", centerBlockX, centerBlockZ);
        WorldGenState state = WorldGenState.byWorld((class_5321<class_1937>)region.method_8410().method_27983());
        for (int y = 0; y < 128; ++y) {
            for (int x = centerBlockX - 8; x < centerBlockX + 8; ++x) {
                for (int z = centerBlockZ - 8; z < centerBlockZ + 8; ++z) {
                    class_2248 block = region.method_8320(new class_2338(x, y, z)).method_26204();
                    state.totalCountsAtLevelsMap.set(y, state.totalCountsAtLevelsMap.get(y) + 1L);
                    AtomicLongArray levelCount = state.levelCountsMap.get(block);
                    if (levelCount == null) {
                        levelCount = new AtomicLongArray(128);
                        state.levelCountsMap.put(block, levelCount);
                    }
                    levelCount.set(y, levelCount.get(y) + 1L);
                    state.markPlayerDirty(block);
                }
            }
        }
        state.method_80();
        long endTime = System.nanoTime();
        RERUtils.LOGGER.debug("RER profiling that chunk took %f ms", (double)(endTime - startTime) / 1.0E9);
    }
}

