/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.chunk;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2361;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2835;
import net.minecraft.class_2837;

public class LithiumHashPalette<T>
implements class_2837<T> {
    private static final int ABSENT_VALUE = -1;
    private final class_2361<T> idList;
    private final class_2835<T> resizeHandler;
    private final Function<class_2487, T> elementDeserializer;
    private final Function<T, class_2487> elementSerializer;
    private final int indexBits;
    private final Reference2IntMap<T> table;
    private T[] entries;
    private int size = 0;

    public LithiumHashPalette(class_2361<T> ids, int bits, class_2835<T> resizeHandler, Function<class_2487, T> deserializer, Function<T, class_2487> serializer) {
        this.idList = ids;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        this.elementDeserializer = deserializer;
        this.elementSerializer = serializer;
        int capacity = 1 << bits;
        this.entries = new Object[capacity];
        this.table = new Reference2IntOpenHashMap(capacity, 0.5f);
        this.table.defaultReturnValue(-1);
    }

    public int method_12291(T obj) {
        int id = this.table.getInt(obj);
        if (id == -1) {
            id = this.computeEntry(obj);
        }
        return id;
    }

    private int computeEntry(T obj) {
        int id = this.addEntry(obj);
        if (id >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onResize(this.indexBits + 1, obj);
        }
        return id;
    }

    private int addEntry(T obj) {
        int nextId = this.size;
        if (nextId >= this.entries.length) {
            this.resize(this.size);
        }
        this.table.put(obj, nextId);
        this.entries[nextId] = obj;
        ++this.size;
        return nextId;
    }

    private void resize(int neededCapacity) {
        this.entries = Arrays.copyOf(this.entries, HashCommon.nextPowerOfTwo((int)(neededCapacity + 1)));
    }

    public boolean method_19525(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.entries[i])) continue;
            return true;
        }
        return false;
    }

    public T method_12288(int id) {
        T[] entries = this.entries;
        if (id >= 0 && id < entries.length) {
            return entries[id];
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_12289(class_2540 buf) {
        this.clear();
        int entryCount = buf.method_10816();
        for (int i = 0; i < entryCount; ++i) {
            this.addEntry(this.idList.method_10200(buf.method_10816()));
        }
    }

    public void method_12287(class_2540 buf) {
        int size = this.size;
        buf.method_10804(size);
        for (int i = 0; i < size; ++i) {
            buf.method_10804(this.idList.method_10206(this.method_12288(i)));
        }
    }

    public int method_12290() {
        int size = class_2540.method_10815((int)this.size);
        for (int i = 0; i < this.size; ++i) {
            size += class_2540.method_10815((int)this.idList.method_10206(this.method_12288(i)));
        }
        return size;
    }

    public void method_12286(class_2499 list) {
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.addEntry(this.elementDeserializer.apply(list.method_10602(i)));
        }
    }

    public void toTag(class_2499 list) {
        for (int i = 0; i < this.size; ++i) {
            list.add((Object)this.elementSerializer.apply(this.method_12288(i)));
        }
    }

    public int getSize() {
        return this.size;
    }

    private void clear() {
        Arrays.fill(this.entries, null);
        this.table.clear();
        this.size = 0;
    }
}

