/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi.fast_retrieval;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.util.Collector;
import me.jellysquid.mods.lithium.common.world.interests.PointOfInterestCollectors;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionAccess;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_4180;
import net.minecraft.class_4284;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={class_4153.class})
public abstract class PointOfInterestStorageMixin
extends class_4180<class_4157> {
    public PointOfInterestStorageMixin(File directory, Function<Runnable, Codec<class_4157>> function, Function<Runnable, class_4157> function2, DataFixer dataFixer, class_4284 dataFixTypes, boolean bl) {
        super(directory, function, function2, dataFixer, dataFixTypes, bl);
    }

    @Overwrite
    public Stream<class_4156> method_19123(Predicate<class_4158> predicate, class_1923 pos, class_4153.class_4155 status) {
        return ((RegionBasedStorageSectionAccess)((Object)this)).getWithinChunkColumn(pos.field_9181, pos.field_9180).flatMap(set -> set.method_19150(predicate, status));
    }

    @Overwrite
    public Optional<class_2338> method_20005(Predicate<class_4158> typePredicate, Predicate<class_2338> posPredicate, class_4153.class_4155 status, class_2338 pos, int radius, Random rand) {
        List<class_4156> list = this.getAllWithinCircle(typePredicate, pos, radius, status);
        Collections.shuffle(list, rand);
        for (class_4156 point : list) {
            if (!posPredicate.test(point.method_19141())) continue;
            return Optional.of(point.method_19141());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<class_2338> method_20006(Predicate<class_4158> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        List<class_4156> points = this.getAllWithinCircle(predicate, pos, radius, status);
        class_2338 nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (class_4156 point : points) {
            double distance = point.method_19141().method_10262((class_2382)pos);
            if (!(distance < nearestDistance)) continue;
            nearest = point.method_19141();
            nearestDistance = distance;
        }
        return Optional.ofNullable(nearest);
    }

    @Overwrite
    public long method_20252(Predicate<class_4158> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        return this.getAllWithinCircle(predicate, pos, radius, status).size();
    }

    private List<class_4156> getAllWithinCircle(Predicate<class_4158> predicate, class_2338 pos, int radius, class_4153.class_4155 status) {
        ArrayList<class_4156> points = new ArrayList<class_4156>();
        this.collectWithinCircle(predicate, pos, radius, status, points::add);
        return points;
    }

    private void collectWithinCircle(Predicate<class_4158> predicate, class_2338 pos, int radius, class_4153.class_4155 status, Collector<class_4156> collector) {
        Collector<class_4156> filter = PointOfInterestCollectors.collectAllWithinRadius(pos, radius, collector);
        Collector<class_4157> consumer = PointOfInterestCollectors.collectAllMatching(predicate, status, filter);
        int minChunkX = pos.method_10263() - radius - 1 >> 4;
        int minChunkZ = pos.method_10260() - radius - 1 >> 4;
        int maxChunkX = pos.method_10263() + radius + 1 >> 4;
        int maxChunkZ = pos.method_10260() + radius + 1 >> 4;
        RegionBasedStorageSectionAccess storage = (RegionBasedStorageSectionAccess)((Object)this);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                if (storage.collectWithinChunkColumn(x, z, consumer)) continue;
                return;
            }
        }
    }
}

