/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookFolderLoader;

public class ExternalBookContents
extends BookContents {
    public ExternalBookContents(Book book) {
        super(book);
    }

    @Override
    protected void findFiles(String dir, List<class_2960> list) {
        File searchDir;
        File root = new File(BookFolderLoader.loadDir, this.book.id.method_12832());
        File enUs = new File(root, "en_us");
        if (enUs.exists() && (searchDir = new File(enUs, dir)).exists()) {
            this.crawl(searchDir, searchDir, list);
        }
    }

    private void crawl(File realRoot, File root, List<class_2960> list) {
        File[] files;
        for (File f : files = root.listFiles()) {
            if (f.isDirectory()) {
                this.crawl(realRoot, f, list);
                continue;
            }
            if (!f.getName().endsWith(".json")) continue;
            list.add(this.relativize(realRoot, f));
        }
    }

    private class_2960 relativize(File root, File f) {
        String rootPath = root.getAbsolutePath();
        String filePath = f.getAbsolutePath().substring(rootPath.length() + 1);
        String cleanPath = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)filePath));
        return new class_2960("patchouli", cleanPath);
    }

    @Override
    protected InputStream loadJson(class_2960 resloc, class_2960 fallback) {
        String realPath = resloc.method_12832().substring(BookFolderLoader.loadDir.getName().length());
        File targetFile = new File(BookFolderLoader.loadDir, realPath);
        if (targetFile.exists()) {
            try {
                FileInputStream stream = new FileInputStream(targetFile);
                return stream;
            }
            catch (IOException e) {
                Patchouli.LOGGER.catching((Throwable)e);
            }
        }
        if (fallback != null) {
            Patchouli.LOGGER.warn("Failed to load " + resloc + ". Switching to fallback.");
            return this.loadJson(fallback, null);
        }
        return null;
    }
}

