/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_5251;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.SpanState;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class BookTextParser {
    public static final class_2585 EMPTY_STRING_COMPONENT = new class_2585("");
    private static final List<CommandLookup> COMMAND_LOOKUPS = new ArrayList<CommandLookup>();
    private static final Map<String, CommandProcessor> COMMANDS = new ConcurrentHashMap<String, CommandProcessor>();
    private static final Map<String, FunctionProcessor> FUNCTIONS = new ConcurrentHashMap<String, FunctionProcessor>();
    private final GuiBook gui;
    private final Book book;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final class_2583 baseStyle;
    private Pattern COMMAND_PATTERN = Pattern.compile("\\$\\(([^)]*)\\)");

    private static void registerProcessor(CommandLookup processor) {
        COMMAND_LOOKUPS.add(processor);
    }

    public static void register(CommandProcessor handler, String ... names) {
        for (String name : names) {
            COMMANDS.put(name, handler);
        }
    }

    public static void register(FunctionProcessor function, String ... names) {
        for (String name : names) {
            FUNCTIONS.put(name, function);
        }
    }

    public BookTextParser(GuiBook gui, Book book, int x, int y, int width, int lineHeight, class_2583 baseStyle) {
        this.gui = gui;
        this.book = book;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseStyle = baseStyle;
    }

    public List<Span> parse(class_2561 text) {
        ArrayList<Span> spans = new ArrayList<Span>();
        SpanState state = new SpanState(this.gui, this.book, this.baseStyle);
        text.method_27660((style, string) -> {
            spans.addAll(this.processCommands(this.expandMacros(string), state, style));
            return Optional.empty();
        }, this.baseStyle);
        return spans;
    }

    public String expandMacros(@Nullable String text) {
        int i;
        String actualText = text;
        if (actualText == null) {
            actualText = "[ERROR]";
        }
        int expansionCap = 10;
        for (i = 0; i < expansionCap; ++i) {
            String newText = actualText;
            for (Map.Entry<String, String> e : this.book.macros.entrySet()) {
                newText = newText.replace(e.getKey(), e.getValue());
            }
            if (newText.equals(actualText)) break;
            actualText = newText;
        }
        if (i == expansionCap) {
            Patchouli.LOGGER.warn("Expanded macros for {} iterations without reaching fixpoint, stopping. Make sure you don't have circular macro invocations", (Object)expansionCap);
        }
        return actualText;
    }

    private List<Span> processCommands(String text, SpanState state, class_2583 style) {
        state.changeBaseStyle(style);
        ArrayList<Span> spans = new ArrayList<Span>();
        Matcher match = this.COMMAND_PATTERN.matcher(text);
        while (match.find()) {
            StringBuffer sb = new StringBuffer();
            match.appendReplacement(sb, "");
            spans.add(new Span(state, sb.toString()));
            try {
                String processed = this.processCommand(state, match.group(1));
                if (processed.isEmpty()) continue;
                spans.add(new Span(state, processed));
                if (state.cluster != null) continue;
                state.tooltip = EMPTY_STRING_COMPONENT;
            }
            catch (Exception ex) {
                spans.add(Span.error(state, "[ERROR]"));
            }
        }
        spans.add(new Span(state, match.appendTail(new StringBuffer()).toString()));
        return spans;
    }

    private String processCommand(SpanState state, String cmd) {
        CommandLookup lookup;
        state.endingExternal = false;
        Optional<Object> optResult = Optional.empty();
        Iterator<CommandLookup> iterator = COMMAND_LOOKUPS.iterator();
        while (iterator.hasNext() && !(optResult = (lookup = iterator.next()).process(cmd, state)).isPresent()) {
        }
        String result = optResult.orElse("$(" + cmd + ")");
        if (state.endingExternal) {
            result = result + class_124.field_1080 + "\u21aa";
        }
        return result;
    }

    private static Optional<String> colorCodeProcessor(String functionName, SpanState state) {
        if (functionName.length() == 1 && functionName.matches("^[0123456789abcdef]$")) {
            state.modifyStyle(s -> s.method_27706(class_124.method_544((char)functionName.charAt(0))));
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> colorHexProcessor(String functionName, SpanState state) {
        if (functionName.startsWith("#") && (functionName.length() == 4 || functionName.length() == 7)) {
            class_5251 color;
            String parse = functionName.substring(1);
            if (parse.length() == 3) {
                parse = "" + parse.charAt(0) + parse.charAt(0) + parse.charAt(1) + parse.charAt(1) + parse.charAt(2) + parse.charAt(2);
            }
            try {
                color = class_5251.method_27717((int)Integer.parseInt(parse, 16));
            }
            catch (NumberFormatException e) {
                color = state.getBase().method_10973();
            }
            state.color(color);
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> listProcessor(String functionName, SpanState state) {
        if (functionName.matches("li\\d?")) {
            char c = functionName.length() > 2 ? (char)functionName.charAt(2) : (char)'1';
            int dist = Character.isDigit(c) ? Character.digit(c, 10) : 1;
            int pad = dist * 4;
            char bullet = dist % 2 == 0 ? (char)'\u25e6' : '\u2022';
            state.lineBreaks = 1;
            state.spacingLeft = pad;
            state.spacingRight = state.spaceWidth;
            return Optional.of(class_124.field_1074.toString() + bullet);
        }
        return Optional.empty();
    }

    private static Optional<String> lookupFunctionProcessor(String functionName, SpanState state) {
        int index = functionName.indexOf(58);
        if (index > 0) {
            String fname = functionName.substring(0, index);
            String param = functionName.substring(index + 1);
            return Optional.of(Optional.ofNullable(FUNCTIONS.get(fname)).map(f -> f.process(param, state)).orElse("[MISSING FUNCTION: " + fname + "]"));
        }
        return Optional.empty();
    }

    private static Optional<String> lookupCommandProcessor(String functionName, SpanState state) {
        return Optional.ofNullable(COMMANDS.get(functionName)).map(c -> c.process(state));
    }

    private static class_304 getKeybindKey(SpanState state, String keybind) {
        class_304[] keys;
        String alt = "key." + keybind;
        for (class_304 k : keys = state.gui.getMinecraft().field_1690.field_1839) {
            String name = k.method_1431();
            if (!name.equals(keybind) && !name.equals(alt)) continue;
            return k;
        }
        return null;
    }

    static {
        BookTextParser.registerProcessor(BookTextParser::colorCodeProcessor);
        BookTextParser.registerProcessor(BookTextParser::colorHexProcessor);
        BookTextParser.registerProcessor(BookTextParser::listProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupFunctionProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupCommandProcessor);
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 1;
            return "";
        }, "br");
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 2;
            return "";
        }, "br2", "2br", "p");
        BookTextParser.register((SpanState state) -> {
            state.endingExternal = state.isExternalLink;
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            state.isExternalLink = false;
            return "";
        }, "/l");
        BookTextParser.register((SpanState state) -> {
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            return "";
        }, "/t");
        BookTextParser.register((SpanState state) -> state.gui.getMinecraft().field_1724.method_5477().getString(), "playername");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.method_27706(class_124.field_1051));
            return "";
        }, "k", "obf");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.method_27706(class_124.field_1067));
            return "";
        }, "l", "bold");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.method_27706(class_124.field_1055));
            return "";
        }, "m", "strike");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.method_27706(class_124.field_1056));
            return "";
        }, "o", "italic", "italics");
        BookTextParser.register((SpanState state) -> {
            state.reset();
            return "";
        }, "", "reset", "clear");
        BookTextParser.register((SpanState state) -> {
            state.baseColor();
            return "";
        }, "nocolor");
        BookTextParser.register((String parameter, SpanState state) -> {
            class_304 result = BookTextParser.getKeybindKey(state, parameter);
            if (result == null) {
                state.tooltip = new class_2588("patchouli.gui.lexicon.keybind_missing", new Object[]{parameter});
                return "N/A";
            }
            state.tooltip = new class_2588("patchouli.gui.lexicon.keybind", new Object[]{new class_2588(result.method_1431())});
            return result.method_16007().getString();
        }, "k");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.cluster = new LinkedList<Span>();
            state.pushStyle(class_2583.field_24360.method_27703(class_5251.method_27717((int)state.book.linkColor)));
            boolean isExternal = parameter.matches("^https?\\:.*");
            if (isExternal) {
                String url = parameter;
                state.tooltip = new class_2588("patchouli.gui.lexicon.external_link");
                state.isExternalLink = true;
                state.onClick = () -> {
                    GuiBook.openWebLink(url);
                    return true;
                };
            } else {
                class_2960 href;
                BookEntry entry;
                int hash = parameter.indexOf(35);
                String anchor = null;
                if (hash >= 0) {
                    anchor = parameter.substring(hash + 1);
                    parameter = parameter.substring(0, hash);
                }
                if ((entry = state.book.contents.entries.get(href = parameter.contains(":") ? new class_2960(parameter) : new class_2960(state.book.getModNamespace(), parameter))) != null) {
                    state.tooltip = entry.isLocked() ? new class_2588("patchouli.gui.lexicon.locked").method_27692(class_124.field_1080) : entry.getName();
                    GuiBook gui = state.gui;
                    Book book = state.book;
                    int page = 0;
                    if (anchor != null) {
                        int anchorPage = entry.getPageFromAnchor(anchor);
                        if (anchorPage >= 0) {
                            page = anchorPage / 2;
                        } else {
                            state.tooltip.method_27693(" (INVALID ANCHOR:" + anchor + ")");
                        }
                    }
                    int finalPage = page;
                    state.onClick = () -> {
                        GuiBookEntry entryGui = new GuiBookEntry(book, entry, finalPage);
                        gui.displayLexiconGui(entryGui, true);
                        GuiBook.playBookFlipSound(book);
                        return true;
                    };
                } else {
                    state.tooltip = new class_2585("BAD LINK: " + parameter);
                }
            }
            return "";
        }, "l");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.tooltip = new class_2585(parameter);
            state.cluster = new LinkedList<Span>();
            return "";
        }, "tooltip", "t");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.pushStyle(class_2583.field_24360.method_27703(class_5251.method_27717((int)state.book.linkColor)));
            state.cluster = new LinkedList<Span>();
            state.tooltip = !parameter.startsWith("/") ? new class_2585("INVALID COMMAND (must begin with /)") : new class_2585(parameter.length() < 20 ? parameter : parameter.substring(0, 20) + "...");
            state.onClick = () -> {
                state.gui.getMinecraft().field_1724.method_3142(parameter);
                return true;
            };
            return "";
        }, "command", "c");
        BookTextParser.register((SpanState state) -> {
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            return "";
        }, "/c");
    }

    public static interface FunctionProcessor {
        public String process(String var1, SpanState var2);
    }

    public static interface CommandProcessor {
        public String process(SpanState var1);
    }

    public static interface CommandLookup {
        public Optional<String> process(String var1, SpanState var2);
    }
}

