/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.fabric;

import corgitaco.enchancedcelestials.data.world.LunarData;
import corgitaco.enchancedcelestials.lunarevent.BloodMoon;
import corgitaco.enchancedcelestials.lunarevent.LunarEventSystem;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;
import lain.mods.peacefulsurface.init.fabric.FabricPeacefulSurface;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class FabricWorldObj
implements IWorldObj {
    private static final AtomicBoolean failedCompat_BloodMoon_EnhancedCelestials = new AtomicBoolean(!FabricLoader.getInstance().isModLoaded("enhancedcelestials"));
    private final WeakReference<class_3218> w;
    private final String name;

    public FabricWorldObj(class_3218 world) {
        if (world == null) {
            throw new IllegalArgumentException("world must not be null");
        }
        this.w = new WeakReference<class_3218>(world);
        this.name = world.method_27983().method_29177().toString();
    }

    @Override
    public String getBiomeName(double x, double y, double z) {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return "UNKNOWN";
        }
        return o.method_23753(new class_2338(x, y, z)).toString();
    }

    @Override
    public int getLightLevel(double x, double y, double z) {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.method_8546() ? o.method_22346(new class_2338(x, y, z), 10) : o.method_22339(new class_2338(x, y, z));
    }

    @Override
    public int getMoonPhase() {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.method_8597().method_28531(o.method_30271());
    }

    @Override
    public String getWorldName() {
        return this.name;
    }

    @Override
    public boolean isBloodMoon() {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return false;
        }
        if (!failedCompat_BloodMoon_EnhancedCelestials.get()) {
            try {
                return LunarEventSystem.LUNAR_EVENTS_MAP.get(LunarData.get((class_1936)o).getEvent()) instanceof BloodMoon;
            }
            catch (Throwable t) {
                FabricPeacefulSurface.LOGGER.error("error checking BloodMoon", t);
                failedCompat_BloodMoon_EnhancedCelestials.set(true);
            }
        }
        return false;
    }

    @Override
    public boolean isDayTime() {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return false;
        }
        return o.method_8530();
    }

    @Override
    public boolean isRaining() {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return false;
        }
        return o.method_8419();
    }

    @Override
    public boolean isThundering() {
        class_3218 o = (class_3218)this.w.get();
        if (o == null) {
            return false;
        }
        return o.method_8546();
    }
}

