/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;
import wraith.waystones.Utils;
import wraith.waystones.Waystones;

public class Config {
    private static Config instance = null;
    private class_2487 configData;
    private final Logger LOGGER = Waystones.LOGGER;
    private static final String CONFIG_FILE = "config/waystones/config.json";

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public boolean generateInVillages() {
        return this.configData.method_10577("generate_in_villages");
    }

    public boolean canOwnersRedeemPayments() {
        return this.configData.method_10577("can_owners_redeem_payments");
    }

    public class_2960 teleportCostItem() {
        if ("item".equals(this.configData.method_10558("cost_type"))) {
            String[] item = this.configData.method_10558("cost_item").split(":");
            return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
        }
        return null;
    }

    public String teleportType() {
        return this.configData.method_10558("cost_type");
    }

    public int teleportCost() {
        return Math.abs(this.configData.method_10550("cost_amount"));
    }

    public float getHardness() {
        return this.configData.method_10583("waystone_block_hardness");
    }

    public int getMiningLevel() {
        return this.configData.method_10550("waystone_block_required_mining_level");
    }

    public boolean consumeInfiniteScroll() {
        return this.configData.method_10577("consume_infinite_knowledge_scroll_on_use");
    }

    private Config() {
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        defaultConfig.method_10556("generate_in_villages", true);
        defaultConfig.method_10556("consume_infinite_knowledge_scroll_on_use", false);
        defaultConfig.method_10556("can_owners_redeem_payments", false);
        defaultConfig.method_10569("cost_amount", 1);
        defaultConfig.method_10582("cost_type", "level");
        defaultConfig.method_10582("cost_item", "minecraft:ender_pearl");
        defaultConfig.method_10548("waystone_block_hardness", 4.0f);
        defaultConfig.method_10569("waystone_block_required_mining_level", 1);
        class_2487 recipesTag = new class_2487();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("S", "minecraft:stone_bricks");
        itemMap.put("A", "waystones:abyss_watcher");
        itemMap.put("O", "minecraft:obsidian");
        itemMap.put("E", "minecraft:emerald");
        recipesTag.method_10582("waystone_recipe", Utils.createRecipe("SAS_SES_SOS", itemMap, "waystones:waystone", 1).toString());
        itemMap.clear();
        itemMap.put("A", "waystones:abyss_watcher");
        itemMap.put("S", "minecraft:nether_star");
        itemMap.put("P", "minecraft:blaze_powder");
        recipesTag.method_10582("pocket_wormhole", Utils.createRecipe(" A _PSP_ P ", itemMap, "waystones:pocket_wormhole", 1).toString());
        itemMap.clear();
        itemMap.put("E", "minecraft:ender_pearl");
        itemMap.put("F", "minecraft:flint");
        recipesTag.method_10582("abyss_watcher", Utils.createRecipe("FEF", itemMap, "waystones:abyss_watcher", 1).toString());
        itemMap.clear();
        itemMap.put("P", "minecraft:paper");
        itemMap.put("S", "minecraft:stick");
        recipesTag.method_10582("waystone_scroll", Utils.createRecipe("SPS_PPP_SPS", itemMap, "waystones:waystone_scroll", 1).toString());
        itemMap.clear();
        itemMap.put("A", "waystones:abyss_watcher");
        itemMap.put("B", "minecraft:blaze_powder");
        recipesTag.method_10582("local_void", Utils.createRecipe(" B _BAB_ B ", itemMap, "waystones:local_void", 1).toString());
        recipesTag.method_10582("scroll_of_infinite_knowledge", "none");
        defaultConfig.method_10566("recipes", (class_2520)recipesTag);
        return defaultConfig;
    }

    private JsonObject toJson(class_2487 tag) {
        float miningLevel;
        int blockHardness;
        String costItem;
        String costType;
        int costAmount;
        boolean canOnwersRedeem;
        boolean consumeInfiniteScroll;
        boolean generateInVillages;
        boolean overwrite = false;
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        if (tag.method_10545("generate_in_villages")) {
            generateInVillages = tag.method_10577("generate_in_villages");
        } else {
            overwrite = true;
            generateInVillages = defaults.method_10577("generate_in_villages");
        }
        json.addProperty("generate_in_villages", Boolean.valueOf(generateInVillages));
        if (tag.method_10545("consume_infinite_knowledge_scroll_on_use")) {
            consumeInfiniteScroll = tag.method_10577("consume_infinite_knowledge_scroll_on_use");
        } else {
            overwrite = true;
            consumeInfiniteScroll = defaults.method_10577("consume_infinite_knowledge_scroll_on_use");
        }
        json.addProperty("consume_infinite_knowledge_scroll_on_use", Boolean.valueOf(consumeInfiniteScroll));
        if (tag.method_10545("can_owners_redeem_payments")) {
            canOnwersRedeem = tag.method_10577("can_owners_redeem_payments");
        } else {
            overwrite = true;
            canOnwersRedeem = defaults.method_10577("can_owners_redeem_payments");
        }
        json.addProperty("can_owners_redeem_payments", Boolean.valueOf(canOnwersRedeem));
        if (tag.method_10545("cost_amount")) {
            costAmount = tag.method_10550("cost_amount");
        } else {
            overwrite = true;
            costAmount = defaults.method_10550("cost_amount");
        }
        json.addProperty("cost_amount", (Number)costAmount);
        if (tag.method_10545("cost_type")) {
            costType = tag.method_10558("cost_type").toLowerCase();
        } else {
            overwrite = true;
            costType = defaults.method_10558("cost_type");
        }
        json.addProperty("cost_type", costType);
        if (tag.method_10545("cost_item")) {
            costItem = tag.method_10558("cost_item").toLowerCase();
        } else {
            overwrite = true;
            costItem = defaults.method_10558("cost_item");
        }
        json.addProperty("cost_item", costItem);
        if (tag.method_10545("waystone_block_hardness")) {
            blockHardness = tag.method_10550("waystone_block_hardness");
        } else {
            overwrite = true;
            blockHardness = defaults.method_10550("waystone_block_hardness");
        }
        json.addProperty("waystone_block_hardness", (Number)blockHardness);
        if (tag.method_10545("waystone_block_required_mining_level")) {
            miningLevel = tag.method_10583("waystone_block_required_mining_level");
        } else {
            overwrite = true;
            miningLevel = defaults.method_10583("waystone_block_required_mining_level");
        }
        json.addProperty("waystone_block_required_mining_level", (Number)Float.valueOf(miningLevel));
        JsonObject recipesJson = new JsonObject();
        class_2487 recipesTag = tag.method_10562("recipes");
        class_2487 defaultRecipes = defaults.method_10562("recipes");
        for (String recipe : defaultRecipes.method_10541()) {
            String recipeString;
            if (recipesTag.method_10545(recipe)) {
                recipeString = recipesTag.method_10558(recipe);
            } else {
                overwrite = true;
                recipeString = defaultRecipes.method_10558(recipe);
            }
            recipesJson.addProperty(recipe, recipeString);
        }
        json.add("recipes", (JsonElement)recipesJson);
        this.createFile(json, overwrite);
        return json;
    }

    private class_2487 toCompoundTag(JsonObject json) {
        float miningLevel;
        int blockHardness;
        String costType;
        String costItem;
        int costAmount;
        boolean canOnwersRedeem;
        boolean consumeInfiniteScroll;
        boolean generateInVillages;
        boolean overwrite = false;
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        if (json.has("generate_in_villages")) {
            generateInVillages = json.get("generate_in_villages").getAsBoolean();
        } else {
            overwrite = true;
            generateInVillages = defaults.method_10577("generate_in_villages");
        }
        tag.method_10556("generate_in_villages", generateInVillages);
        if (json.has("consume_infinite_knowledge_scroll_on_use")) {
            consumeInfiniteScroll = json.get("consume_infinite_knowledge_scroll_on_use").getAsBoolean();
        } else {
            overwrite = true;
            consumeInfiniteScroll = defaults.method_10577("consume_infinite_knowledge_scroll_on_use");
        }
        tag.method_10556("consume_infinite_knowledge_scroll_on_use", consumeInfiniteScroll);
        if (json.has("can_owners_redeem_payments")) {
            canOnwersRedeem = json.get("can_owners_redeem_payments").getAsBoolean();
        } else {
            overwrite = true;
            canOnwersRedeem = defaults.method_10577("can_owners_redeem_payments");
        }
        tag.method_10556("can_owners_redeem_payments", canOnwersRedeem);
        if (json.has("cost_amount")) {
            costAmount = json.get("cost_amount").getAsInt();
        } else {
            overwrite = true;
            costAmount = defaults.method_10550("cost_amount");
        }
        tag.method_10569("cost_amount", costAmount);
        if (json.has("cost_item")) {
            costItem = json.get("cost_item").getAsString();
        } else {
            overwrite = true;
            costItem = defaults.method_10558("cost_item");
        }
        tag.method_10582("cost_item", costItem);
        if (json.has("cost_type")) {
            costType = json.get("cost_type").getAsString();
        } else {
            overwrite = true;
            costType = defaults.method_10558("cost_type");
        }
        tag.method_10582("cost_type", costType);
        if (json.has("waystone_block_hardness")) {
            blockHardness = json.get("waystone_block_hardness").getAsInt();
        } else {
            overwrite = true;
            blockHardness = defaults.method_10550("waystone_block_hardness");
        }
        tag.method_10569("waystone_block_hardness", blockHardness);
        if (json.has("waystone_block_required_mining_level")) {
            miningLevel = json.get("waystone_block_required_mining_level").getAsFloat();
        } else {
            overwrite = true;
            miningLevel = defaults.method_10583("waystone_block_required_mining_level");
        }
        tag.method_10548("waystone_block_required_mining_level", miningLevel);
        JsonObject recipesJson = json.get("recipes").getAsJsonObject();
        class_2487 recipesTag = new class_2487();
        class_2487 defaultRecipes = defaults.method_10562("recipes");
        for (String recipe : defaultRecipes.method_10541()) {
            String recipeString;
            if (recipesJson.has(recipe)) {
                recipeString = recipesJson.get(recipe).toString();
            } else {
                overwrite = true;
                recipeString = defaultRecipes.method_10558(recipe);
            }
            recipesTag.method_10582(recipe, recipeString);
        }
        tag.method_10566("recipes", (class_2520)recipesTag);
        this.createFile(this.toJson(tag), overwrite);
        return tag;
    }

    public boolean loadConfig() {
        try {
            JsonObject fileConfig = Config.getJsonObject(Config.readFile(new File(CONFIG_FILE)));
            return this.loadConfig(fileConfig);
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            class_2487 config;
            this.configData = config = this.toCompoundTag(fileConfig);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        File file;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = new JsonParser().parse(gson.toJson((JsonElement)contents)).getAsJsonObject();
        StringBuilder recipes = new StringBuilder();
        if (contents != null && contents.has("recipes")) {
            for (Map.Entry recipe : contents.get("recipes").getAsJsonObject().entrySet()) {
                if ("none".equals(((JsonElement)recipe.getValue()).getAsString())) continue;
                recipes.append("\"").append((String)recipe.getKey()).append("\": ").append(gson.toJson((JsonElement)new JsonParser().parse(((JsonElement)recipe.getValue()).getAsString()).getAsJsonObject())).append(",");
            }
            recipes = new StringBuilder(recipes.toString().replace("\n", "").replace("\r", ""));
            recipes = new StringBuilder(recipes.substring(0, recipes.length() - 1));
            recipes.append("}}");
            contents.remove("recipes");
        }
        if ((file = new File(CONFIG_FILE)).exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            if (!"".equals(recipes.toString())) {
                json = json.substring(0, json.length() - 1) + ",\"recipes\":{" + recipes;
            }
            writer.write(gson.toJson((JsonElement)new JsonParser().parse(json).getAsJsonObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class_2487 toCompoundTag() {
        return this.configData;
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    public static JsonObject getJsonObject(String json) {
        return new JsonParser().parse(json).getAsJsonObject();
    }

    public HashMap<String, JsonElement> getRecipes() {
        JsonObject json = this.toJson(this.configData).get("recipes").getAsJsonObject();
        HashMap<String, JsonElement> recipes = new HashMap<String, JsonElement>();
        for (Map.Entry recipe : json.entrySet()) {
            String recipeString = ((JsonElement)recipe.getValue()).getAsString();
            if ("none".equals(recipeString)) continue;
            recipes.put((String)recipe.getKey(), new JsonParser().parse(recipeString));
        }
        return recipes;
    }

    public void print(class_3222 player) {
        for (Map.Entry config : this.toJson(this.configData).entrySet()) {
            if (((JsonElement)config.getValue()).isJsonObject()) continue;
            player.method_7353((class_2561)new class_2585("\u00a76[\u00a7e" + (String)config.getKey() + "\u00a76] \u00a73 " + config.getValue()), false);
        }
    }
}

