/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import wraith.waystones.Config;
import wraith.waystones.ModifiableStructurePool;
import wraith.waystones.Waystones;
import wraith.waystones.block.WaystoneBlockEntity;

public class Utils {
    public static final Random random = new Random();

    public static int getRandomIntInRange(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static class_2960 ID(String id) {
        return new class_2960("waystones", id);
    }

    public static String generateWaystoneName(String id) {
        return id == null || "".equals(id) ? Utils.generateUniqueId() : id;
    }

    private static String generateUniqueId() {
        char c;
        StringBuilder sb = new StringBuilder();
        ArrayList<Character> vowels = new ArrayList<Character>(){
            {
                this.add(Character.valueOf('a'));
                this.add(Character.valueOf('e'));
                this.add(Character.valueOf('i'));
                this.add(Character.valueOf('o'));
                this.add(Character.valueOf('u'));
            }
        };
        while ((c = (char)Utils.getRandomIntInRange(65, 90)) == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U') {
        }
        sb.append(c);
        sb.append(vowels.get(random.nextInt(5)));
        for (int i = 0; i < 3; ++i) {
            while ((c = (char)Utils.getRandomIntInRange(97, 122)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u') {
            }
            sb.append(c);
            sb.append(vowels.get(random.nextInt(5)));
        }
        return sb.toString();
    }

    public static class_3785 tryAddElementToPool(class_2960 targetPool, class_3785 pool, String elementId, class_3785.class_3786 projection, int weight) {
        if (targetPool.equals((Object)pool.method_16629())) {
            ModifiableStructurePool modPool = new ModifiableStructurePool(pool);
            modPool.addStructurePoolElement((class_3784)class_3784.method_30426((String)elementId, (class_5497)class_5469.field_26688).apply(projection), weight);
            return modPool.getStructurePool();
        }
        return pool;
    }

    public static class_3785 tryAddElementToPool(class_2960 targetPool, class_3785 pool, String elementId, class_3785.class_3786 projection) {
        if (targetPool.equals((Object)pool.method_16629())) {
            ModifiableStructurePool modPool = new ModifiableStructurePool(pool);
            modPool.addStructurePoolElement((class_3784)class_3784.method_30426((String)elementId, (class_5497)class_5469.field_26688).apply(projection));
            return modPool.getStructurePool();
        }
        return pool;
    }

    public static long determineLevelXP(class_1657 player) {
        int level = player.field_7520;
        long total = player.field_7495;
        total = level <= 16 ? (total += (long)(Math.pow(level, 2.0) + (double)(6L * (long)level))) : (level <= 31 ? (total += (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0)) : (total += (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0)));
        return total;
    }

    public static boolean canTeleport(class_1657 player, String hash) {
        String cost = Config.getInstance().teleportType();
        int amount = Config.getInstance().teleportCost();
        if (player.method_7337()) {
            return true;
        }
        switch (cost) {
            case "hp": 
            case "health": {
                if (player.method_6032() + player.method_6067() <= (float)amount) {
                    return false;
                }
                player.method_5643(class_1282.field_5849, (float)amount);
                return true;
            }
            case "xp": 
            case "experience": {
                long total = Utils.determineLevelXP(player);
                if (total < (long)amount) {
                    return false;
                }
                player.method_7255(-amount);
                return true;
            }
            case "level": {
                if (player.field_7520 < amount) {
                    return false;
                }
                player.field_7520 -= amount;
                return true;
            }
            case "item": {
                class_2960 itemId = Config.getInstance().teleportCostItem();
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(itemId);
                if (!Utils.containsItem(player.field_7514, item, amount)) {
                    return false;
                }
                Utils.removeItem(player.field_7514, (class_1792)class_2378.field_11142.method_10223(itemId), amount);
                if (player.field_6002.field_9236 || Waystones.WAYSTONE_STORAGE == null) {
                    return true;
                }
                WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null) {
                    return true;
                }
                ArrayList<class_1799> oldInventory = new ArrayList<class_1799>((Collection<class_1799>)waystone.getInventory());
                boolean found = false;
                for (class_1799 stack : oldInventory) {
                    if (stack.method_7909() != item) continue;
                    stack.method_7933(amount);
                    found = true;
                    break;
                }
                if (!found) {
                    oldInventory.add(new class_1799((class_1935)class_2378.field_11142.method_10223(itemId), amount));
                }
                waystone.setInventory(oldInventory);
                return true;
            }
        }
        return true;
    }

    private static boolean containsItem(class_1661 inventory, class_1792 item, int maxAmount) {
        int amount = 0;
        for (class_1799 stack : inventory.field_7547) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7544) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7548) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        return amount >= maxAmount;
    }

    private static void removeItem(class_1661 inventory, class_1792 item, int totalAmount) {
        int amount;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7544) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7548) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
    }

    public static JsonObject createRecipe(String patternString, HashMap<String, String> itemMap, String output, int amount) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray jsonArray = new JsonArray();
        String[] pattern = patternString.split("_");
        jsonArray.add(pattern[0]);
        if (pattern.length > 1) {
            jsonArray.add(pattern[1]);
        }
        if (pattern.length > 2) {
            jsonArray.add(pattern[2]);
        }
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (Map.Entry<String, String> item : itemMap.entrySet()) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty("item", item.getValue());
            keyList.add(item.getKey(), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output);
        result.addProperty("count", (Number)amount);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static String getSHA256(String data) {
        try {
            return Arrays.toString(MessageDigest.getInstance("SHA-256").digest(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

