/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.block;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import wraith.waystones.Utils;
import wraith.waystones.block.WaystoneBlock;
import wraith.waystones.registries.BlockEntityRegistry;
import wraith.waystones.registries.ItemRegistry;
import wraith.waystones.screens.WaystoneScreenHandler;

public class WaystoneBlockEntity
extends class_2621
implements class_1278,
ExtendedScreenHandlerFactory,
BlockEntityClientSerializable,
class_3000 {
    private String name = "";
    private String hash;
    private boolean isGlobal = false;
    private UUID owner = null;
    private String ownerName = null;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    public float lookingRotR = 0.0f;
    private float turningSpeedR = 2.0f;
    private long tickDelta = 0L;

    public WaystoneBlockEntity() {
        super(BlockEntityRegistry.WAYSTONE_BLOCK_ENTITY);
        this.name = Utils.generateWaystoneName(this.name);
    }

    public void setOwner(class_1657 player) {
        if (player == null) {
            this.owner = null;
            this.ownerName = null;
        } else {
            this.owner = player.method_5667();
            this.ownerName = player.method_5477().method_10851();
        }
        this.method_5431();
    }

    public void createHash(class_1937 world, class_2338 pos) {
        this.hash = Utils.getSHA256("<POS X:" + pos.method_10263() + ", Y:" + pos.method_10264() + ", Z:" + pos.method_10260() + ", WORLD: \">" + world + "\">");
        this.method_5431();
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new WaystoneScreenHandler(syncId, this, player);
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return this.createMenu(syncId, playerInventory, playerInventory.field_7546);
    }

    public class_2561 method_5476() {
        return new class_2588("container.waystones.waystone");
    }

    protected class_2561 method_17823() {
        return this.method_5476();
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        if (tag.method_10545("waystone_name")) {
            this.name = tag.method_10558("waystone_name");
        }
        if (tag.method_10545("waystone_is_global")) {
            this.isGlobal = tag.method_10577("waystone_is_global");
        }
        if (tag.method_10545("waystone_owner")) {
            this.owner = tag.method_25926("waystone_owner");
        }
        if (tag.method_10545("waystone_owner_name")) {
            this.ownerName = tag.method_10558("waystone_owner_name");
        }
        this.inventory = class_2371.method_10213((int)tag.method_10550("inventory_size"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.inventory);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        return this.createTag(tag);
    }

    private class_2487 createTag(class_2487 tag) {
        tag.method_10582("waystone_name", this.name);
        if (this.owner != null) {
            tag.method_25927("waystone_owner", this.owner);
        }
        if (this.ownerName != null) {
            tag.method_10582("waystone_owner_name", this.ownerName);
        }
        tag.method_10556("waystone_is_global", this.isGlobal);
        tag.method_10569("inventory_size", this.inventory.size());
        class_1262.method_5426((class_2487)tag, this.inventory);
        return tag;
    }

    public int method_5439() {
        return 0;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sync();
        }
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.inventory = inventory;
        this.method_5431();
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        class_2487 tag = this.createTag(new class_2487());
        tag.method_10582("waystone_hash", this.hash);
        packetByteBuf.method_10794(tag);
    }

    public void fromClientTag(class_2487 tag) {
        this.method_11014(this.field_11863.method_8320(this.field_11867), tag);
    }

    public class_2487 toClientTag(class_2487 tag) {
        return this.method_11007(tag);
    }

    private float rotClamp(int clampTo, float value) {
        if (value >= (float)clampTo) {
            return value - (float)clampTo;
        }
        if (value < 0.0f) {
            return value + (float)clampTo;
        }
        return value;
    }

    private boolean checkBound(int amount, float rot) {
        float Rot = Math.round(rot);
        float Rot2 = this.rotClamp(360, Rot + 180.0f);
        return Rot - (float)amount <= this.lookingRotR && this.lookingRotR <= Rot + (float)amount || Rot2 - (float)amount <= this.lookingRotR && this.lookingRotR <= Rot2 + (float)amount;
    }

    private void moveOnTickR(float rot) {
        if (!this.checkBound(2, rot)) {
            double check = (this.rotClamp(180, rot) - this.rotClamp(180, this.lookingRotR) + 180.0f) % 180.0f;
            this.lookingRotR = check < 90.0 ? (this.lookingRotR += this.turningSpeedR) : (this.lookingRotR -= this.turningSpeedR);
            this.lookingRotR = this.rotClamp(360, this.lookingRotR);
            if (this.checkBound(10, rot)) {
                this.turningSpeedR = 2.0f;
            } else {
                this.turningSpeedR += 1.0f;
                this.turningSpeedR = class_3532.method_15363((float)this.turningSpeedR, (float)2.0f, (float)20.0f);
            }
        }
    }

    private void addParticle(class_1657 player) {
        if (this.field_11863 == null) {
            return;
        }
        Random r = this.field_11863.method_8409();
        class_243 playerPos = player.method_19538();
        class_2400 p = r.nextInt(10) > 7 ? class_2398.field_11215 : class_2398.field_11214;
        int j = r.nextInt(2) * 2 - 1;
        int k = r.nextInt(2) * 2 - 1;
        double y = this.method_11016().method_10264();
        int rd = r.nextInt(10);
        if (rd > 5) {
            if (p == class_2398.field_11215) {
                this.field_11863.method_8406((class_2394)p, playerPos.field_1352, playerPos.field_1351 + 2.0, playerPos.field_1350, (double)this.method_11016().method_10263() + 0.5 - playerPos.field_1352, y + 1.25 - playerPos.field_1351, (double)this.method_11016().method_10260() + 0.5 - playerPos.field_1350);
            } else {
                this.field_11863.method_8406((class_2394)p, (double)this.method_11016().method_10263() + 0.5, y + 0.8, (double)this.method_11016().method_10260() + 0.5, playerPos.field_1352 - (double)this.method_11016().method_10263() - r.nextDouble(), playerPos.field_1351 - (double)this.method_11016().method_10264() - r.nextDouble() * 0.5, playerPos.field_1350 - (double)this.method_11016().method_10260() - r.nextDouble());
            }
        }
        if (rd > 8) {
            this.field_11863.method_8406((class_2394)p, y + 0.5, (double)this.method_11016().method_10264() + 0.8, (double)this.method_11016().method_10260() + 0.5, r.nextDouble() * (double)j, (r.nextDouble() - 0.25) * 0.125, r.nextDouble() * (double)k);
        }
    }

    public void method_16896() {
        ++this.tickDelta;
        class_1657 closestPlayer = this.field_11863.method_18459((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 4.5, false);
        if (closestPlayer != null) {
            this.addParticle(closestPlayer);
            double x = closestPlayer.method_23317() - (double)this.method_11016().method_10263() - 0.5;
            double z = closestPlayer.method_23321() - (double)this.method_11016().method_10260() - 0.5;
            float rotY = (float)((double)((float)Math.atan2(z, x)) / Math.PI * 180.0 + 180.0);
            this.moveOnTickR(rotY);
        } else {
            this.lookingRotR += 2.0f;
        }
        if (this.tickDelta >= 360L) {
            this.tickDelta = 0L;
        }
        this.lookingRotR = this.rotClamp(360, this.lookingRotR);
    }

    public String getWaystoneName() {
        return this.name;
    }

    public boolean canAccess(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public String getDimension() {
        return WaystoneBlock.getDimensionName(this.field_11863);
    }

    public void teleportPlayer(class_1657 player, boolean isAbyssWatcher) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 playerEntity = (class_3222)player;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)WaystoneBlock.FACING);
        float x = 0.0f;
        float z = 0.0f;
        float yaw = playerEntity.field_6031;
        switch (facing) {
            case field_11043: {
                x = 0.5f;
                z = -0.5f;
                yaw = 0.0f;
                break;
            }
            case field_11035: {
                x = 0.5f;
                z = 1.5f;
                yaw = 180.0f;
                break;
            }
            case field_11034: {
                x = 1.5f;
                z = 0.5f;
                yaw = 90.0f;
                break;
            }
            case field_11039: {
                x = -0.5f;
                z = 0.5f;
                yaw = 270.0f;
            }
        }
        float fX = x;
        float fZ = z;
        float fYaw = yaw;
        ArrayList effects = new ArrayList(playerEntity.method_6026());
        if (playerEntity.method_5682() == null) {
            return;
        }
        playerEntity.method_5682().execute(() -> {
            player.method_5770().method_8421((class_1297)player, (byte)46);
            playerEntity.method_14251((class_3218)this.field_11863, (double)((float)this.field_11867.method_10263() + fX), (double)this.field_11867.method_10264(), (double)((float)this.field_11867.method_10260() + fZ), fYaw, 0.0f);
            playerEntity.method_14240();
            playerEntity.method_7255(0);
            if (isAbyssWatcher && playerEntity.method_6047().method_7909() == ItemRegistry.ITEMS.get("abyss_watcher") && !playerEntity.method_7337()) {
                player.method_20235(class_1304.field_6173);
                player.method_20235(class_1304.field_6173);
                playerEntity.method_6047().method_7934(1);
                player.field_6002.method_8396(null, this.field_11867, class_3417.field_15081, class_3419.field_15248, 1.0f, 1.0f);
            }
            float absorption = playerEntity.method_6067();
            for (class_1293 effect : effects) {
                playerEntity.method_6092(effect);
            }
            playerEntity.method_6073(absorption);
            player.method_5770().method_8421((class_1297)player, (byte)46);
        });
    }

    public void setName(String name) {
        this.name = name;
        this.method_5431();
    }

    public String getHash() {
        if (this.hash == null) {
            this.createHash(this.field_11863, this.field_11867);
        }
        return this.hash;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
        this.method_5431();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void toggleGlobal() {
        this.isGlobal = !this.isGlobal;
        this.method_5431();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setItemInSlot(int i, class_1799 itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public boolean hasStorage() {
        return !this.inventory.isEmpty();
    }

    public void setInventory(ArrayList<class_1799> newInventory) {
        this.inventory = class_2371.method_10213((int)newInventory.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < newInventory.size(); ++i) {
            this.setItemInSlot(i, newInventory.get(i));
        }
        this.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}

