/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import wraith.waystones.PlayerEntityMixinAccess;
import wraith.waystones.Utils;
import wraith.waystones.WaystonesClient;
import wraith.waystones.screens.Button;
import wraith.waystones.screens.ToggleableButton;
import wraith.waystones.screens.UniversalWaystoneScreen;
import wraith.waystones.screens.UniversalWaystoneScreenHandler;
import wraith.waystones.screens.WaystoneScreenHandler;

public class WaystoneScreen
extends UniversalWaystoneScreen {
    private static final class_2960 TEXTURE = Utils.ID("textures/gui/waystone.png");
    private static final class_2960 CONFIG_TEXTURE = Utils.ID("textures/gui/waystone_config.png");
    private class_342 nameField;
    private final ArrayList<Button> buttons = new ArrayList();
    protected boolean mousePressed;
    private Button configPage = new Button(156, -17, 18, 18, 210, 0){

        @Override
        public void onClick() {
            if (!this.isVisible()) {
                return;
            }
            WaystoneScreen.this.page = Page.CONFIG;
            for (Button button : WaystoneScreen.this.buttons) {
                button.setup();
            }
        }

        @Override
        public boolean isVisible() {
            return WaystoneScreen.this.page == Page.WAYSTONES;
        }

        @Override
        public void setup() {
            this.tooltip = new class_2588("waystones.config.tooltip.config");
        }
    };
    private Page page = Page.WAYSTONES;

    public WaystoneScreen(final class_1703 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, TEXTURE, title);
        this.buttons.add(this.configPage);
        this.buttons.add(new Button(156, -17, 18, 18, 178, 0){

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                WaystoneScreen.this.page = Page.WAYSTONES;
                ((UniversalWaystoneScreenHandler)handler).updateWaystones(((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546);
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.page == Page.CONFIG;
            }

            @Override
            public void setup() {
                this.tooltip = new class_2588("waystones.config.tooltip.back");
            }
        });
        this.buttons.add(new Button(8, 103, 13, 13, 178, 54){

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                WaystoneScreen.this.nameField.method_1852("");
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.canEdit() && WaystoneScreen.this.page == Page.CONFIG;
            }

            @Override
            public void setup() {
                this.tooltip = new class_2588("waystones.config.tooltip.delete_name");
            }
        });
        this.buttons.add(new ToggleableButton(128, 103, 13, 13, 191, 54, 217, 54){

            @Override
            public void setup() {
                boolean settable;
                this.tooltip = new class_2588("waystones.config.tooltip.set_name");
                boolean bl = settable = !((WaystoneScreenHandler)handler).getName().equals(WaystoneScreen.this.nameField.method_1882());
                if (this.toggled == settable) {
                    this.toggle();
                }
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.canEdit() && WaystoneScreen.this.page == Page.CONFIG;
            }

            @Override
            public void onClick() {
                boolean settable;
                if (!this.isVisible()) {
                    return;
                }
                WaystoneScreen.this.rename();
                boolean bl = settable = !((WaystoneScreenHandler)handler).getName().equals(WaystoneScreen.this.nameField.method_1882());
                if (this.toggled == settable) {
                    this.toggle();
                }
            }
        });
        this.buttons.add(new Button(143, 103, 13, 13, 204, 54){

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                WaystoneScreen.this.nameField.method_1852(Utils.generateWaystoneName(""));
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.canEdit() && WaystoneScreen.this.page == Page.CONFIG;
            }

            @Override
            public void setup() {
                this.tooltip = new class_2588("waystones.config.tooltip.randomize_name");
            }
        });
        this.buttons.add(new ToggleableButton(8, 48, 17, 17, 213, 0, 196, 0){

            @Override
            public void setup() {
                this.toggled = ((WaystoneScreenHandler)handler).isGlobal();
                this.tooltip = new class_2588("waystones.config.tooltip.toggle_is_global");
            }

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                ((WaystoneScreenHandler)handler).toggleGlobal();
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.canEdit() && WaystoneScreen.this.page == Page.CONFIG;
            }
        });
        this.buttons.add(new ToggleableButton(8, 11, 13, 13, 178, 54, 191, 54){

            @Override
            public void setup() {
                this.toggled = ((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).shouldViewDiscoveredWaystones();
                this.tooltip = new class_2588("waystones.config.tooltip.toggle_discovered_view");
            }

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                ((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).toggleViewDiscoveredWaystones();
                ((UniversalWaystoneScreenHandler)handler).updateWaystones(((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546);
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.method_10794(((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).toTagW(new class_2487()));
                ClientPlayNetworking.send((class_2960)Utils.ID("sync_player_from_client"), (class_2540)packet);
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.page == Page.CONFIG;
            }
        });
        this.buttons.add(new ToggleableButton(8, 27, 13, 13, 178, 54, 191, 54){

            @Override
            public void setup() {
                this.tooltip = new class_2588("waystones.config.tooltip.toggle_global_view");
                this.toggled = ((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).shouldViewGlobalWaystones();
            }

            @Override
            public void onClick() {
                if (!this.isVisible()) {
                    return;
                }
                super.onClick();
                ((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).toggleViewGlobalWaystones();
                ((UniversalWaystoneScreenHandler)handler).updateWaystones(((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546);
                class_2540 packet = new class_2540(Unpooled.buffer());
                packet.method_10794(((PlayerEntityMixinAccess)((WaystoneScreen)WaystoneScreen.this).field_17410.field_7546).toTagW(new class_2487()));
                ClientPlayNetworking.send((class_2960)Utils.ID("sync_player_from_client"), (class_2540)packet);
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.page == Page.CONFIG;
            }
        });
        this.buttons.add(new Button(30, 48, 17, 17, 230, 0){

            @Override
            public void onClick() {
                super.onClick();
                class_2540 packet = new class_2540(Unpooled.buffer());
                class_2487 tag = new class_2487();
                tag.method_10582("waystone_hash", ((WaystoneScreenHandler)handler).getWaystone());
                UUID owner = ((WaystoneScreenHandler)handler).getOwner();
                if (owner != null) {
                    tag.method_25927("waystone_owner", owner);
                }
                packet.method_10794(tag);
                ClientPlayNetworking.send((class_2960)Utils.ID("remove_waystone_owner"), (class_2540)packet);
                ((WaystoneScreenHandler)handler).removeOwner();
            }

            @Override
            public boolean isVisible() {
                return WaystoneScreen.this.canEdit() && WaystoneScreen.this.page == Page.CONFIG && ((WaystoneScreenHandler)handler).hasOwner();
            }

            @Override
            public void setup() {
                this.tooltip = new class_2588("waystones.config.tooltip.revoke_ownership");
            }
        });
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.nameField = new class_342(this.field_22793, this.field_2776 + 28, this.field_2800 + 106, 93, 10, (class_2561)new class_2588("waystone.rename")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                boolean bl;
                boolean bl2 = bl = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
                if (bl && button == 1) {
                    this.method_1852("");
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_1885() {
                return WaystoneScreen.this.canEdit();
            }

            public boolean method_25407(boolean lookForwards) {
                return this.method_1885() && super.method_25407(lookForwards);
            }

            public boolean method_25405(double mouseX, double mouseY) {
                return this.method_1885() && mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
            }
        };
        this.nameField.method_1880(16);
        this.nameField.method_1868(0xFFFFFF);
        this.nameField.method_1858(false);
        this.nameField.method_1856(true);
        String waystone = WaystonesClient.WAYSTONE_STORAGE.getName(((WaystoneScreenHandler)this.field_2797).getWaystone());
        this.nameField.method_1852(waystone == null ? "" : waystone);
        this.nameField.method_1863(s -> {
            boolean settable = !((WaystoneScreenHandler)this.field_2797).getName().equals(s);
            ToggleableButton button = (ToggleableButton)this.buttons.get(3);
            if (button.isToggled() == settable) {
                button.toggle();
            }
        });
        this.field_22786.add(this.nameField);
    }

    private boolean canEdit() {
        return ((WaystoneScreenHandler)this.field_2797).isOwner(this.field_17410.field_7546) || this.field_17410.field_7546.method_5687(2);
    }

    @Override
    public void method_25393() {
        if (this.page == Page.WAYSTONES) {
            super.method_25393();
        } else if (this.nameField != null && this.nameField.method_1885()) {
            this.nameField.method_1865();
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    @Override
    public void method_25410(class_310 client, int width, int height) {
        if (this.page == Page.WAYSTONES) {
            super.method_25410(client, width, height);
        } else {
            String string = this.nameField.method_1882();
            this.method_25423(client, width, height);
            this.nameField.method_1852(string);
        }
        super.superResize(client, width, height);
    }

    @Override
    public boolean method_25400(char chr, int keyCode) {
        if (this.page == Page.WAYSTONES) {
            return super.method_25400(chr, keyCode);
        }
        if (this.ignoreTypedCharacter) {
            return false;
        }
        return this.nameField.method_1885() && this.nameField.method_25400(chr, keyCode);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.page == Page.WAYSTONES) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        this.ignoreTypedCharacter = false;
        if (class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent() && this.method_2384(keyCode, scanCode)) {
            this.ignoreTypedCharacter = true;
            return true;
        }
        if (this.nameField.method_1885() && this.nameField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.nameField.method_1885() && this.nameField.method_25370() && this.nameField.method_1885() && keyCode != 256 || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.ignoreTypedCharacter = false;
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        if (this.page == Page.WAYSTONES) {
            super.method_2389(matrices, delta, mouseX, mouseY);
        } else {
            this.method_25420(matrices);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_22787.method_1531().method_22813(CONFIG_TEXTURE);
            this.method_25302(matrices, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
            if (this.canEdit()) {
                this.method_25302(matrices, this.field_2776 + 23, this.field_2800 + 103, 0, 125, 103, 13);
            }
            this.renderButtons(matrices, mouseX, mouseY);
            this.renderButtonText(matrices);
            String owner = ((WaystoneScreenHandler)this.field_2797).getOwnerName();
            Object ownerText = owner == null || "".equals(owner) ? new class_2588("waystones.config.no_owner") : new class_2585(owner);
            this.field_22793.method_30883(matrices, (class_2561)new class_2588("waystones.config.owner").method_10852((class_2561)new class_2585(": ").method_10852((class_2561)ownerText)), (float)(this.field_2776 + 10), (float)(this.field_2800 + 75), 0x161616);
            if (this.nameField.method_1885()) {
                this.nameField.method_25394(matrices, mouseX, mouseY, delta);
            }
            this.renderButtonTooltips(matrices, mouseX, mouseY);
        }
    }

    private void renderButtonText(class_4587 matrices) {
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("waystones.config.view_discovered"), (float)(this.field_2776 + 25), (float)(this.field_2800 + 14), 0x161616);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("waystones.config.view_global"), (float)(this.field_2776 + 25), (float)(this.field_2800 + 30), 0x161616);
    }

    @Override
    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        if (this.page == Page.WAYSTONES) {
            this.field_22793.method_1729(matrices, ((WaystoneScreenHandler)this.field_2797).getName(), (float)this.field_25267, (float)this.field_25268, 0x404040);
        }
    }

    protected void method_2383(class_1735 slot, int invSlot, int clickData, class_1713 actionType) {
        if (this.page == Page.WAYSTONES) {
            super.method_2383(slot, invSlot, clickData, actionType);
        } else {
            super.superOnMouseClick(slot, invSlot, clickData, actionType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mousePressed = true;
        if (this.page == Page.WAYSTONES) {
            if (!this.configPage.isVisible() || !this.configPage.isInBounds((int)mouseX - this.field_2776, (int)mouseY - this.field_2800)) return super.method_25402(mouseX, mouseY, button);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            this.configPage.onClick();
            return super.superMouseClicked(mouseX, mouseY, button);
        } else {
            for (Button guiButton : this.buttons) {
                if (!guiButton.isVisible() || !guiButton.isInBounds((int)mouseX - this.field_2776, (int)mouseY - this.field_2800)) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                guiButton.onClick();
            }
        }
        return super.superMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mousePressed = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.page == Page.WAYSTONES) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.superMouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.page == Page.WAYSTONES) {
            return super.method_25401(mouseX, mouseY, amount);
        }
        return super.superMouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public void renderButtons(class_4587 matrices, int mouseX, int mouseY) {
        for (Button button : this.buttons) {
            if (!button.isVisible()) continue;
            int u = button.getU();
            int v = button.getV();
            if (button.isInBounds(mouseX - this.field_2776, mouseY - this.field_2800)) {
                v += button.getHeight() * (this.mousePressed ? 1 : 2);
            }
            this.method_25302(matrices, this.field_2776 + button.getX(), this.field_2800 + button.getY(), u, v, button.getWidth(), button.getHeight());
        }
    }

    private void renderButtonTooltips(class_4587 matrices, int mouseX, int mouseY) {
        for (Button button : this.buttons) {
            if (!button.isVisible() || !button.hasToolTip() || !button.isInBounds(mouseX - this.field_2776, mouseY - this.field_2800)) continue;
            this.method_25424(matrices, button.tooltip(), mouseX, mouseY);
        }
    }

    private void rename() {
        if (!this.canEdit()) {
            return;
        }
        String name = this.nameField.method_1882();
        String hash = ((WaystoneScreenHandler)this.field_2797).getWaystone();
        UUID owner = ((WaystoneScreenHandler)this.field_2797).getOwner();
        if (name == null) {
            name = "";
        }
        ((WaystoneScreenHandler)this.field_2797).setName(name);
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2487 tag = new class_2487();
        tag.method_10582("waystone_name", name);
        tag.method_10582("waystone_hash", hash);
        tag.method_25927("waystone_owner", owner);
        data.method_10794(tag);
        ClientPlayNetworking.send((class_2960)Utils.ID("rename_waystone"), (class_2540)data);
    }

    private static enum Page {
        WAYSTONES,
        CONFIG;

    }
}

