/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.command.PowerArgument;
import io.github.apace100.origins.command.PowerOperation;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.registry.ModComponents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2214;
import net.minecraft.class_2233;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_267;
import net.minecraft.class_3222;

public class ResourceCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resource").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerArgument.power()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, Subcommands.HAS)))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerArgument.power()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, Subcommands.GET)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerArgument.power()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, Subcommands.SET))))))).then(class_2170.method_9247((String)"change").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerArgument.power()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, Subcommands.CHANGE))))))).then(class_2170.method_9247((String)"operation").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"power", (ArgumentType)PowerArgument.power()).then(class_2170.method_9244((String)"operation", (ArgumentType)PowerOperation.operation()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2233.method_9447()).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(command -> ResourceCommand.resource((CommandContext<class_2168>)command, Subcommands.OPERATION)))))))));
    }

    private static int resource(CommandContext<class_2168> command, Subcommands sub) throws CommandSyntaxException {
        int i = 0;
        class_3222 player = class_2186.method_9315(command, (String)"target");
        PowerType powerType = (PowerType)command.getArgument("power", PowerType.class);
        Object power = ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getPower(powerType);
        if (power instanceof VariableIntPower) {
            VariableIntPower vIntPower = (VariableIntPower)power;
            switch (sub) {
                case HAS: {
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.execute.conditional.pass"), true);
                    return 1;
                }
                case GET: {
                    i = vIntPower.getValue();
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.get.success", new Object[]{player.method_5820(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case SET: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    vIntPower.setValue(i);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.set.success.single", new Object[]{powerType.getIdentifier(), player.method_5820(), i}), true);
                    return 1;
                }
                case CHANGE: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    int total = vIntPower.getValue() + i;
                    vIntPower.setValue(total);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.add.success.single", new Object[]{i, powerType.getIdentifier(), player.method_5820(), total}), true);
                    return 1;
                }
                case OPERATION: {
                    class_267 score = ((class_2168)command.getSource()).method_9211().method_3845().method_1180(class_2233.method_9452(command, (String)"entity"), class_2214.method_9395(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(vIntPower, score);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.operation.success.single", new Object[]{powerType.getIdentifier(), player.method_5820(), vIntPower.getValue()}), true);
                    return 1;
                }
            }
        } else if (power instanceof CooldownPower) {
            CooldownPower cooldownPower = (CooldownPower)power;
            switch (sub) {
                case HAS: {
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.execute.conditional.pass"), true);
                    return 1;
                }
                case GET: {
                    i = cooldownPower.getRemainingTicks();
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.get.success", new Object[]{player.method_5820(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case SET: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.setCooldown(i);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.set.success.single", new Object[]{powerType.getIdentifier(), player.method_5820(), i}), true);
                    return 1;
                }
                case CHANGE: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.modify(i);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.add.success.single", new Object[]{i, powerType.getIdentifier(), player.method_5820(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
                case OPERATION: {
                    class_267 score = ((class_2168)command.getSource()).method_9211().method_3845().method_1180(class_2233.method_9452(command, (String)"entity"), class_2214.method_9395(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(cooldownPower, score);
                    OriginComponent.sync((class_1657)player);
                    ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.scoreboard.players.operation.success.single", new Object[]{powerType.getIdentifier(), player.method_5820(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
            }
        } else {
            switch (sub) {
                case HAS: {
                    ((class_2168)command.getSource()).method_9213((class_2561)new class_2588("commands.execute.conditional.fail"));
                    return 0;
                }
                case GET: {
                    ((class_2168)command.getSource()).method_9213((class_2561)new class_2588("commands.scoreboard.players.get.null", new Object[]{powerType.getIdentifier(), player.method_5820()}));
                    return 0;
                }
                case SET: 
                case CHANGE: 
                case OPERATION: {
                    ((class_2168)command.getSource()).method_9213((class_2561)new class_2588("argument.scoreHolder.empty"));
                    return 0;
                }
            }
        }
        return 0;
    }

    public static enum Subcommands {
        HAS,
        GET,
        SET,
        CHANGE,
        OPERATION;

    }
}

