/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.SimpleStatusEffectPower;
import io.github.apace100.origins.power.StackingStatusEffectPower;
import io.github.apace100.origins.power.StatusEffectPower;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class PlayerOriginComponent
implements OriginComponent {
    private class_1657 player;
    private HashMap<OriginLayer, Origin> origins = new HashMap();
    private ConcurrentHashMap<PowerType<?>, Power> powers = new ConcurrentHashMap();
    private boolean hadOriginBefore = false;

    public PlayerOriginComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayers.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins(this.player).size() == 0 || this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY);
    }

    @Override
    public HashMap<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins != null && this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        if (!this.origins.containsKey(layer)) {
            return null;
        }
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public boolean hasPower(PowerType<?> powerType) {
        return this.powers.containsKey(powerType);
    }

    private boolean hasPowerType(PowerType<?> powerType) {
        return this.origins.values().stream().anyMatch(o -> o.hasPowerType(powerType));
    }

    @Override
    public <T extends Power> T getPower(PowerType<T> powerType) {
        if (this.powers.containsKey(powerType)) {
            return (T)this.powers.get(powerType);
        }
        return null;
    }

    @Override
    public List<Power> getPowers() {
        LinkedList<Power> list = new LinkedList<Power>();
        list.addAll(this.powers.values());
        return list;
    }

    private Set<PowerType<?>> getPowerTypes() {
        HashSet powerTypes = new HashSet();
        this.origins.values().forEach(origin -> {
            if (origin != null) {
                origin.getPowerTypes().forEach(powerTypes::add);
            }
        });
        return powerTypes;
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass) {
        return this.getPowers(powerClass, false);
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass, boolean includeInactive) {
        LinkedList<Power> list = new LinkedList<Power>();
        for (Power power : this.powers.values()) {
            if (!powerClass.isAssignableFrom(power.getClass()) || !includeInactive && !power.isActive()) continue;
            list.add(power);
        }
        return list;
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        Origin oldOrigin = this.getOrigin(layer);
        if (oldOrigin == origin) {
            return;
        }
        this.origins.put(layer, origin);
        if (oldOrigin != null) {
            LinkedList powersToRemove = new LinkedList();
            for (Map.Entry<PowerType<?>, Power> entry : this.powers.entrySet()) {
                if (this.hasPowerType(entry.getKey())) continue;
                entry.getValue().onRemoved();
                entry.getValue().onLost();
                powersToRemove.add(entry.getKey());
            }
            for (PowerType powerType2 : powersToRemove) {
                this.powers.remove(powerType2);
            }
        }
        origin.getPowerTypes().forEach(powerType -> {
            if (!this.powers.containsKey(powerType)) {
                Object power = powerType.create(this.player);
                this.powers.put((PowerType<?>)powerType, (Power)power);
                ((Power)power).onAdded();
            }
        });
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
    }

    public void serverTick() {
        this.getPowers(Power.class, true).stream().filter(p -> p.shouldTick() && (p.shouldTickWhenInactive() || p.isActive())).forEach(Power::tick);
        if (this.player.field_6012 % 10 == 0) {
            this.getPowers(SimpleStatusEffectPower.class).forEach(StatusEffectPower::applyEffects);
            this.getPowers(StackingStatusEffectPower.class, true).forEach(StackingStatusEffectPower::tick);
        }
    }

    public void readFromNbt(class_2487 compoundTag) {
        this.fromTag(compoundTag, true);
    }

    private void fromTag(class_2487 compoundTag, boolean callPowerOnAdd) {
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in `fromTag`! This is a bug!");
        }
        if (this.origins != null) {
            if (callPowerOnAdd) {
                for (Power power : this.powers.values()) {
                    power.onRemoved();
                    power.onLost();
                }
            }
            this.powers.clear();
        }
        this.origins.clear();
        if (compoundTag.method_10545("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayers.getLayer(new class_2960("origins", "origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(class_2960.method_12829((String)compoundTag.method_10558("Origin"))));
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Player " + this.player.method_5476().method_10851() + " had old origin which could not be migrated: " + compoundTag.method_10558("Origin"));
            }
        } else {
            class_2499 originLayerList = (class_2499)compoundTag.method_10580("OriginLayers");
            if (originLayerList != null) {
                for (int i = 0; i < originLayerList.size(); ++i) {
                    class_2487 layerTag = originLayerList.method_10602(i);
                    class_2960 layerId = class_2960.method_12829((String)layerTag.method_10558("Layer"));
                    OriginLayer layer = null;
                    try {
                        layer = OriginLayers.getLayer(layerId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin layer with id " + layerId.toString() + ", which existed on the data of player " + this.player.method_5476().method_10851() + ".");
                    }
                    if (layer == null) continue;
                    class_2960 originId = class_2960.method_12829((String)layerTag.method_10558("Origin"));
                    Origin origin = null;
                    try {
                        origin = OriginRegistry.get(originId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin with id " + originId.toString() + ", which existed on the data of player " + this.player.method_5476().method_10851() + ".");
                    }
                    if (origin == null) continue;
                    if (!layer.contains(origin) && !origin.isSpecial()) {
                        Origins.LOGGER.warn("Origin with id " + origin.getIdentifier().toString() + " is not in layer " + layer.getIdentifier().toString() + " and is not special, but was found on " + this.player.method_5476().method_10851() + ", setting to EMPTY.");
                        origin = Origin.EMPTY;
                    }
                    this.origins.put(layer, origin);
                }
            }
        }
        this.hadOriginBefore = compoundTag.method_10577("HadOriginBefore");
        class_2499 powerList = (class_2499)compoundTag.method_10580("Powers");
        for (int i = 0; i < powerList.size(); ++i) {
            class_2487 powerTag = powerList.method_10602(i);
            class_2960 powerTypeId = class_2960.method_12829((String)powerTag.method_10558("Type"));
            try {
                PowerType type = PowerTypeRegistry.get(powerTypeId);
                if (!this.hasPowerType(type)) continue;
                class_2520 data = powerTag.method_10580("Data");
                Object power = type.create(this.player);
                try {
                    ((Power)power).fromTag(data);
                }
                catch (ClassCastException e) {
                    Origins.LOGGER.warn("Data type of \"" + powerTypeId + "\" changed, skipping data for that power on player " + this.player.method_5477().method_10851());
                }
                this.powers.put(type, (Power)power);
                if (!callPowerOnAdd) continue;
                ((Power)power).onAdded();
                continue;
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Power data of unregistered power \"" + powerTypeId + "\" found on player, skipping...");
            }
        }
        this.getPowerTypes().forEach(pt -> {
            if (!this.powers.containsKey(pt)) {
                Object power = pt.create(this.player);
                this.powers.put((PowerType<?>)pt, (Power)power);
            }
        });
    }

    public void writeToNbt(class_2487 compoundTag) {
        class_2499 originLayerList = new class_2499();
        for (Map.Entry<OriginLayer, Origin> entry : this.origins.entrySet()) {
            class_2487 layerTag = new class_2487();
            layerTag.method_10582("Layer", entry.getKey().getIdentifier().toString());
            layerTag.method_10582("Origin", entry.getValue().getIdentifier().toString());
            originLayerList.add((Object)layerTag);
        }
        compoundTag.method_10566("OriginLayers", (class_2520)originLayerList);
        compoundTag.method_10556("HadOriginBefore", this.hadOriginBefore);
        class_2499 powerList = new class_2499();
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            class_2487 powerTag = new class_2487();
            powerTag.method_10582("Type", PowerTypeRegistry.getId(powerEntry.getKey()).toString());
            powerTag.method_10566("Data", powerEntry.getValue().toTag());
            powerList.add((Object)powerTag);
        }
        compoundTag.method_10566("Powers", (class_2520)powerList);
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 compoundTag = buf.method_10798();
        if (compoundTag != null) {
            this.fromTag(compoundTag, false);
        }
    }

    @Override
    public void sync() {
        OriginComponent.sync(this.player);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("OriginComponent[\n");
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            str.append("\t").append(PowerTypeRegistry.getId(powerEntry.getKey())).append(": ").append(powerEntry.getValue().toTag().toString()).append("\n");
        }
        str.append("]");
        return str.toString();
    }
}

