/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.access.EntityShapeContextAccess;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PhasingPower;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4970.class_4971.class})
public abstract class AbstractBlockStateMixin {
    @Shadow
    public abstract class_2248 method_26204();

    @Shadow
    protected abstract class_2680 method_26233();

    @Shadow
    public abstract class_265 method_26218(class_1922 var1, class_2338 var2);

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/ShapeContext;)Lnet/minecraft/util/shape/VoxelShape;"}, cancellable=true)
    private void phaseThroughBlocks(class_1922 world, class_2338 pos, class_3726 context, CallbackInfoReturnable<class_265> info) {
        class_1297 entity;
        class_265 blockShape = this.method_26204().method_9549(this.method_26233(), world, pos, context);
        if (!blockShape.method_1110() && context instanceof class_3727 && (entity = ((EntityShapeContextAccess)context).getEntity()) != null) {
            boolean isAbove = this.isAbove(entity, blockShape, pos, false);
            for (PhasingPower phasingPower : OriginComponent.getPowers(entity, PhasingPower.class)) {
                if (isAbove && !phasingPower.shouldPhaseDown((class_1657)entity) || !phasingPower.doesApply(pos)) continue;
                info.setReturnValue((Object)class_259.method_1073());
            }
        }
    }

    @Unique
    private boolean isAbove(class_1297 entity, class_265 shape, class_2338 pos, boolean defaultValue) {
        return entity.method_23318() > (double)pos.method_10264() + shape.method_1105(class_2350.class_2351.field_11052) - (entity.method_24828() ? 0.503125 : 0.0015);
    }

    @Inject(method={"onEntityCollision"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventCollisionWhenPhasing(class_1937 world, class_2338 pos, class_1297 entity, CallbackInfo ci) {
        for (PhasingPower phasingPower : OriginComponent.getPowers(entity, PhasingPower.class)) {
            if (!phasingPower.doesApply(pos)) continue;
            ci.cancel();
        }
    }
}

