/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.LavaVisionPower;
import io.github.apace100.origins.power.NightVisionPower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_4184;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_758.class})
@Environment(value=EnvType.CLIENT)
public abstract class BackgroundRendererMixin {
    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=1), method={"render"})
    private static boolean hasStatusEffectProxy(class_1309 player, class_1291 effect) {
        if (player instanceof class_1657 && effect == class_1294.field_5925 && !player.method_6059(class_1294.field_5925)) {
            return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getPowers(NightVisionPower.class).stream().anyMatch(Power::isActive);
        }
        return player.method_6059(effect);
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;getFocusedEntity()Lnet/minecraft/entity/Entity;", ordinal=0), ordinal=0)
    private static double modifyD(double original, class_4184 camera) {
        if (camera.method_19331() instanceof class_1657 && OriginComponent.getPowers(camera.method_19331(), PhasingPower.class).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && BackgroundRendererMixin.getInWallBlockState((class_1657)camera.method_19331()) != null) {
            return 0.0;
        }
        return original;
    }

    @Redirect(method={"applyFog"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogStart(F)V"))
    private static void redirectFogStart(float start, class_4184 camera, class_758.class_4596 fogType) {
        List<PhasingPower> phasings;
        if (camera.method_19331() instanceof class_1657 && (phasings = OriginComponent.getPowers(camera.method_19331(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && BackgroundRendererMixin.getInWallBlockState((class_1657)camera.method_19331()) != null) {
            float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS).map(PhasingPower::getViewDistance).min(Float::compareTo).get().floatValue();
            float s = fogType == class_758.class_4596.field_20945 ? Math.min(0.0f, start) : Math.min(view * 0.25f, start);
            RenderSystem.fogStart((float)s);
            return;
        }
        RenderSystem.fogStart((float)start);
    }

    @Redirect(method={"applyFog"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogEnd(F)V"))
    private static void redirectFogEnd(float end, class_4184 camera, class_758.class_4596 fogType) {
        List<PhasingPower> phasings;
        if (camera.method_19331() instanceof class_1657 && (phasings = OriginComponent.getPowers(camera.method_19331(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && BackgroundRendererMixin.getInWallBlockState((class_1657)camera.method_19331()) != null) {
            float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS).map(PhasingPower::getViewDistance).min(Float::compareTo).get().floatValue();
            float v = fogType == class_758.class_4596.field_20945 ? Math.min(view * 0.8f, end) : Math.min(view, end);
            RenderSystem.fogEnd((float)v);
            return;
        }
        RenderSystem.fogEnd((float)end);
    }

    private static class_2680 getInWallBlockState(class_1657 playerEntity) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.method_23317() + (double)(((float)((i >> 0) % 2) - 0.5f) * playerEntity.method_17681() * 0.8f);
            double e = playerEntity.method_23320() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.method_23321() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.method_17681() * 0.8f);
            mutable.method_10102(d, e, f);
            class_2680 blockState = playerEntity.field_6002.method_8320((class_2338)mutable);
            if (blockState.method_26217() == class_2464.field_11455 || !blockState.method_26230((class_1922)playerEntity.field_6002, (class_2338)mutable)) continue;
            return blockState;
        }
        return null;
    }

    @ModifyConstant(method={"applyFog"}, constant={@Constant(floatValue=0.25f, ordinal=0)})
    private static float modifyLavaVisibilitySNoPotion(float original, class_4184 camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.method_19331(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getS();
        }
        return original;
    }

    @ModifyConstant(method={"applyFog"}, constant={@Constant(floatValue=1.0f, ordinal=1)})
    private static float modifyLavaVisibilityVNoPotion(float original, class_4184 camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.method_19331(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getV();
        }
        return original;
    }

    @ModifyConstant(method={"applyFog"}, constant={@Constant(floatValue=0.0f, ordinal=0)})
    private static float modifyLavaVisibilitySWithPotion(float original, class_4184 camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.method_19331(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getS();
        }
        return original;
    }

    @ModifyConstant(method={"applyFog"}, constant={@Constant(floatValue=3.0f, ordinal=0)})
    private static float modifyLavaVisibilityVWithPotion(float original, class_4184 camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.method_19331(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getV();
        }
        return original;
    }
}

