/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.github.apace100.origins.access.EndRespawningEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ModifyDamageTakenPower;
import io.github.apace100.origins.power.ModifyPlayerSpawnPower;
import io.github.apace100.origins.power.PreventSleepPower;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1712;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements class_1712,
EndRespawningEntity {
    @Shadow
    private class_5321<class_1937> field_23191;
    @Shadow
    private class_2338 field_23192;
    @Shadow
    private boolean field_23193;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    public class_3244 field_13987;
    @Shadow
    public boolean field_13989;
    @Unique
    private boolean origins_isEndRespawning;

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @ModifyArg(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private float modifyDamageAmount(class_1282 source, float originalAmount) {
        return OriginComponent.modify((class_1297)this, ModifyDamageTakenPower.class, originalAmount, p -> p.doesApply(source, originalAmount), p -> p.executeActions(source.method_5529()));
    }

    @Inject(method={"trySleep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/util/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V")}, cancellable=true)
    public void preventAvianSleep(class_2338 pos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> info) {
        OriginComponent.getPowers((class_1297)this, PreventSleepPower.class).forEach(p -> {
            if (p.doesPrevent((class_4538)this.field_6002, pos)) {
                if (p.doesAllowSpawnPoint()) {
                    ((class_3222)this).method_26284(this.field_6002.method_27983(), pos, this.field_6031, false, true);
                }
                info.setReturnValue((Object)Either.left(null));
                this.method_7353((class_2561)new class_2588(p.getMessage()), true);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointDimension"}, cancellable=true)
    private void modifySpawnPointDimension(CallbackInfoReturnable<class_5321<class_1937>> info) {
        if (!this.origins_isEndRespawning && (this.field_23192 == null || this.hasObstructedSpawn()) && OriginComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).size() > 0) {
            ModifyPlayerSpawnPower power = OriginComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).get(0);
            info.setReturnValue(power.dimension);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointPosition"}, cancellable=true)
    private void modifyPlayerSpawnPosition(CallbackInfoReturnable<class_2338> info) {
        if (!this.origins_isEndRespawning && OriginComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).size() > 0) {
            if (this.field_23192 == null) {
                info.setReturnValue((Object)this.findPlayerSpawn());
            } else if (this.hasObstructedSpawn()) {
                this.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25645, 0.0f));
                info.setReturnValue((Object)this.findPlayerSpawn());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSpawnPointSet"}, cancellable=true)
    private void modifySpawnPointSet(CallbackInfoReturnable<Boolean> info) {
        if (!this.origins_isEndRespawning && (this.field_23192 == null || this.hasObstructedSpawn()) && OriginComponent.hasPower((class_1297)this, ModifyPlayerSpawnPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    private boolean hasObstructedSpawn() {
        class_3218 world = this.field_13995.method_3847(this.field_23191);
        if (this.field_23192 != null && world != null) {
            Optional optional = class_1657.method_26091((class_3218)world, (class_2338)this.field_23192, (float)0.0f, (boolean)this.field_23193, (boolean)true);
            return !optional.isPresent();
        }
        return false;
    }

    private class_2338 findPlayerSpawn() {
        ModifyPlayerSpawnPower power = OriginComponent.getPowers((class_1297)this, ModifyPlayerSpawnPower.class).get(0);
        class_3545<class_3218, class_2338> spawn = power.getSpawn(true);
        if (spawn != null) {
            return (class_2338)spawn.method_15441();
        }
        return null;
    }

    @Override
    public void setEndRespawning(boolean endSpawn) {
        this.origins_isEndRespawning = endSpawn;
    }

    @Override
    public boolean isEndRespawning() {
        return this.origins_isEndRespawning;
    }

    @Override
    public boolean hasRealRespawnPoint() {
        return this.field_23192 != null && !this.hasObstructedSpawn();
    }
}

