/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.power.MultiplePowerType;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class Origin {
    public static final SerializableData DATA = new SerializableData().add("powers", SerializableDataType.IDENTIFIERS, Lists.newArrayList()).add("icon", SerializableDataType.ITEM_OR_ITEM_STACK, new class_1799((class_1935)class_1802.field_8162)).add("unchoosable", SerializableDataType.BOOLEAN, false).add("order", SerializableDataType.INT, Integer.MAX_VALUE).add("impact", SerializableDataType.IMPACT, Impact.NONE).add("loading_priority", SerializableDataType.INT, 0).add("upgrades", SerializableDataType.UPGRADES, null).add("name", SerializableDataType.STRING, "").add("description", SerializableDataType.STRING, "");
    public static final Origin EMPTY = Origin.register(new Origin(new class_2960("origins", "empty"), new class_1799((class_1935)class_1802.field_8162), Impact.NONE, -1, Integer.MAX_VALUE).setUnchoosable().setSpecial());
    private class_2960 identifier;
    private List<PowerType<?>> powerTypes = new LinkedList();
    private final class_1799 displayItem;
    private final Impact impact;
    private boolean isChoosable;
    private final int order;
    private final int loadingPriority;
    private List<OriginUpgrade> upgrades = new LinkedList<OriginUpgrade>();
    private boolean isSpecial;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public static void init() {
    }

    private static Origin register(Origin origin) {
        return OriginRegistry.register(origin);
    }

    public static HashMap<OriginLayer, Origin> get(class_1297 entity) {
        if (entity instanceof class_1657) {
            return Origin.get((class_1657)entity);
        }
        return new HashMap<OriginLayer, Origin>();
    }

    public static HashMap<OriginLayer, Origin> get(class_1657 player) {
        return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigins();
    }

    public Origin(class_2960 id, class_1799 icon, Impact impact, int order, int loadingPriority) {
        this.identifier = id;
        this.displayItem = icon.method_7972();
        this.impact = impact;
        this.isChoosable = true;
        this.order = order;
        this.loadingPriority = loadingPriority;
    }

    public Origin addUpgrade(OriginUpgrade upgrade) {
        this.upgrades.add(upgrade);
        return this;
    }

    public boolean hasUpgrade() {
        return this.upgrades.size() > 0;
    }

    public Optional<OriginUpgrade> getUpgrade(class_161 advancement) {
        for (OriginUpgrade upgrade : this.upgrades) {
            if (!upgrade.getAdvancementCondition().equals((Object)advancement.method_688())) continue;
            return Optional.of(upgrade);
        }
        return Optional.empty();
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public Origin add(PowerType<?> ... powerTypes) {
        this.powerTypes.addAll(Lists.newArrayList((Object[])powerTypes));
        return this;
    }

    protected Origin setUnchoosable() {
        this.isChoosable = false;
        return this;
    }

    public Origin setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Origin setName(String name) {
        this.nameTranslationKey = name;
        return this;
    }

    public Origin setDescription(String description) {
        this.descriptionTranslationKey = description;
        return this;
    }

    public boolean hasPowerType(PowerType<?> powerType) {
        if (powerType.getIdentifier() == null) {
            return false;
        }
        return this.powerTypes.contains(powerType);
    }

    public int getLoadingPriority() {
        return this.loadingPriority;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public Iterable<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "origin." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".name";
        }
        return this.nameTranslationKey;
    }

    public class_2588 getName() {
        return new class_2588(this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "origin." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public class_2588 getDescription() {
        return new class_2588(this.getOrCreateDescriptionTranslationKey());
    }

    public int getOrder() {
        return this.order;
    }

    public void write(class_2540 buffer) {
        SerializableData.Instance data = new SerializableData.Instance(DATA);
        data.set("icon", this.displayItem);
        data.set("impact", (Object)this.impact);
        data.set("order", this.order);
        data.set("loading_priority", this.loadingPriority);
        data.set("unchoosable", !this.isChoosable);
        data.set("powers", this.powerTypes.stream().map(PowerType::getIdentifier).collect(Collectors.toList()));
        data.set("name", this.getOrCreateNameTranslationKey());
        data.set("description", this.getOrCreateDescriptionTranslationKey());
        data.set("upgrades", this.upgrades);
        DATA.write(buffer, data);
    }

    public static Origin createFromData(class_2960 id, SerializableData.Instance data) {
        Origin origin = new Origin(id, (class_1799)data.get("icon"), (Impact)((Object)data.get("impact")), data.getInt("order"), data.getInt("loading_priority"));
        if (data.getBoolean("unchoosable")) {
            origin.setUnchoosable();
        }
        ((List)data.get("powers")).forEach(powerId -> {
            try {
                PowerType powerType = PowerTypeRegistry.get(powerId);
                origin.add(powerType);
                if (powerType instanceof MultiplePowerType) {
                    ImmutableList<class_2960> subPowers = ((MultiplePowerType)powerType).getSubPowers();
                    for (class_2960 subPowerId : subPowers) {
                        origin.add(PowerTypeRegistry.get(subPowerId));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.error("Origin \"" + id + "\" contained unregistered power: \"" + powerId + "\"");
            }
        });
        if (data.isPresent("upgrades")) {
            ((List)data.get("upgrades")).forEach(origin::addUpgrade);
        }
        origin.setName(data.getString("name"));
        origin.setDescription(data.getString("description"));
        return origin;
    }

    @Environment(value=EnvType.CLIENT)
    public static Origin read(class_2540 buffer) {
        class_2960 identifier = class_2960.method_12829((String)buffer.method_10800(Short.MAX_VALUE));
        return Origin.createFromData(identifier, DATA.read(buffer));
    }

    public static Origin fromJson(class_2960 id, JsonObject json) {
        return Origin.createFromData(id, DATA.read(json));
    }

    public String toString() {
        String str = "Origin(" + this.identifier.toString() + ")[";
        for (PowerType<?> pt : this.powerTypes) {
            str = str + PowerTypeRegistry.getId(pt);
            str = str + ",";
        }
        str = str.substring(0, str.length() - 1) + "]";
        return str;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Origin) {
            return ((Origin)obj).identifier.equals((Object)this.identifier);
        }
        return false;
    }
}

