/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.util.MultiJsonDataLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class OriginLayers
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    private static HashMap<class_2960, OriginLayer> layers = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginLayers() {
        super(GSON, "origin_layers");
    }

    protected void apply(Map<class_2960, List<JsonElement>> loader, class_3300 manager, class_3695 profiler) {
        OriginLayers.clear();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                Origins.LOGGER.info("Trying to read layer file: " + id);
                JsonObject jo = je.getAsJsonObject();
                boolean replace = class_3518.method_15258((JsonObject)jo, (String)"replace", (boolean)false);
                if (layers.containsKey(id)) {
                    if (replace) {
                        OriginLayer layer = OriginLayer.fromJson(id, jo);
                        layers.put((class_2960)id, layer);
                    } else {
                        Origins.LOGGER.info("Merging origin layer " + id.toString());
                        layers.get(id).merge(jo);
                    }
                } else {
                    OriginLayer layer = OriginLayer.fromJson(id, jo);
                    layers.put((class_2960)id, layer);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading Origin layer file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        Origins.LOGGER.info("Finished loading origin layers from data files. Read " + layers.size() + " layers.");
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(false);
    }

    public static OriginLayer getLayer(class_2960 id) {
        return layers.get(id);
    }

    public static Collection<OriginLayer> getLayers() {
        return layers.values();
    }

    public static int size() {
        return layers.size();
    }

    public static void clear() {
        layers.clear();
    }

    public static void add(OriginLayer layer) {
        layers.put(layer.getIdentifier(), layer);
    }

    public class_2960 getFabricId() {
        return new class_2960("origins", "origin_layers");
    }
}

