/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import io.github.apace100.origins.origin.Origin;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class OriginRegistry {
    private static HashMap<class_2960, Origin> idToOrigin = new HashMap();

    public static Origin register(Origin origin) {
        return OriginRegistry.register(origin.getIdentifier(), origin);
    }

    public static Origin register(class_2960 id, Origin origin) {
        if (idToOrigin.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate origin id tried to register: '" + id.toString() + "'");
        }
        idToOrigin.put(id, origin);
        return origin;
    }

    protected static Origin update(class_2960 id, Origin origin) {
        if (idToOrigin.containsKey(id)) {
            Origin old = idToOrigin.get(id);
            idToOrigin.remove(id);
        }
        return OriginRegistry.register(id, origin);
    }

    public static int size() {
        return idToOrigin.size();
    }

    public static Stream<class_2960> identifiers() {
        return idToOrigin.keySet().stream();
    }

    public static Iterable<Map.Entry<class_2960, Origin>> entries() {
        return idToOrigin.entrySet();
    }

    public static Iterable<Origin> values() {
        return idToOrigin.values();
    }

    public static Origin get(class_2960 id) {
        if (!idToOrigin.containsKey(id)) {
            throw new IllegalArgumentException("Could not get origin from id '" + id.toString() + "', as it was not registered!");
        }
        Origin origin = idToOrigin.get(id);
        return origin;
    }

    public static boolean contains(class_2960 id) {
        return idToOrigin.containsKey(id);
    }

    public static boolean contains(Origin origin) {
        return OriginRegistry.contains(origin.getIdentifier());
    }

    public static void clear() {
        idToOrigin.clear();
    }

    public static void reset() {
        OriginRegistry.clear();
        OriginRegistry.register(Origin.EMPTY);
    }
}

