/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.HudRendered;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import net.minecraft.class_1657;
import net.minecraft.class_2503;
import net.minecraft.class_2520;

public class CooldownPower
extends Power
implements HudRendered {
    private long lastUseTime;
    public final int cooldownDuration;
    private final HudRender hudRender;

    public CooldownPower(PowerType<?> type, class_1657 player, int cooldownDuration, HudRender hudRender) {
        super(type, player);
        this.cooldownDuration = cooldownDuration;
        this.hudRender = hudRender;
    }

    public boolean canUse() {
        return this.player.method_5770().method_8510() >= this.lastUseTime + (long)this.cooldownDuration && this.isActive();
    }

    public void use() {
        this.lastUseTime = this.player.method_5770().method_8510();
        OriginComponent.sync(this.player);
    }

    public float getProgress() {
        float time = this.player.method_5770().method_8510() - this.lastUseTime;
        return Math.min(1.0f, Math.max(time / (float)this.cooldownDuration, 0.0f));
    }

    public int getRemainingTicks() {
        return (int)Math.max(0L, (long)this.cooldownDuration - (this.player.method_5770().method_8510() - this.lastUseTime));
    }

    public void modify(int changeInTicks) {
        this.lastUseTime += (long)changeInTicks;
        long currentTime = this.player.method_5770().method_8510();
        if (this.lastUseTime > currentTime) {
            this.lastUseTime = currentTime;
        }
    }

    public void setCooldown(int cooldownInTicks) {
        long currentTime = this.player.method_5770().method_8510();
        this.lastUseTime = currentTime - (long)Math.min(cooldownInTicks, this.cooldownDuration);
    }

    @Override
    public class_2520 toTag() {
        return class_2503.method_23251((long)this.lastUseTime);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.lastUseTime = ((class_2503)tag).method_10699();
    }

    @Override
    public HudRender getRenderSettings() {
        return this.hudRender;
    }

    @Override
    public float getFill() {
        return this.getProgress();
    }

    @Override
    public boolean shouldRender() {
        return this.player.method_5770().method_8510() - this.lastUseTime <= (long)this.cooldownDuration;
    }
}

