/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1657;
import net.minecraft.class_1716;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3908;
import net.minecraft.class_747;

public class InventoryPower
extends Power
implements Active,
class_1263 {
    private final int size;
    private final class_2371<class_1799> inventory;
    private final class_2588 containerName;
    private final class_1270 factory;
    private final boolean shouldDropOnDeath;
    private final Predicate<class_1799> dropOnDeathFilter;
    private Active.Key key;

    public InventoryPower(PowerType<?> type, class_1657 player, String containerName, int size, boolean shouldDropOnDeath, Predicate<class_1799> dropOnDeathFilter) {
        super(type, player);
        this.size = size;
        this.inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.containerName = new class_2588(containerName);
        this.factory = (i, playerInventory, playerEntity) -> new class_1716(i, playerInventory, (class_1263)this);
        this.shouldDropOnDeath = shouldDropOnDeath;
        this.dropOnDeathFilter = dropOnDeathFilter;
    }

    @Override
    public void onUse() {
        if (!this.player.field_6002.field_9236) {
            this.player.method_17355((class_3908)new class_747(this.factory, (class_2561)this.containerName));
        }
    }

    @Override
    public class_2520 toTag() {
        class_2487 tag = new class_2487();
        class_1262.method_5426((class_2487)tag, this.inventory);
        return tag;
    }

    @Override
    public void fromTag(class_2520 tag) {
        class_1262.method_5429((class_2487)((class_2487)tag), this.inventory);
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return ((class_1799)this.inventory.get(slot)).method_7971(amount);
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = (class_1799)this.inventory.get(slot);
        this.method_5447(slot, class_1799.field_8037);
        return stack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return player == this.player;
    }

    public void method_5448() {
        for (int i = 0; i < this.size; ++i) {
            this.method_5447(i, class_1799.field_8037);
        }
    }

    public boolean shouldDropOnDeath() {
        return this.shouldDropOnDeath;
    }

    public boolean shouldDropOnDeath(class_1799 stack) {
        return this.shouldDropOnDeath && this.dropOnDeathFilter.test(stack);
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }
}

