/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class PowerTypeRegistry {
    private static HashMap<class_2960, PowerType> idToPower = new HashMap();

    public static PowerType register(class_2960 id, PowerType powerType) {
        if (idToPower.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate power type id tried to register: '" + id.toString() + "'");
        }
        idToPower.put(id, powerType);
        return powerType;
    }

    protected static PowerType update(class_2960 id, PowerType powerType) {
        if (idToPower.containsKey(id)) {
            PowerType old = idToPower.get(id);
            idToPower.remove(id);
        }
        return PowerTypeRegistry.register(id, powerType);
    }

    public static int size() {
        return idToPower.size();
    }

    public static Stream<class_2960> identifiers() {
        return idToPower.keySet().stream();
    }

    public static Iterable<Map.Entry<class_2960, PowerType>> entries() {
        return idToPower.entrySet();
    }

    public static Iterable<PowerType> values() {
        return idToPower.values();
    }

    public static PowerType get(class_2960 id) {
        if (!idToPower.containsKey(id)) {
            throw new IllegalArgumentException("Could not get power type from id '" + id.toString() + "', as it was not registered!");
        }
        PowerType powerType = idToPower.get(id);
        return powerType;
    }

    public static class_2960 getId(PowerType<?> powerType) {
        return powerType.getIdentifier();
    }

    public static boolean contains(class_2960 id) {
        return idToPower.containsKey(id);
    }

    public static void clear() {
        idToPower.clear();
    }

    public static void reset() {
        PowerTypeRegistry.clear();
    }
}

