/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;

public class BlockActions {
    public static void register() {
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("and"), new SerializableData().add("actions", SerializableDataType.BLOCK_ACTIONS), (data, block) -> ((List)data.get("actions")).forEach(e -> e.accept(block))));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("chance"), new SerializableData().add("action", SerializableDataType.BLOCK_ACTION).add("chance", SerializableDataType.FLOAT), (data, block) -> {
            Random random = new Random();
            if (random.nextFloat() < data.getFloat("chance")) {
                ((ActionFactory.Instance)data.get("action")).accept(block);
            }
        }));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("if_else"), new SerializableData().add("condition", SerializableDataType.BLOCK_CONDITION).add("if_action", SerializableDataType.BLOCK_ACTION).add("else_action", SerializableDataType.BLOCK_ACTION, null), (data, block) -> {
            if (((ConditionFactory.Instance)data.get("condition")).test(new class_2694((class_4538)block.getLeft(), (class_2338)block.getMiddle(), true))) {
                ((ActionFactory.Instance)data.get("if_action")).accept(block);
            } else if (data.isPresent("else_action")) {
                ((ActionFactory.Instance)data.get("else_action")).accept(block);
            }
        }));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("choice"), new SerializableData().add("actions", SerializableDataType.weightedList(SerializableDataType.BLOCK_ACTION)), (data, block) -> {
            FilterableWeightedList actionList = (FilterableWeightedList)((Object)((Object)data.get("actions")));
            ActionFactory.Instance action = (ActionFactory.Instance)actionList.method_23337(new Random());
            action.accept(block);
        }));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("offset"), new SerializableData().add("action", SerializableDataType.BLOCK_ACTION).add("x", SerializableDataType.INT, 0).add("y", SerializableDataType.INT, 0).add("z", SerializableDataType.INT, 0), (data, block) -> ((ActionFactory.Instance)data.get("action")).accept(Triple.of((Object)block.getLeft(), (Object)((class_2338)block.getMiddle()).method_10069(data.getInt("x"), data.getInt("y"), data.getInt("z")), (Object)block.getRight()))));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("set_block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> ((class_1937)block.getLeft()).method_8501((class_2338)block.getMiddle(), ((class_2248)data.get("block")).method_9564())));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("add_block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> ((class_1937)block.getLeft()).method_8501(((class_2338)block.getMiddle()).method_10093((class_2350)block.getRight()), ((class_2248)data.get("block")).method_9564())));
        BlockActions.register(new ActionFactory<Triple<class_1937, class_2338, class_2350>>(Origins.identifier("execute_command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4), (data, block) -> {
            MinecraftServer server = ((class_1937)block.getLeft()).method_8503();
            if (server != null) {
                String blockName = ((class_1937)block.getLeft()).method_8320((class_2338)block.getMiddle()).method_26204().method_9539();
                class_2168 source = new class_2168(class_2165.field_17395, new class_243((double)((class_2338)block.getMiddle()).method_10263() + 0.5, (double)((class_2338)block.getMiddle()).method_10264() + 0.5, (double)((class_2338)block.getMiddle()).method_10260() + 0.5), new class_241(0.0f, 0.0f), (class_3218)block.getLeft(), data.getInt("permission_level"), blockName, (class_2561)new class_2588(blockName), server, null);
                server.method_3734().method_9249(source, data.getString("command"));
            }
        }));
    }

    private static void register(ActionFactory<Triple<class_1937, class_2338, class_2350>> actionFactory) {
        class_2378.method_10230(ModRegistries.BLOCK_ACTION, (class_2960)actionFactory.getSerializerId(), actionFactory);
    }
}

