/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class BlockConditions {
    public static void register() {
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, block) -> data.getBoolean("value")));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("offset"), new SerializableData().add("condition", SerializableDataType.BLOCK_CONDITION).add("x", SerializableDataType.INT, 0).add("y", SerializableDataType.INT, 0).add("z", SerializableDataType.INT, 0), (data, block) -> ((ConditionFactory.Instance)data.get("condition")).test(new class_2694(block.method_11679(), block.method_11683().method_10069(data.getInt("x"), data.getInt("y"), data.getInt("z")), true))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("height"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, block) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(block.method_11683().method_10264(), data.getInt("compare_to"))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> block.method_11681().method_27852((class_2248)data.get("block"))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.BLOCK_TAG), (data, block) -> {
            if (block == null || block.method_11681() == null) {
                return false;
            }
            return block.method_11681().method_26164((class_3494)data.get("tag"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("adjacent"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("adjacent_condition", SerializableDataType.BLOCK_CONDITION), (data, block) -> {
            ConditionFactory.Instance adjacentCondition = (ConditionFactory.Instance)data.get("adjacent_condition");
            int adjacent = 0;
            for (class_2350 d : class_2350.values()) {
                if (!adjacentCondition.test(new class_2694(block.method_11679(), block.method_11683().method_10093(d), true))) continue;
                ++adjacent;
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(adjacent, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("replacable"), new SerializableData(), (data, block) -> block.method_11681().method_26207().method_15800()));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("attachable"), new SerializableData(), (data, block) -> {
            for (class_2350 d : class_2350.values()) {
                class_2338 adjacent = block.method_11683().method_10093(d);
                if (!block.method_11679().method_8320(adjacent).method_26206((class_1922)block.method_11679(), block.method_11683(), d.method_10153())) continue;
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("fluid"), new SerializableData().add("fluid_condition", SerializableDataType.FLUID_CONDITION), (data, block) -> ((ConditionFactory.Instance)data.get("fluid_condition")).test(block.method_11679().method_8316(block.method_11683()))));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("movement_blocking"), new SerializableData(), (data, block) -> block.method_11681().method_26207().method_15801() && !block.method_11681().method_26220((class_1922)block.method_11679(), block.method_11683()).method_1110()));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("light_blocking"), new SerializableData(), (data, block) -> block.method_11681().method_26207().method_15804()));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("water_loggable"), new SerializableData(), (data, block) -> block.method_11681().method_26204() instanceof class_2402));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("exposed_to_sky"), new SerializableData(), (data, block) -> block.method_11679().method_8311(block.method_11683())));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("light_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("light_type", SerializableDataType.enumValue(class_1944.class), null), (data, block) -> {
            int value;
            if (data.isPresent("light_type")) {
                class_1944 lightType = (class_1944)data.get("light_type");
                value = block.method_11679().method_8314(lightType, block.method_11683());
            } else {
                value = block.method_11679().method_22339(block.method_11683());
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<class_2694>(Origins.identifier("block_state"), new SerializableData().add("property", SerializableDataType.STRING).add("comparison", SerializableDataType.COMPARISON, null).add("compare_to", SerializableDataType.INT, null).add("value", SerializableDataType.BOOLEAN, null).add("enum", SerializableDataType.STRING, null), (data, block) -> {
            class_2680 state = block.method_11681();
            Collection properties = state.method_28501();
            String desiredPropertyName = data.getString("property");
            class_2769 property = null;
            for (class_2769 p : properties) {
                if (!p.method_11899().equals(desiredPropertyName)) continue;
                property = p;
                break;
            }
            if (property != null) {
                Comparable value = state.method_11654(property);
                if (data.isPresent("enum") && value instanceof Enum) {
                    return ((Enum)((Object)value)).name().equalsIgnoreCase(data.getString("enum"));
                }
                if (data.isPresent("value") && value instanceof Boolean) {
                    return ((Boolean)value).booleanValue() == data.getBoolean("value");
                }
                if (data.isPresent("comparison") && data.isPresent("compare_to") && value instanceof Integer) {
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Integer)value).intValue(), data.getInt("compare_to"));
                }
            }
            return false;
        }));
    }

    private static void register(ConditionFactory<class_2694> conditionFactory) {
        class_2378.method_10230(ModRegistries.BLOCK_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

