/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.access.MovingEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.mixin.EntityAccessor;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import io.github.apace100.origins.util.Shape;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1959;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3494;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.server.MinecraftServer;

public class EntityConditions {
    public static void register() {
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, entity) -> data.getBoolean("value")));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("block_collision"), new SerializableData().add("offset_x", SerializableDataType.FLOAT).add("offset_y", SerializableDataType.FLOAT).add("offset_z", SerializableDataType.FLOAT), (data, entity) -> entity.field_6002.method_20812((class_1297)entity, entity.method_5829().method_989((double)data.getFloat("offset_x") * entity.method_5829().method_17939(), (double)data.getFloat("offset_y") * entity.method_5829().method_17940(), (double)data.getFloat("offset_z") * entity.method_5829().method_17941())).findAny().isPresent()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("brightness"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_5718(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("daytime"), new SerializableData(), (data, entity) -> entity.field_6002.method_8532() % 24000L < 13000L));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("time_of_day"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.field_6002.method_8532() % 24000L, data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("fall_flying"), new SerializableData(), (data, entity) -> entity.method_6128()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("exposed_to_sun"), new SerializableData(), (data, entity) -> {
            if (entity.field_6002.method_8530() && !((EntityAccessor)entity).callIsBeingRainedOn()) {
                float f = entity.method_5718();
                class_2338 blockPos = entity.method_5854() instanceof class_1690 ? new class_2338(entity.method_23317(), (double)Math.round(entity.method_23318()), entity.method_23321()).method_10084() : new class_2338(entity.method_23317(), (double)Math.round(entity.method_23318()), entity.method_23321());
                return f > 0.5f && entity.field_6002.method_8311(blockPos);
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("in_rain"), new SerializableData(), (data, entity) -> ((EntityAccessor)entity).callIsBeingRainedOn()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("invisible"), new SerializableData(), (data, entity) -> entity.method_5767()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("on_fire"), new SerializableData(), (data, entity) -> entity.method_5809()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("exposed_to_sky"), new SerializableData(), (data, entity) -> {
            class_2338 blockPos = entity.method_5854() instanceof class_1690 ? new class_2338(entity.method_23317(), (double)Math.round(entity.method_23318()), entity.method_23321()).method_10084() : new class_2338(entity.method_23317(), (double)Math.round(entity.method_23318()), entity.method_23321());
            return entity.field_6002.method_8311(blockPos);
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("sneaking"), new SerializableData(), (data, entity) -> entity.method_5715()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("sprinting"), new SerializableData(), (data, entity) -> entity.method_5624()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("power_active"), new SerializableData().add("power", SerializableDataType.POWER_TYPE), (data, entity) -> ((PowerTypeReference)data.get("power")).isActive((class_1297)entity)));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("status_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT).add("min_amplifier", SerializableDataType.INT, 0).add("max_amplifier", SerializableDataType.INT, Integer.MAX_VALUE).add("min_duration", SerializableDataType.INT, 0).add("max_duration", SerializableDataType.INT, Integer.MAX_VALUE), (data, entity) -> {
            class_1291 effect = (class_1291)data.get("effect");
            if (effect == null) {
                return false;
            }
            if (entity.method_6059(effect)) {
                class_1293 instance = entity.method_6112(effect);
                return instance.method_5584() <= data.getInt("max_duration") && instance.method_5584() >= data.getInt("min_duration") && instance.method_5578() <= data.getInt("max_amplifier") && instance.method_5578() >= data.getInt("min_amplifier");
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("submerged_in"), new SerializableData().add("fluid", SerializableDataType.FLUID_TAG), (data, entity) -> entity.method_5777((class_3494)data.get("fluid"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("fluid_height"), new SerializableData().add("fluid", SerializableDataType.FLUID_TAG).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.DOUBLE), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_5861((class_3494)data.get("fluid")), data.getDouble("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("origin"), new SerializableData().add("origin", SerializableDataType.IDENTIFIER).add("layer", SerializableDataType.IDENTIFIER, null), (data, entity) -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get(entity);
            class_2960 originId = data.getId("origin");
            if (data.isPresent("layer")) {
                class_2960 layerId = data.getId("layer");
                OriginLayer layer = OriginLayers.getLayer(layerId);
                if (layer == null) {
                    return false;
                }
                Origin origin = component.getOrigin(layer);
                if (origin != null) {
                    return origin.getIdentifier().equals((Object)originId);
                }
                return false;
            }
            return component.getOrigins().values().stream().anyMatch(o -> o.getIdentifier().equals((Object)originId));
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("power"), new SerializableData().add("power", SerializableDataType.IDENTIFIER), (data, entity) -> {
            try {
                PowerType powerType = PowerTypeRegistry.get(data.getId("power"));
                return ((OriginComponent)ModComponents.ORIGIN.get(entity)).hasPower(powerType);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("food_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).method_7344().method_7586(), data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("saturation_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).method_7344().method_7589(), data.getFloat("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("on_block"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null), (data, entity) -> entity.method_24828() && (!data.isPresent("block_condition") || ((ConditionFactory.Instance)data.get("block_condition")).test(new class_2694((class_4538)entity.field_6002, entity.method_24515().method_10074(), true)))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("equipped_item"), new SerializableData().add("equipment_slot", SerializableDataType.EQUIPMENT_SLOT).add("item_condition", SerializableDataType.ITEM_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("item_condition")).test(entity.method_6118((class_1304)data.get("equipment_slot")))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("attribute"), new SerializableData().add("attribute", SerializableDataType.ATTRIBUTE).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.DOUBLE), (data, entity) -> {
            double attrValue = 0.0;
            class_1324 attributeInstance = entity.method_5996((class_1320)data.get("attribute"));
            if (attributeInstance != null) {
                attrValue = attributeInstance.method_6194();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(attrValue, data.getDouble("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("swimming"), new SerializableData(), (data, entity) -> entity.method_5681()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("resource"), new SerializableData().add("resource", SerializableDataType.POWER_TYPE).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            int resourceValue = 0;
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get(entity);
            Object p = component.getPower((PowerType)data.get("resource"));
            if (p instanceof VariableIntPower) {
                resourceValue = ((VariableIntPower)p).getValue();
            } else if (p instanceof CooldownPower) {
                resourceValue = ((CooldownPower)p).getRemainingTicks();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(resourceValue, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("air"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_5669(), data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("in_block"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("block_condition")).test(new class_2694((class_4538)entity.field_6002, entity.method_24515(), true))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("block_in_radius"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION).add("radius", SerializableDataType.INT).add("shape", SerializableDataType.enumValue(Shape.class), Shape.CUBE).add("compare_to", SerializableDataType.INT, 1).add("comparison", SerializableDataType.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL), (data, entity) -> {
            ConditionFactory.Instance blockCondition = (ConditionFactory.Instance)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            for (class_2338 pos : Shape.getPositions(entity.method_24515(), (Shape)((Object)((Object)data.get("shape"))), data.getInt("radius"))) {
                if (blockCondition.test(new class_2694((class_4538)entity.field_6002, pos, true)) && ++count == stopAt) break;
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("dimension"), new SerializableData().add("dimension", SerializableDataType.IDENTIFIER), (data, entity) -> entity.field_6002.method_27983() == class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)data.getId("dimension"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("xp_levels"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).field_7520, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("xp_points"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((class_1657)entity).field_7495, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("health"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_6032(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("relative_health"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.method_6032() / entity.method_6063(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("biome"), new SerializableData().add("biome", SerializableDataType.IDENTIFIER, null).add("biomes", SerializableDataType.IDENTIFIERS, null).add("condition", SerializableDataType.BIOME_CONDITION, null), (data, entity) -> {
            class_1959 biome = entity.field_6002.method_23753(entity.method_24515());
            ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("condition");
            if (data.isPresent("biome") || data.isPresent("biomes")) {
                class_2960 biomeId = entity.field_6002.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
                if (data.isPresent("biome") && biomeId.equals((Object)data.getId("biome"))) {
                    return condition == null || condition.test(biome);
                }
                if (data.isPresent("biomes") && ((List)data.get("biomes")).contains(biomeId)) {
                    return condition == null || condition.test(biome);
                }
                return false;
            }
            return condition == null || condition.test(biome);
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("entity_type"), new SerializableData().add("entity_type", SerializableDataType.ENTITY_TYPE), (data, entity) -> entity.method_5864() == data.get("entity_type")));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("scoreboard"), new SerializableData().add("objective", SerializableDataType.STRING).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                class_269 scoreboard = player.method_7327();
                class_266 objective = scoreboard.method_1165(data.getString("objective"));
                String playerName = player.method_5477().method_10851();
                if (scoreboard.method_1183(playerName, objective)) {
                    int value = scoreboard.method_1180(playerName, objective).method_1126();
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
                }
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            MinecraftServer server = entity.field_6002.method_8503();
            if (server != null) {
                class_2168 source = new class_2168(class_2165.field_17395, entity.method_19538(), entity.method_5802(), entity.field_6002 instanceof class_3218 ? (class_3218)entity.field_6002 : null, data.getInt("permission_level"), entity.method_5477().getString(), entity.method_5476(), server, (class_1297)entity);
                int output = server.method_3734().method_9249(source, data.getString("command"));
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(output, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("predicate"), new SerializableData().add("predicate", SerializableDataType.IDENTIFIER), (data, entity) -> {
            class_5341 lootCondition;
            MinecraftServer server = entity.field_6002.method_8503();
            if (server != null && (lootCondition = server.method_22828().method_22564((class_2960)data.get("predicate"))) != null) {
                class_47.class_48 lootBuilder = new class_47.class_48((class_3218)entity.field_6002).method_312(class_181.field_24424, (Object)entity.method_19538()).method_306(class_181.field_1226, entity);
                return lootCondition.test((Object)lootBuilder.method_309(class_173.field_20761));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("fall_distance"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.field_6017, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("collided_horizontally"), new SerializableData(), (data, entity) -> entity.field_5976));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("in_block_anywhere"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION).add("comparison", SerializableDataType.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataType.INT, 1), (data, entity) -> {
            ConditionFactory.Instance blockCondition = (ConditionFactory.Instance)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            class_238 box = entity.method_5829();
            class_2338 blockPos = new class_2338(box.field_1323 + 0.001, box.field_1322 + 0.001, box.field_1321 + 0.001);
            class_2338 blockPos2 = new class_2338(box.field_1320 - 0.001, box.field_1325 - 0.001, box.field_1324 - 0.001);
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263() && count < stopAt; ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264() && count < stopAt; ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260() && count < stopAt; ++k) {
                        mutable.method_10103(i, j, k);
                        if (!blockCondition.test(new class_2694((class_4538)entity.field_6002, (class_2338)mutable, false))) continue;
                        ++count;
                    }
                }
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("entity_group"), new SerializableData().add("group", SerializableDataType.ENTITY_GROUP), (data, entity) -> entity.method_6046() == (class_1310)data.get("group")));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.ENTITY_TAG), (data, entity) -> ((class_3494)data.get("tag")).method_15141((Object)entity.method_5864())));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("climbing"), new SerializableData(), (data, entity) -> entity.method_6101()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("tamed"), new SerializableData(), (data, entity) -> {
            if (entity instanceof class_1321) {
                return ((class_1321)entity).method_6181();
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("using_item"), new SerializableData().add("item_condition", SerializableDataType.ITEM_CONDITION, null), (data, entity) -> {
            if (entity.method_6115()) {
                ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("item_condition");
                if (condition != null) {
                    class_1268 activeHand = entity.method_6058();
                    class_1799 handStack = entity.method_5998(activeHand);
                    return condition.test(handStack);
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("moving"), new SerializableData(), (data, entity) -> ((MovingEntity)entity).isMoving()));
        EntityConditions.register(new ConditionFactory<class_1309>(Origins.identifier("enchantment"), new SerializableData().add("enchantment", SerializableDataType.ENCHANTMENT).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("calculation", SerializableDataType.STRING, "sum"), (data, entity) -> {
            String calculation;
            int value = 0;
            class_1887 enchantment = (class_1887)data.get("enchantment");
            switch (calculation = data.getString("calculation")) {
                case "sum": {
                    for (class_1799 stack : enchantment.method_8185(entity).values()) {
                        value += class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
                    }
                    break;
                }
                case "max": {
                    value = class_1890.method_8203((class_1887)enchantment, (class_1309)entity);
                    break;
                }
                default: {
                    Origins.LOGGER.error("Error in \"enchantment\" entity condition, undefined calculation type: \"" + calculation + "\".");
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
    }

    private static void register(ConditionFactory<class_1309> conditionFactory) {
        class_2378.method_10230(ModRegistries.ENTITY_CONDITION, (class_2960)conditionFactory.getSerializerId(), conditionFactory);
    }
}

