/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;

public class ChooseOriginScreen
extends class_437 {
    private static final class_2960 WINDOW = new class_2960("origins", "textures/gui/choose_origin.png");
    private ArrayList<OriginLayer> layerList;
    private int currentLayerIndex = 0;
    private int currentOrigin = 0;
    private List<Origin> originSelection;
    private int maxSelection = 0;
    private static final int windowWidth = 176;
    private static final int windowHeight = 182;
    private int scrollPos = 0;
    private int currentMaxScroll = 0;
    private int border = 13;
    private int guiTop;
    private int guiLeft;
    private boolean showDirtBackground;
    private Origin randomOrigin;
    private class_5250 randomOriginText;

    public ChooseOriginScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((class_2561)new class_2588("origins.screen.choose_origin"));
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(10);
        class_746 player = class_310.method_1551().field_1724;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        List<class_2960> originIdentifiers = currentLayer.getOrigins((class_1657)player);
        originIdentifiers.forEach(arg_0 -> this.lambda$new$0((class_1657)player, arg_0));
        this.originSelection.sort((a, b) -> {
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        this.maxSelection = this.originSelection.size();
        if (currentLayer.isRandomAllowed() && currentLayer.getRandomOrigins((class_1657)player).size() > 0) {
            ++this.maxSelection;
        }
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        this.showDirtBackground = showDirtBackground;
    }

    private void openNextLayerScreen() {
        class_310.method_1551().method_1507((class_437)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean method_25422() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
        this.method_25411((class_339)new class_4185(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585("<"), b -> {
            this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
            this.scrollPos = 0;
        }));
        this.method_25411((class_339)new class_4185(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585(">"), b -> {
            this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
            this.scrollPos = 0;
        }));
        this.method_25411((class_339)new class_4185(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (class_2561)new class_2588("origins.gui.select"), b -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            if (this.currentOrigin == this.originSelection.size()) {
                buf.method_10814(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((class_2960)ModPackets.CHOOSE_RANDOM_ORIGIN, (class_2540)buf);
            } else {
                buf.method_10814(this.getCurrentOrigin().getIdentifier().toString());
                buf.method_10814(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((class_2960)ModPackets.CHOOSE_ORIGIN, (class_2540)buf);
            }
            this.openNextLayerScreen();
        }));
    }

    private Origin getCurrentOrigin() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        this.randomOrigin = new Origin(Origins.identifier("random"), new class_1799((class_1935)ModItems.ORB_OF_ORIGIN), Impact.NONE, -1, Integer.MAX_VALUE);
        this.randomOriginText = new class_2585("");
        List<class_2960> randoms = this.layerList.get(this.currentLayerIndex).getRandomOrigins((class_1657)class_310.method_1551().field_1724);
        randoms.sort((ia, ib) -> {
            Origin a = OriginRegistry.get(ia);
            Origin b = OriginRegistry.get(ib);
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        for (class_2960 id : randoms) {
            this.randomOriginText.method_10852((class_2561)OriginRegistry.get(id).getName());
            this.randomOriginText.method_10852((class_2561)new class_2585("\n"));
        }
    }

    public void method_25433(class_4587 matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.method_25434(vOffset);
        } else {
            super.method_25433(matrices, vOffset);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        this.method_25420(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void renderOriginWindow(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(matrices, 16, 0);
        this.renderOriginContent(matrices, mouseX, mouseY);
        this.field_22787.method_1531().method_22813(WINDOW);
        this.method_25302(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        this.renderOriginName(matrices);
        this.field_22787.method_1531().method_22813(WINDOW);
        this.renderOriginImpact(matrices, mouseX, mouseY);
        class_2588 title = new class_2588("origins.gui.choose_origin.title", new Object[]{new class_2588(this.layerList.get(this.currentLayerIndex).getTranslationKey())});
        ChooseOriginScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)title.getString(), (int)(this.field_22789 / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(class_4587 matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            class_2588 ttc = (class_2588)new class_2588("origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            this.method_25424(matrices, (class_2561)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_4587 matrices) {
        class_5348 originName = this.field_22793.method_1714((class_5348)this.getCurrentOrigin().getName(), 140);
        ChooseOriginScreen.method_25303((class_4587)matrices, (class_327)this.field_22793, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        class_1799 is = this.getCurrentOrigin().getDisplayItem();
        this.field_22788.method_27953(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(class_4587 matrices, int offsetYStart, int offsetYEnd) {
        int endX = this.guiLeft + 176 - this.border;
        int endY = this.guiTop + 182 - this.border;
        this.field_22787.method_1531().method_22813(WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.method_25302(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_4587 matrices, int mouseX, int mouseY) {
        int y;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        class_2588 orgDesc = origin.getDescription();
        List descLines = this.field_22793.method_1728((class_5348)orgDesc, 140);
        for (class_5481 class_54812 : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, class_54812, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (origin == this.randomOrigin) {
            List drawLines = this.field_22793.method_1728((class_5348)this.randomOriginText, 140);
            for (class_5481 line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        } else {
            for (PowerType powerType : origin.getPowerTypes()) {
                if (powerType.isHidden()) continue;
                class_5481 name = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)powerType.getName().method_27692(class_124.field_1073), 140));
                class_2588 desc = powerType.getDescription();
                List drawLines = this.field_22793.method_1728((class_5348)desc, 140);
                if (y >= startY - 24 && y <= endY + 12) {
                    this.field_22793.method_27528(matrices, name, (float)x, (float)y, 0xFFFFFF);
                }
                for (class_5481 line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 182 - 15;
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private /* synthetic */ void lambda$new$0(class_1657 player, class_2960 originId) {
        Origin origin = OriginRegistry.get(originId);
        if (origin.isChoosable()) {
            class_1799 displayItem = origin.getDisplayItem();
            if (!(displayItem.method_7909() != class_1802.field_8575 || displayItem.method_7985() && displayItem.method_7969().method_10545("SkullOwner"))) {
                displayItem.method_7948().method_10582("SkullOwner", player.method_5476().getString());
            }
            this.originSelection.add(origin);
        }
    }
}

