/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.mixin.DamageSourceAccessor;
import io.github.apace100.origins.mixin.WeightedListEntryAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.action.ActionType;
import io.github.apace100.origins.power.factory.action.ActionTypes;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionType;
import io.github.apace100.origins.power.factory.condition.ConditionTypes;
import io.github.apace100.origins.util.AttributedEntityAttributeModifier;
import io.github.apace100.origins.util.ClassUtil;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.HudRender;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializationHelper;
import io.github.apace100.origins.util.Space;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5323;

public class SerializableDataType<T> {
    public static final SerializableDataType<Integer> INT = new SerializableDataType<Integer>(Integer.class, class_2540::writeInt, class_2540::readInt, JsonElement::getAsInt);
    public static final SerializableDataType<Boolean> BOOLEAN = new SerializableDataType<Boolean>(Boolean.class, class_2540::writeBoolean, class_2540::readBoolean, JsonElement::getAsBoolean);
    public static final SerializableDataType<Float> FLOAT = new SerializableDataType<Float>(Float.class, class_2540::writeFloat, class_2540::readFloat, JsonElement::getAsFloat);
    public static final SerializableDataType<Double> DOUBLE = new SerializableDataType<Double>(Double.class, class_2540::writeDouble, class_2540::readDouble, JsonElement::getAsDouble);
    public static final SerializableDataType<String> STRING = new SerializableDataType<String>(String.class, class_2540::method_10814, buf -> buf.method_10800(Short.MAX_VALUE), JsonElement::getAsString);
    public static final SerializableDataType<class_2960> IDENTIFIER = new SerializableDataType<class_2960>(class_2960.class, class_2540::method_10812, class_2540::method_10810, json -> {
        String idString = json.getAsString();
        if (idString.contains(":")) {
            String[] idSplit = idString.split(":");
            if (idSplit.length != 2) {
                throw new class_151("Incorrect number of `:` in identifier: \"" + idString + "\".");
            }
            if (idSplit[0].contains("*")) {
                if (PowerTypes.CURRENT_NAMESPACE != null) {
                    idSplit[0] = idSplit[0].replace("*", PowerTypes.CURRENT_NAMESPACE);
                } else {
                    throw new class_151("Identifier may only contain a `*` in the namespace inside of powers.");
                }
            }
            if (idSplit[1].contains("*")) {
                if (PowerTypes.CURRENT_PATH != null) {
                    idSplit[1] = idSplit[1].replace("*", PowerTypes.CURRENT_PATH);
                } else {
                    throw new class_151("Identifier may only contain a `*` in the path inside of powers.");
                }
            }
            idString = idSplit[0] + ":" + idSplit[1];
        } else if (idString.contains("*")) {
            if (PowerTypes.CURRENT_PATH != null) {
                idString = idString.replace("*", PowerTypes.CURRENT_PATH);
            } else {
                throw new class_151("Identifier may only contain a `*` in the path inside of powers.");
            }
        }
        return class_2960.method_12829((String)idString);
    });
    public static final SerializableDataType<List<class_2960>> IDENTIFIERS = SerializableDataType.list(IDENTIFIER);
    public static final SerializableDataType<Impact> IMPACT = SerializableDataType.enumValue(Impact.class);
    public static final SerializableDataType<OriginUpgrade> UPGRADE = new SerializableDataType<OriginUpgrade>(OriginUpgrade.class, (buf, upgrade) -> upgrade.write((class_2540)buf), OriginUpgrade::read, OriginUpgrade::fromJson);
    public static final SerializableDataType<List<OriginUpgrade>> UPGRADES = SerializableDataType.list(UPGRADE);
    public static final SerializableDataType<class_1887> ENCHANTMENT = SerializableDataType.registry(class_1887.class, class_2378.field_11160);
    public static final SerializableDataType<class_1282> DAMAGE_SOURCE = SerializableDataType.compound(class_1282.class, new SerializableData().add("name", STRING).add("bypasses_armor", BOOLEAN, false).add("fire", BOOLEAN, false).add("unblockable", BOOLEAN, false).add("magic", BOOLEAN, false).add("out_of_world", BOOLEAN, false), data -> {
        class_1282 damageSource = DamageSourceAccessor.createDamageSource(data.getString("name"));
        DamageSourceAccessor accessor = (DamageSourceAccessor)damageSource;
        if (data.getBoolean("bypasses_armor")) {
            accessor.callSetBypassesArmor();
        }
        if (data.getBoolean("fire")) {
            accessor.callSetFire();
        }
        if (data.getBoolean("unblockable")) {
            accessor.callSetUnblockable();
        }
        if (data.getBoolean("magic")) {
            accessor.callSetUsesMagic();
        }
        if (data.getBoolean("out_of_world")) {
            accessor.callSetOutOfWorld();
        }
        return damageSource;
    }, (data, ds) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("name", ds.field_5841);
        inst.set("fire", ds.method_5534());
        inst.set("unblockable", ds.method_5504());
        inst.set("bypasses_armor", ds.method_5537());
        inst.set("out_of_world", ds.method_5538());
        inst.set("magic", ds.method_5527());
        return inst;
    });
    public static final SerializableDataType<class_1320> ATTRIBUTE = SerializableDataType.registry(class_1320.class, class_2378.field_23781);
    public static final SerializableDataType<class_1322> ATTRIBUTE_MODIFIER = new SerializableDataType<class_1322>(class_1322.class, SerializationHelper::writeAttributeModifier, SerializationHelper::readAttributeModifier, SerializationHelper::readAttributeModifier);
    public static final SerializableDataType<class_1322.class_1323> MODIFIER_OPERATION = SerializableDataType.enumValue(class_1322.class_1323.class);
    public static final SerializableDataType<AttributedEntityAttributeModifier> ATTRIBUTED_ATTRIBUTE_MODIFIER = SerializableDataType.compound(AttributedEntityAttributeModifier.class, new SerializableData().add("attribute", ATTRIBUTE).add("operation", MODIFIER_OPERATION).add("value", DOUBLE).add("name", STRING, "Unnamed EntityAttributeModifier"), dataInst -> new AttributedEntityAttributeModifier((class_1320)dataInst.get("attribute"), new class_1322(dataInst.getString("name"), dataInst.getDouble("value"), (class_1322.class_1323)dataInst.get("operation"))), (data, inst) -> {
        SerializableData.Instance dataInst = (SerializableData)data.new SerializableData.Instance();
        dataInst.set("attribute", inst.getAttribute());
        dataInst.set("operation", inst.getModifier().method_6182());
        dataInst.set("value", inst.getModifier().method_6186());
        dataInst.set("name", inst.getModifier().method_6185());
        return dataInst;
    });
    public static final SerializableDataType<List<class_1322>> ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<List<AttributedEntityAttributeModifier>> ATTRIBUTED_ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTED_ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<PowerTypeReference> POWER_TYPE = SerializableDataType.wrap(PowerTypeReference.class, IDENTIFIER, PowerType::getIdentifier, PowerTypeReference::new);
    public static final SerializableDataType<class_1792> ITEM = SerializableDataType.registry(class_1792.class, class_2378.field_11142);
    public static final SerializableDataType<class_1291> STATUS_EFFECT = SerializableDataType.registry(class_1291.class, class_2378.field_11159);
    public static final SerializableDataType<List<class_1291>> STATUS_EFFECTS = SerializableDataType.list(STATUS_EFFECT);
    public static final SerializableDataType<class_1293> STATUS_EFFECT_INSTANCE = new SerializableDataType<class_1293>(class_1293.class, SerializationHelper::writeStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::readStatusEffect);
    public static final SerializableDataType<List<class_1293>> STATUS_EFFECT_INSTANCES = SerializableDataType.list(STATUS_EFFECT_INSTANCE);
    public static final SerializableDataType<class_3494<class_3611>> FLUID_TAG = SerializableDataType.wrap(ClassUtil.castClass(class_3494.class), IDENTIFIER, fluid -> class_5323.method_29223().method_30220().method_30212(fluid), SerializationHelper::getFluidTagFromId);
    public static final SerializableDataType<class_3494<class_2248>> BLOCK_TAG = SerializableDataType.wrap(ClassUtil.castClass(class_3494.class), IDENTIFIER, block -> class_5323.method_29223().method_30215().method_30212(block), SerializationHelper::getBlockTagFromId);
    public static final SerializableDataType<Comparison> COMPARISON = SerializableDataType.enumValue(Comparison.class, SerializationHelper.buildEnumMap(Comparison.class, Comparison::getComparisonString));
    public static final SerializableDataType<Space> SPACE = SerializableDataType.enumValue(Space.class);
    public static final SerializableDataType<ConditionFactory.Instance> ENTITY_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.ENTITY);
    public static final SerializableDataType<List<ConditionFactory.Instance>> ENTITY_CONDITIONS = SerializableDataType.list(ENTITY_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> ITEM_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.ITEM);
    public static final SerializableDataType<List<ConditionFactory.Instance>> ITEM_CONDITIONS = SerializableDataType.list(ITEM_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> BLOCK_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.BLOCK);
    public static final SerializableDataType<List<ConditionFactory.Instance>> BLOCK_CONDITIONS = SerializableDataType.list(BLOCK_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> FLUID_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.FLUID);
    public static final SerializableDataType<List<ConditionFactory.Instance>> FLUID_CONDITIONS = SerializableDataType.list(FLUID_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> DAMAGE_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.DAMAGE);
    public static final SerializableDataType<List<ConditionFactory.Instance>> DAMAGE_CONDITIONS = SerializableDataType.list(DAMAGE_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> BIOME_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.BIOME);
    public static final SerializableDataType<List<ConditionFactory.Instance>> BIOME_CONDITIONS = SerializableDataType.list(BIOME_CONDITION);
    public static final SerializableDataType<ActionFactory.Instance> ENTITY_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.ENTITY);
    public static final SerializableDataType<List<ActionFactory.Instance>> ENTITY_ACTIONS = SerializableDataType.list(ENTITY_ACTION);
    public static final SerializableDataType<ActionFactory.Instance> BLOCK_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.BLOCK);
    public static final SerializableDataType<List<ActionFactory.Instance>> BLOCK_ACTIONS = SerializableDataType.list(BLOCK_ACTION);
    public static final SerializableDataType<ActionFactory.Instance> ITEM_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.ITEM);
    public static final SerializableDataType<List<ActionFactory.Instance>> ITEM_ACTIONS = SerializableDataType.list(ITEM_ACTION);
    public static final SerializableDataType<class_1856> INGREDIENT = new SerializableDataType<class_1856>(class_1856.class, (buffer, ingredient) -> ingredient.method_8088(buffer), class_1856::method_8086, class_1856::method_8102);
    public static final SerializableDataType<class_2248> BLOCK = SerializableDataType.registry(class_2248.class, class_2378.field_11146);
    public static final SerializableDataType<HudRender> HUD_RENDER = SerializableDataType.compound(HudRender.class, new SerializableData().add("should_render", BOOLEAN, true).add("bar_index", INT, 0).add("sprite_location", IDENTIFIER, Origins.identifier("textures/gui/resource_bar.png")).add("condition", ENTITY_CONDITION, null), dataInst -> new HudRender(dataInst.getBoolean("should_render"), dataInst.getInt("bar_index"), dataInst.getId("sprite_location"), (ConditionFactory.Instance)dataInst.get("condition")), (data, inst) -> {
        SerializableData.Instance dataInst = (SerializableData)data.new SerializableData.Instance();
        dataInst.set("should_render", inst.shouldRender());
        dataInst.set("bar_index", inst.getBarIndex());
        dataInst.set("sprite_location", inst.getSpriteLocation());
        dataInst.set("condition", inst.getCondition());
        return dataInst;
    });
    public static final SerializableDataType<class_1310> ENTITY_GROUP = SerializableDataType.mapped(class_1310.class, HashBiMap.create((Map)ImmutableMap.of((Object)"default", (Object)class_1310.field_6290, (Object)"undead", (Object)class_1310.field_6289, (Object)"arthropod", (Object)class_1310.field_6293, (Object)"illager", (Object)class_1310.field_6291, (Object)"aquatic", (Object)class_1310.field_6292)));
    public static final SerializableDataType<class_1304> EQUIPMENT_SLOT = SerializableDataType.enumValue(class_1304.class);
    public static final SerializableDataType<class_3414> SOUND_EVENT = SerializableDataType.registry(class_3414.class, class_2378.field_11156);
    public static final SerializableDataType<class_1299<?>> ENTITY_TYPE = SerializableDataType.registry(ClassUtil.castClass(class_1299.class), class_2378.field_11145);
    public static final SerializableDataType<class_2396<?>> PARTICLE_TYPE = SerializableDataType.registry(ClassUtil.castClass(class_2396.class), class_2378.field_11141);
    public static final SerializableDataType<class_2487> NBT = SerializableDataType.wrap(class_2487.class, STRING, class_2487::toString, str -> {
        try {
            return new class_2522(new StringReader(str)).method_10727();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Could not parse NBT tag, exception: " + e.getMessage());
        }
    });
    public static final SerializableDataType<class_1799> ITEM_STACK = SerializableDataType.compound(class_1799.class, new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null), data -> {
        class_1799 stack = new class_1799((class_1935)((class_1792)data.get("item")), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.method_7980((class_2487)data.get("tag"));
        }
        return stack;
    }, (serializableData, itemStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", itemStack.method_7909());
        data.set("amount", itemStack.method_7947());
        data.set("tag", itemStack.method_7985() ? itemStack.method_7969() : null);
        return data;
    });
    public static final SerializableDataType<List<class_1799>> ITEM_STACKS = SerializableDataType.list(ITEM_STACK);
    public static final SerializableDataType<class_3545<Integer, class_1799>> POSITIONED_ITEM_STACK = SerializableDataType.compound(ClassUtil.castClass(class_3545.class), new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null).add("slot", INT, Integer.MIN_VALUE), data -> {
        class_1799 stack = new class_1799((class_1935)((class_1792)data.get("item")), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.method_7980((class_2487)data.get("tag"));
        }
        return new class_3545((Object)data.getInt("slot"), (Object)stack);
    }, (serializableData, positionedStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", ((class_1799)positionedStack.method_15441()).method_7909());
        data.set("amount", ((class_1799)positionedStack.method_15441()).method_7947());
        data.set("tag", ((class_1799)positionedStack.method_15441()).method_7985() ? ((class_1799)positionedStack.method_15441()).method_7969() : null);
        data.set("slot", positionedStack.method_15442());
        return data;
    });
    public static final SerializableDataType<List<class_3545<Integer, class_1799>>> POSITIONED_ITEM_STACKS = SerializableDataType.list(POSITIONED_ITEM_STACK);
    public static SerializableDataType<class_5321<class_1937>> DIMENSION = SerializableDataType.wrap(ClassUtil.castClass(class_5321.class), IDENTIFIER, class_5321::method_29177, identifier -> class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)identifier));
    public static final SerializableDataType<Active.Key> KEY = SerializableDataType.compound(Active.Key.class, new SerializableData().add("key", STRING).add("continuous", BOOLEAN, false), data -> {
        Active.Key key = new Active.Key();
        key.key = data.getString("key");
        key.continuous = data.getBoolean("continuous");
        return key;
    }, (serializableData, key) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("key", key.key);
        data.set("continuous", key.continuous);
        return data;
    });
    public static final SerializableDataType<Active.Key> BACKWARDS_COMPATIBLE_KEY = new SerializableDataType<Active.Key>(Active.Key.class, SerializableDataType.KEY.send, SerializableDataType.KEY.receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            String keyString = jsonElement.getAsString();
            Active.Key key = new Active.Key();
            key.key = keyString.equals("secondary") ? "key.origins.secondary_active" : "key.origins.primary_active";
            key.continuous = false;
            return key;
        }
        return (Active.Key)SerializableDataType.KEY.read.apply((JsonElement)jsonElement);
    });
    public static final SerializableDataType<class_3494<class_1299<?>>> ENTITY_TAG = SerializableDataType.wrap(ClassUtil.castClass(class_3494.class), IDENTIFIER, tag -> class_5323.method_29223().method_30221().method_30212(tag), TagRegistry::entityType);
    public static final SerializableDataType<class_1860> RECIPE = new SerializableDataType<class_1860>(class_1860.class, (buffer, recipe) -> {
        buffer.method_10812(class_2378.field_17598.method_10221((Object)recipe.method_8119()));
        buffer.method_10812(recipe.method_8114());
        recipe.method_8119().method_8124(buffer, recipe);
    }, buffer -> {
        class_2960 recipeSerializerId = buffer.method_10810();
        class_2960 recipeId = buffer.method_10810();
        class_1865 serializer = (class_1865)class_2378.field_17598.method_10223(recipeSerializerId);
        return serializer.method_8122(recipeId, buffer);
    }, jsonElement -> {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Expected recipe to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        class_2960 recipeSerializerId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"type"));
        class_2960 recipeId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"id"));
        class_1865 serializer = (class_1865)class_2378.field_17598.method_10223(recipeSerializerId);
        return serializer.method_8121(recipeId, json);
    });
    public static final SerializableDataType<class_1799> ITEM_OR_ITEM_STACK = new SerializableDataType<class_1799>(class_1799.class, SerializableDataType.ITEM_STACK.send, SerializableDataType.ITEM_STACK.receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            class_1792 item = ITEM.read((JsonElement)jsonElement);
            return new class_1799((class_1935)item);
        }
        return (class_1799)SerializableDataType.ITEM_STACK.read.apply((JsonElement)jsonElement);
    });
    private final Class<T> dataClass;
    private final BiConsumer<class_2540, T> send;
    private final Function<class_2540, T> receive;
    private final Function<JsonElement, T> read;

    public SerializableDataType(Class<T> dataClass, BiConsumer<class_2540, T> send, Function<class_2540, T> receive, Function<JsonElement, T> read) {
        this.dataClass = dataClass;
        this.send = send;
        this.receive = receive;
        this.read = read;
    }

    public void send(class_2540 buffer, Object value) {
        this.send.accept(buffer, (class_2540)this.cast(value));
    }

    public T receive(class_2540 buffer) {
        return this.receive.apply(buffer);
    }

    public T read(JsonElement jsonElement) {
        return this.read.apply(jsonElement);
    }

    public T cast(Object data) {
        return this.dataClass.cast(data);
    }

    public static <T> SerializableDataType<List<T>> list(SerializableDataType<T> singleDataType) {
        return new SerializableDataType<List<T>>(ClassUtil.castClass(List.class), (buf, list) -> {
            buf.writeInt(list.size());
            for (Object elem : list) {
                singleDataType.send((class_2540)buf, elem);
            }
        }, buf -> {
            int count = buf.readInt();
            LinkedList list = new LinkedList();
            for (int i = 0; i < count; ++i) {
                list.add(singleDataType.receive((class_2540)buf));
            }
            return list;
        }, json -> {
            LinkedList list = new LinkedList();
            if (json.isJsonArray()) {
                for (JsonElement je : json.getAsJsonArray()) {
                    list.add(singleDataType.read(je));
                }
            } else {
                list.add(singleDataType.read((JsonElement)json));
            }
            return list;
        });
    }

    public static <T> SerializableDataType<T> registry(Class<T> dataClass, class_2378<T> registry) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> buf.method_10812(registry.method_10221(t)), buf -> registry.method_10223(buf.method_10810()), json -> {
            class_2960 id = class_2960.method_12829((String)json.getAsString());
            if (!registry.method_10235().contains(id)) {
                throw new RuntimeException("Identifier \"" + id + "\" was not registered in registry \"" + registry.method_30517().method_29177() + "\".");
            }
            return registry.method_10223(id);
        });
    }

    public static <T> SerializableDataType<T> compound(Class<T> dataClass, SerializableData data, Function<SerializableData.Instance, T> toInstance, BiFunction<SerializableData, T, SerializableData.Instance> toData) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> data.write((class_2540)buf, (SerializableData.Instance)toData.apply(data, t)), buf -> toInstance.apply(data.read((class_2540)buf)), json -> toInstance.apply(data.read(json.getAsJsonObject())));
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass) {
        return SerializableDataType.enumValue(dataClass, null);
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass, HashMap<String, T> additionalMap) {
        return new SerializableDataType<Enum>(dataClass, (buf, t) -> buf.writeInt(t.ordinal()), buf -> ((Enum[])dataClass.getEnumConstants())[buf.readInt()], json -> {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    int enumOrdinal = primitive.getAsInt();
                    Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                    if (enumOrdinal < 0 || enumOrdinal >= enumValues.length) {
                        throw new JsonSyntaxException("Expected to be in the range of 0 - " + (enumValues.length - 1));
                    }
                    return enumValues[enumOrdinal];
                }
                if (primitive.isString()) {
                    String enumName = primitive.getAsString();
                    try {
                        Object t = Enum.valueOf(dataClass, enumName);
                        return t;
                    }
                    catch (IllegalArgumentException e0) {
                        try {
                            Object t = Enum.valueOf(dataClass, enumName.toUpperCase(Locale.ROOT));
                            return t;
                        }
                        catch (IllegalArgumentException e1) {
                            try {
                                if (additionalMap == null || !additionalMap.containsKey(enumName)) {
                                    throw new IllegalArgumentException();
                                }
                                Enum t = (Enum)additionalMap.get(enumName);
                                return t;
                            }
                            catch (IllegalArgumentException e2) {
                                Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                                String stringOf = enumValues[0].name() + ", " + enumValues[0].name().toLowerCase(Locale.ROOT);
                                for (int i = 1; i < enumValues.length; ++i) {
                                    stringOf = stringOf + ", " + enumValues[i].name() + ", " + enumValues[i].name().toLowerCase(Locale.ROOT);
                                }
                                throw new JsonSyntaxException("Expected value to be a string of: " + stringOf);
                            }
                        }
                    }
                }
            }
            throw new JsonSyntaxException("Expected value to be either an integer or a string.");
        });
    }

    public static <T> SerializableDataType<T> mapped(Class<T> dataClass, BiMap<String, T> map) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> buf.method_10814((String)map.inverse().get(t)), buf -> map.get((Object)buf.method_10800(Short.MAX_VALUE)), json -> {
            JsonPrimitive primitive;
            if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
                String name = primitive.getAsString();
                try {
                    if (map == null || !map.containsKey((Object)name)) {
                        throw new IllegalArgumentException();
                    }
                    Object t = map.get((Object)name);
                    return t;
                }
                catch (IllegalArgumentException e2) {
                    throw new JsonSyntaxException("Expected value to be a string of: " + map.keySet().stream().reduce((s0, s1) -> s0 + ", " + s1));
                }
            }
            throw new JsonSyntaxException("Expected value to be either a string.");
        });
    }

    public static <T> SerializableDataType<ConditionFactory.Instance> condition(Class<ConditionFactory.Instance> dataClass, ConditionType<T> conditionType) {
        return new SerializableDataType<ConditionFactory.Instance>(dataClass, conditionType::write, conditionType::read, conditionType::read);
    }

    public static <T> SerializableDataType<ActionFactory.Instance> effect(Class<ActionFactory.Instance> dataClass, ActionType<T> actionType) {
        return new SerializableDataType<ActionFactory.Instance>(dataClass, actionType::write, actionType::read, actionType::read);
    }

    public static <T, U> SerializableDataType<T> wrap(Class<T> dataClass, SerializableDataType<U> base, Function<T, U> toFunction, Function<U, T> fromFunction) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> base.send((class_2540)buf, toFunction.apply(t)), buf -> fromFunction.apply(base.receive((class_2540)buf)), json -> fromFunction.apply(base.read((JsonElement)json)));
    }

    public static <T> SerializableDataType<FilterableWeightedList<T>> weightedList(SerializableDataType<T> base) {
        return new SerializableDataType<FilterableWeightedList<T>>(ClassUtil.castClass(FilterableWeightedList.class), (buf, list) -> {
            buf.writeInt(list.size());
            list.entryStream().forEach(entry -> {
                base.send((class_2540)buf, entry.method_19035());
                buf.writeInt(((WeightedListEntryAccessor)entry).getWeight());
            });
        }, buf -> {
            int count = buf.readInt();
            FilterableWeightedList list = new FilterableWeightedList();
            for (int i = 0; i < count; ++i) {
                Object t = base.receive((class_2540)buf);
                int weight = buf.readInt();
                list.method_19031(t, weight);
            }
            return list;
        }, json -> {
            FilterableWeightedList list = new FilterableWeightedList();
            if (json.isJsonArray()) {
                for (JsonElement je : json.getAsJsonArray()) {
                    JsonObject weightedObj = je.getAsJsonObject();
                    Object elem = base.read(weightedObj.get("element"));
                    int weight = class_3518.method_15260((JsonObject)weightedObj, (String)"weight");
                    list.method_19031(elem, weight);
                }
            }
            return list;
        });
    }
}

