/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1322;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3611;

public class SerializationHelper {
    public static class_3494<class_3611> getFluidTagFromId(class_2960 id) {
        Optional<class_3494.class_5123> tag = class_3486.method_29897().stream().filter(f -> f.method_26791().equals((Object)id)).findAny();
        if (tag.isPresent()) {
            return (class_3494)tag.get();
        }
        return TagRegistry.fluid((class_2960)id);
    }

    public static class_3494<class_2248> getBlockTagFromId(class_2960 id) {
        return TagRegistry.block((class_2960)id);
    }

    public static class_1322 readAttributeModifier(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            String name = class_3518.method_15253((JsonObject)json, (String)"name", (String)"Unnamed attribute modifier");
            String operation = class_3518.method_15265((JsonObject)json, (String)"operation").toUpperCase(Locale.ROOT);
            double value = class_3518.method_15259((JsonObject)json, (String)"value");
            return new class_1322(name, value, class_1322.class_1323.valueOf((String)operation));
        }
        throw new JsonSyntaxException("Attribute modifier needs to be a JSON object.");
    }

    public static class_1322 readAttributeModifier(class_2540 buf) {
        String modName = buf.method_10800(Short.MAX_VALUE);
        double modValue = buf.readDouble();
        int operation = buf.readInt();
        return new class_1322(modName, modValue, class_1322.class_1323.method_6190((int)operation));
    }

    public static void writeAttributeModifier(class_2540 buf, class_1322 modifier) {
        buf.method_10814(modifier.method_6185());
        buf.writeDouble(modifier.method_6186());
        buf.writeInt(modifier.method_6182().method_6191());
    }

    public static void writeAttributeModifier(class_1322 modifier, class_2540 buf) {
        buf.method_10814(modifier.method_6185());
        buf.writeDouble(modifier.method_6186());
        buf.writeInt(modifier.method_6182().method_6191());
    }

    public static class_1293 readStatusEffect(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            String effect = class_3518.method_15265((JsonObject)json, (String)"effect");
            Optional effectOptional = class_2378.field_11159.method_17966(class_2960.method_12829((String)effect));
            if (!effectOptional.isPresent()) {
                throw new JsonSyntaxException("Error reading status effect: could not find status effect with id: " + effect);
            }
            int duration = class_3518.method_15282((JsonObject)json, (String)"duration", (int)100);
            int amplifier = class_3518.method_15282((JsonObject)json, (String)"amplifier", (int)0);
            boolean ambient = class_3518.method_15258((JsonObject)json, (String)"is_ambient", (boolean)false);
            boolean showParticles = class_3518.method_15258((JsonObject)json, (String)"show_particles", (boolean)true);
            boolean showIcon = class_3518.method_15258((JsonObject)json, (String)"show_icon", (boolean)true);
            return new class_1293((class_1291)effectOptional.get(), duration, amplifier, ambient, showParticles, showIcon);
        }
        throw new JsonSyntaxException("Expected status effect to be a json object.");
    }

    public static class_1293 readStatusEffect(class_2540 buf) {
        class_2960 effect = buf.method_10810();
        int duration = buf.readInt();
        int amplifier = buf.readInt();
        boolean ambient = buf.readBoolean();
        boolean showParticles = buf.readBoolean();
        boolean showIcon = buf.readBoolean();
        return new class_1293((class_1291)class_2378.field_11159.method_10223(effect), duration, amplifier, ambient, showParticles, showIcon);
    }

    public static void writeStatusEffect(class_2540 buf, class_1293 statusEffectInstance) {
        buf.method_10812(class_2378.field_11159.method_10221((Object)statusEffectInstance.method_5579()));
        buf.writeInt(statusEffectInstance.method_5584());
        buf.writeInt(statusEffectInstance.method_5578());
        buf.writeBoolean(statusEffectInstance.method_5591());
        buf.writeBoolean(statusEffectInstance.method_5581());
        buf.writeBoolean(statusEffectInstance.method_5592());
    }

    public static <T extends Enum<T>> HashMap<String, T> buildEnumMap(Class<T> enumClass, Function<T, String> enumToString) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            map.put(enumToString.apply(enumConstant), enumConstant);
        }
        return map;
    }
}

