/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.attribute;

import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;

public class GlVertexAttribute {
    private final int index;
    private final int format;
    private final int count;
    private final int pointer;
    private final int size;
    private final int stride;
    private final boolean normalized;

    public GlVertexAttribute(int index, GlVertexAttributeFormat format, int count, boolean normalized, int pointer, int stride) {
        this.index = index;
        this.format = format.getGlFormat();
        this.size = format.getSize() * count;
        this.count = count;
        this.normalized = normalized;
        this.pointer = pointer;
        this.stride = stride;
    }

    public static <T extends Enum<T>> Builder<T> builder(Class<T> type, int stride) {
        return new Builder<T>(type, stride);
    }

    public int getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getPointer() {
        return this.pointer;
    }

    public int getCount() {
        return this.count;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public int getStride() {
        return this.stride;
    }

    public static class Builder<T extends Enum<T>> {
        private final EnumMap<T, GlVertexAttribute> attributes;
        private final Class<T> type;
        private final int stride;

        public Builder(Class<T> type, int stride) {
            this.type = type;
            this.attributes = new EnumMap(type);
            this.stride = stride;
        }

        public Builder<T> addElement(T type, int pointer, GlVertexAttributeFormat format, int count, boolean normalized) {
            return this.addElement(type, new GlVertexAttribute(this.attributes.size(), format, count, normalized, pointer, this.stride));
        }

        private Builder<T> addElement(T type, GlVertexAttribute attribute) {
            if (attribute.pointer >= this.stride) {
                throw new IllegalArgumentException("Element starts outside vertex format");
            }
            if (attribute.pointer + attribute.size > this.stride) {
                throw new IllegalArgumentException("Element extends outside vertex format");
            }
            if (this.attributes.put(type, attribute) != null) {
                throw new IllegalStateException("Generic attribute " + ((Enum)type).name() + " already defined in vertex format");
            }
            return this;
        }

        public GlVertexFormat<T> build() {
            int size = 0;
            for (Enum key : (Enum[])this.type.getEnumConstants()) {
                GlVertexAttribute attribute = this.attributes.get(key);
                if (attribute == null) {
                    throw new NullPointerException("Generic attribute not assigned to enumeration " + key.name());
                }
                size = Math.max(size, (int)((long)attribute.getPointer() + attribute.getSize()));
            }
            if (this.stride < size) {
                throw new IllegalArgumentException("Stride is too small");
            }
            return new GlVertexFormat<T>(this.type, this.attributes, this.stride);
        }
    }
}

